<div>
    <div class="page-content">
        <div class="main-wrapper">

            <!-- Header -->
            <div class="card border-0 shadow-sm mb-4" style="background:linear-gradient(135deg,#1e40af,#3b82f6);">
                <div class="card-body p-4 text-white">
                    <div class="d-flex align-items-center gap-3">
                        @if($guardian->avatar && Str::startsWith($guardian->avatar, 'http'))
                            <img src="{{ $guardian->avatar }}" alt="{{ $guardian->name }}"
                                 class="rounded-circle" style="width:60px;height:60px;object-fit:cover;border:2px solid rgba(255,255,255,.3);">
                        @else
                            <div class="rounded-circle d-flex align-items-center justify-content-center"
                                 style="width:60px;height:60px;background:rgba(255,255,255,.2);font-size:22px;">
                                <i class="fas fa-user"></i>
                            </div>
                        @endif
                        <div>
                            <h4 class="mb-0 fw-bold">{{ $guardian->name }}</h4>
                            <p class="mb-0 opacity-75 small">
                                {{ $guardian->relationship_label }} &nbsp;|&nbsp; {{ $guardian->phone }}
                            </p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row g-4">
                <!-- Dados Pessoais -->
                <div class="col-md-6">
                    <div class="card border-0 shadow-sm h-100">
                        <div class="card-header bg-white py-3">
                            <h6 class="mb-0 fw-semibold"><i class="fas fa-user-edit me-2 text-primary"></i>Dados Pessoais</h6>
                        </div>
                        <div class="card-body">
                            <form wire:submit.prevent="updateProfile">
                                <div class="mb-3">
                                    <div class="form-floating">
                                        <input type="text" class="form-control @error('name') is-invalid @enderror"
                                               id="name" placeholder="Nome completo" wire:model="name">
                                        <label for="name">Nome completo</label>
                                        @error('name')
                                            <span class="invalid-feedback"><strong>{{ $message }}</strong></span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <div class="form-floating">
                                        <input type="tel" class="form-control @error('phone') is-invalid @enderror"
                                               id="phone" placeholder="Telefone" wire:model="phone">
                                        <label for="phone">Telefone</label>
                                        @error('phone')
                                            <span class="invalid-feedback"><strong>{{ $message }}</strong></span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <div class="form-floating">
                                        <input type="email" class="form-control @error('email') is-invalid @enderror"
                                               id="email" placeholder="E-mail" wire:model="email">
                                        <label for="email">E-mail (opcional)</label>
                                        @error('email')
                                            <span class="invalid-feedback"><strong>{{ $message }}</strong></span>
                                        @enderror
                                    </div>
                                </div>
                                <button type="submit" class="btn btn-primary float-end"
                                        wire:loading.attr="disabled" wire:target="updateProfile">
                                    <span wire:loading.remove wire:target="updateProfile">
                                        <i class="fas fa-save me-1"></i>Guardar
                                    </span>
                                    <span wire:loading wire:target="updateProfile">
                                        <span class="spinner-border spinner-border-sm me-1"></span>A guardar...
                                    </span>
                                </button>
                            </form>
                        </div>
                    </div>
                </div>

                <!-- Alterar Palavra-passe -->
                <div class="col-md-6">
                    <div class="card border-0 shadow-sm h-100">
                        <div class="card-header bg-white py-3">
                            <h6 class="mb-0 fw-semibold"><i class="fas fa-lock me-2 text-warning"></i>Alterar Palavra-passe</h6>
                        </div>
                        <div class="card-body">
                            <form wire:submit.prevent="updatePassword">
                                <div class="mb-3">
                                    <div class="form-floating">
                                        <input type="password" class="form-control @error('current_password') is-invalid @enderror"
                                               id="current_password" placeholder="Palavra-passe actual" wire:model="current_password">
                                        <label for="current_password">Palavra-passe actual</label>
                                        @error('current_password')
                                            <span class="invalid-feedback"><strong>{{ $message }}</strong></span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <div class="form-floating">
                                        <input type="password" class="form-control @error('password') is-invalid @enderror"
                                               id="password" placeholder="Nova palavra-passe" wire:model="password">
                                        <label for="password">Nova palavra-passe</label>
                                        @error('password')
                                            <span class="invalid-feedback"><strong>{{ $message }}</strong></span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <div class="form-floating">
                                        <input type="password" class="form-control @error('password_confirmation') is-invalid @enderror"
                                               id="password_confirmation" placeholder="Confirmar palavra-passe" wire:model="password_confirmation">
                                        <label for="password_confirmation">Confirmar palavra-passe</label>
                                    </div>
                                </div>
                                <button type="submit" class="btn btn-warning float-end"
                                        wire:loading.attr="disabled" wire:target="updatePassword">
                                    <span wire:loading.remove wire:target="updatePassword">
                                        <i class="fas fa-key me-1"></i>Alterar
                                    </span>
                                    <span wire:loading wire:target="updatePassword">
                                        <span class="spinner-border spinner-border-sm me-1"></span>A alterar...
                                    </span>
                                </button>
                            </form>

                            <div class="mt-4 p-3 bg-light rounded-3 small text-muted" style="clear:both;">
                                <i class="fas fa-info-circle text-primary me-1"></i>
                                A palavra-passe deve ter pelo menos <strong>6 caracteres</strong>.
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>
