<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Declaração - {{ $certificate->certificate_number }}</title>
    <style>
        @page {
            size: A4 portrait;
            margin: 15mm 20mm;
        }

        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }

        body {
            font-family: 'Times New Roman', Times, serif;
            color: #000;
            font-size: 12pt;
            line-height: 1.5;
        }

        .container {
            width: 100%;
            max-width: 700px;
            margin: 0 auto;
        }

        /* Header Section */
        .header {
            text-align: center;
            margin-bottom: 25px;
            padding-bottom: 15px;
            border-bottom: 2px solid #1a5276;
        }

        .logo-section {
            margin-bottom: 10px;
        }

        .logo-section img {
            max-height: 80px;
            max-width: 200px;
        }

        .school-name {
            font-size: 18pt;
            font-weight: bold;
            color: #1a5276;
            text-transform: uppercase;
            margin-bottom: 5px;
        }

        /* Declaration Title */
        .declaration-title {
            text-align: center;
            font-size: 18pt;
            font-weight: bold;
            text-decoration: underline;
            margin: 25px 0;
            color: #1a5276;
        }

        /* Body Text */
        .body-intro {
            font-size: 11pt;
            line-height: 1.8;
            margin-bottom: 15px;
        }

        .student-name-highlight {
            text-align: center;
            font-size: 16pt;
            font-weight: bold;
            margin: 20px 0;
            padding: 10px;
            background-color: #f8f9fa;
            border-left: 4px solid #1a5276;
        }

        .student-details {
            font-size: 11pt;
            line-height: 1.8;
            margin-bottom: 20px;
            text-align: justify;
        }

        /* Grades Table */
        .grades-section {
            margin: 25px 0;
        }

        .grades-table {
            width: 100%;
            border-collapse: collapse;
            font-size: 10pt;
            margin-bottom: 15px;
        }

        .grades-table th {
            background-color: #1a5276;
            color: white;
            border: 1px solid #1a5276;
            padding: 6px 4px;
            text-align: center;
            font-weight: bold;
            font-size: 9pt;
        }

        .grades-table td {
            border: 1px solid #ddd;
            padding: 5px 4px;
            text-align: center;
            font-size: 10pt;
        }

        .grades-table tr:nth-child(even) {
            background-color: #f9f9f9;
        }

        .grades-table .subject-name {
            text-align: left;
            padding-left: 8px;
            font-weight: 500;
        }

        .grades-table .total-row {
            font-weight: bold;
            background-color: #e8f4f8;
        }

        /* Closing Text */
        .closing-text {
            font-size: 11pt;
            line-height: 1.8;
            margin: 25px 0;
            text-align: justify;
        }

        /* Date and Signature */
        .date-section {
            text-align: right;
            margin: 30px 0;
            font-size: 11pt;
        }

        .signature-section {
            text-align: center;
            margin-top: 50px;
        }

        .signature-line {
            width: 250px;
            border-bottom: 1px solid #000;
            margin: 0 auto 5px auto;
        }

        .signature-name {
            font-weight: bold;
            font-size: 11pt;
        }

        .signature-title {
            font-size: 10pt;
            color: #555;
        }

        /* Footer */
        .footer {
            position: fixed;
            bottom: 10mm;
            left: 20mm;
            right: 20mm;
            text-align: center;
            font-size: 8pt;
            color: #666;
            border-top: 1px solid #ddd;
            padding-top: 5px;
        }

        .footer p {
            margin: 2px 0;
        }

        /* QR Code Section */
        .qr-section {
            position: fixed;
            bottom: 25mm;
            left: 20mm;
            text-align: center;
        }

        .qr-section img {
            width: 60px;
            height: 60px;
        }

        .qr-section p {
            font-size: 6pt;
            color: #666;
            margin-top: 2px;
        }

        .verification-info {
            position: fixed;
            bottom: 25mm;
            right: 20mm;
            font-size: 7pt;
            color: #666;
            text-align: right;
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Header with Logo -->
        <div class="header">
            <div class="logo-section">
                @php
                    $logoPath = public_path('images/certificates/copmoz_logo.png');
                    if (!file_exists($logoPath)) {
                        $logoPath = public_path('avatars/avatars/Logotipo COPMOZ.png');
                    }
                    $logoData = file_exists($logoPath) ? base64_encode(file_get_contents($logoPath)) : '';
                @endphp
                @if($logoData)
                <img src="data:image/png;base64,{{ $logoData }}" alt="Logo COPMOZ">
                @endif
            </div>
            <p class="school-name">Colégio Politécnico de Moçambique</p>
        </div>

        <!-- Declaration Title -->
        <h1 class="declaration-title">Declaração de Passagem</h1>

        <!-- Body Text -->
        @php
            $directorName = 'AFIZAL MAMUDO GULAMO';

            // Parse student data
            $student = $certificate->student ?? null;
            $studentName = $certificate->student_name;
            $studentSexFilho = $certificate->student_sex == 'M' ? 'Filho' : 'Filha';
            $studentSexNascido = $certificate->student_sex == 'M' ? 'nascido' : 'nascida';
            $studentSexPortador = $certificate->student_sex == 'M' ? 'portador' : 'portadora';

            $fatherName = $student?->father_name ?? '---';
            $motherName = $student?->mother_name ?? '---';

            $birthPlace = $student?->birth_place ?? 'Nampula';
            $birthDistrict = $student?->birth_district ?? 'Nampula';
            $birthProvince = $student?->birth_province ?? 'Nampula';

            $idNumber = $student?->bi_number ?? $student?->id_number ?? '---';

            $months = ['Janeiro', 'Fevereiro', 'Março', 'Abril', 'Maio', 'Junho', 'Julho', 'Agosto', 'Setembro', 'Outubro', 'Novembro', 'Dezembro'];
            $dob = $certificate->student_dob ? \Carbon\Carbon::parse($certificate->student_dob) : null;
            $dobFormatted = $dob ? $dob->format('d') . ' de ' . $months[$dob->month - 1] . ' de ' . $dob->format('Y') : '---';

            // Get turma letter from turma name (e.g., "12A1" -> "A1")
            $turmaLetter = preg_replace('/^\d+/', '', $certificate->turma_name);

            $comportamento = 'Bom';
        @endphp

        <p class="body-intro">
            <strong>Colégio Politécnico de Moçambique</strong>, representado pelo seu Director Geral <strong>{{ $directorName }}</strong>, declara que
        </p>

        <div class="student-name-highlight">
            {{ $studentName }}
        </div>

        <p class="student-details">
            {{ $studentSexFilho }}(a) de <strong>{{ $fatherName }}</strong> e de <strong>{{ $motherName }}</strong>, {{ $studentSexNascido }}(a) aos {{ $dobFormatted }}, natural de {{ $birthPlace }}, distrito de {{ $birthDistrict }}, província de {{ $birthProvince }}, {{ $studentSexPortador }}(a) de Bilhete de Identidade nº: <strong>{{ $idNumber }}</strong>, frequentou e terminou com sucesso a <strong>{{ $certificate->class_level }}ª Classe</strong>, turma <strong>{{ $turmaLetter }}</strong>, no ano <strong>{{ $certificate->academic_year }}</strong>, sob código <strong>{{ $certificate->student_id_number }}</strong> do Curso Diurno, com o comportamento <strong>{{ $comportamento }}</strong> e as seguintes classificações por disciplina:
        </p>

        <!-- Grades Table -->
        <div class="grades-section">
            <table class="grades-table">
                <thead>
                    <tr>
                        <th style="width: 30%;">Disciplina</th>
                        <th style="width: 10%;">1º Trim</th>
                        <th style="width: 10%;">2º Trim</th>
                        <th style="width: 10%;">3º Trim</th>
                        <th style="width: 10%;">MFD</th>
                        @if($hasNE ?? false)
                        <th style="width: 10%;">NE</th>
                        @endif
                        <th style="width: 12%;">NF</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($certificate->subject_grades as $subject => $grades)
                    <tr>
                        <td class="subject-name">{{ $subject }}</td>
                        <td>{{ $grades['nf1'] }}</td>
                        <td>{{ $grades['nf2'] }}</td>
                        <td>{{ $grades['nf3'] }}</td>
                        <td>{{ $grades['mfd'] }}</td>
                        @if($hasNE ?? false)
                        <td>{{ $grades['ne'] !== null && $grades['ne'] > 0 ? $grades['ne'] : '-' }}</td>
                        @endif
                        <td><strong>{{ $grades['final'] }}</strong></td>
                    </tr>
                    @endforeach
                    <tr class="total-row">
                        <td class="subject-name"><strong>MÉDIA FINAL</strong></td>
                        <td colspan="{{ ($hasNE ?? false) ? 5 : 4 }}"></td>
                        <td><strong>{{ number_format($certificate->final_average, 0) }}</strong></td>
                    </tr>
                </tbody>
            </table>
        </div>

        <!-- Closing Text -->
        <p class="closing-text">
            Por ser verdade, mandou passar a presente declaração que assina e autentica com o selo branco em uso nesta instituição de ensino.
        </p>

        <!-- Date -->
        @php
            $issueDate = $certificate->issued_at ?? now();
            $issueDateMonth = $months[$issueDate->month - 1];
        @endphp
        <p class="date-section">
            Nampula, {{ $issueDate->format('d') }} de {{ $issueDateMonth }} de {{ $issueDate->format('Y') }}
        </p>

        <!-- Signature -->
        <div class="signature-section">
            <div class="signature-line"></div>
            <p class="signature-name">{{ $directorName }}</p>
            <p class="signature-title">Director Geral</p>
        </div>
    </div>

    <!-- QR Code -->
    <div class="qr-section">
        <img src="data:image/png;base64,{{ $qrCode }}" alt="QR Code">
        <p>Verificar autenticidade</p>
        <p>{{ $certificate->certificate_number }}</p>
    </div>

    <div class="verification-info">
        <p>Documento verificável em:</p>
        <p>{{ str_replace(['http://', 'https://'], '', url('/')) }}/verificar-certificado</p>
    </div>

    <!-- Footer -->
    <div class="footer">
        <p>Moçambique – Nampula, Bairro de Muhala-Expansão, rua nº 2307; contacto: +258842508080 – Registo Académico</p>
        <p>Email: secretaria@copmoz.ac.mz</p>
    </div>
</body>
</html>
