<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Recibo de Pagamento</title>
    <style>
        @page { size: A4; margin: 15mm; }

        * { box-sizing: border-box; margin: 0; padding: 0; }

        body {
            font-family: Arial, DejaVu Sans, sans-serif;
            color: #000;
            font-size: 10px;
            line-height: 1.3;
        }

        .page-wrap {
            max-width: 700px;
            margin: 0 auto;
            border: 2px solid #000;
            padding: 12px;
        }

        .header {
            text-align: center;
            margin-bottom: 10px;
            padding-bottom: 8px;
            border-bottom: 2px solid #000;
        }

        .header h1 {
            font-size: 18px;
            font-weight: bold;
            margin-bottom: 4px;
            text-transform: uppercase;
        }

        .header .institution {
            font-size: 11px;
            font-weight: bold;
            margin-bottom: 3px;
        }

        .header .details {
            font-size: 8px;
            margin-top: 3px;
        }

        .receipt-number {
            text-align: right;
            margin-bottom: 8px;
            font-weight: bold;
            font-size: 10px;
        }

        .section {
            margin: 8px 0;
        }

        .section-title {
            font-weight: bold;
            text-decoration: underline;
            margin-bottom: 4px;
            font-size: 10px;
        }

        .info-row {
            display: flex;
            margin: 3px 0;
            padding: 2px 0;
        }

        .info-label {
            font-weight: bold;
            width: 140px;
            flex-shrink: 0;
        }

        .info-value {
            flex: 1;
            border-bottom: 1px dotted #000;
            padding-left: 5px;
        }

        .amount-box {
            border: 2px solid #000;
            padding: 8px;
            margin: 10px 0;
            background-color: #f9f9f9;
        }

        .amount-box .label {
            font-weight: bold;
            font-size: 10px;
            margin-bottom: 4px;
        }

        .amount-box .numeric {
            font-size: 16px;
            font-weight: bold;
            text-align: center;
            padding: 6px;
            background: white;
            border: 1px solid #000;
            margin-bottom: 4px;
        }

        .amount-box .extenso {
            font-size: 9px;
            font-style: italic;
            text-align: center;
            padding: 3px;
            border-top: 1px solid #000;
            padding-top: 4px;
        }

        .payment-details {
            margin: 8px 0;
            padding: 6px;
            border: 1px solid #000;
        }

        .payment-details table {
            width: 100%;
            border-collapse: collapse;
        }

        .payment-details th,
        .payment-details td {
            padding: 3px;
            text-align: left;
            border-bottom: 1px solid #ccc;
            font-size: 9px;
        }

        .payment-details th {
            font-weight: bold;
            background-color: #f0f0f0;
        }

        .footer {
            margin-top: 25px;
            padding-top: 10px;
            border-top: 2px solid #000;
            text-align: center;
            font-size: 8px;
        }

        .no-break { page-break-inside: avoid; }

        .text-right { text-align: right; }
        .text-center { text-align: center; }
        .bold { font-weight: bold; }

        /* Selo PAGO */
        .paid-stamp {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%) rotate(-25deg);
            border: 6px solid #27ae60;
            color: #27ae60;
            font-size: 60px;
            font-weight: bold;
            padding: 15px 40px;
            border-radius: 15px;
            opacity: 0.15;
            text-transform: uppercase;
            letter-spacing: 8px;
            z-index: 1;
        }

        .paid-badge {
            background-color: #27ae60;
            color: white;
            padding: 8px 20px;
            border-radius: 5px;
            font-weight: bold;
            font-size: 12px;
            display: inline-block;
            margin: 10px 0;
            text-transform: uppercase;
        }

        .paid-badge-icon {
            font-size: 14px;
            margin-right: 5px;
        }
    </style>
</head>
<body>
    <div class="page-wrap" style="position: relative;">
        <!-- Selo PAGO (marca d'água) -->
        <div class="paid-stamp">PAGO</div>

        <!-- Cabeçalho -->
        <div class="header no-break">
            <h1>RECIBO</h1>
            <div class="institution">COLÉGIO POLITÉCNICO DE MOÇAMBIQUE</div>
            <div class="details">
                Nampula - Moçambique<br>
                NUIT: [NÚMERO] | Tel: +258 [TELEFONE]
            </div>
        </div>

        <!-- Número do Recibo e Badge PAGO -->
        <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 8px;">
            <div class="receipt-number" style="margin-bottom: 0;">
                Nº {{ $receipt_number ?? str_pad($payment->id ?? '001', 6, '0', STR_PAD_LEFT) . '/' . date('Y') }}
            </div>
            <div class="paid-badge">
                <span class="paid-badge-icon">✓</span> PAGO
            </div>
        </div>

        <!-- Data e Local -->
        <div class="info-row">
            <span class="info-label">Nampula, aos</span>
            <span class="info-value">{{ $paid_at->format('d') }} de {{ $paid_at->locale('pt')->translatedFormat('F') }} de {{ $paid_at->format('Y') }}</span>
        </div>

        <!-- Dados do Pagador -->
        <div class="section no-break">
            <div class="section-title">RECEBI DE:</div>
            <div class="info-row">
                <span class="info-label">Nome:</span>
                <span class="info-value">{{ strtoupper($student->name ?? 'N/A') }}</span>
            </div>
            <div class="info-row">
                <span class="info-label">Nº do Estudante:</span>
                <span class="info-value">{{ $student->student_id ?? $student->id }}</span>
            </div>
            @if(isset($student->class))
            <div class="info-row">
                <span class="info-label">Classe/Turma:</span>
                <span class="info-value">{{ $student->class->class ?? 'N/A' }} - {{ $student->classroom->name ?? 'N/A' }}</span>
            </div>
            @endif
        </div>

        <!-- Valor -->
        <div class="amount-box no-break">
            <div class="label">A QUANTIA DE:</div>
            <div class="numeric">{{ number_format($amount_paid, 2, ',', '.') }} MT</div>
            <div class="extenso">
                ( {{ ucfirst(\App\Helpers\NumberToWords::convert($amount_paid)) }} Meticais )
            </div>
        </div>

        <!-- Referente a -->
        <div class="section no-break">
            <div class="section-title">REFERENTE A:</div>
            <div class="info-row">
                <span class="info-label">Descrição:</span>
                <span class="info-value">Pagamento de Propina - {{ $payment->fee_month }}/{{ $payment->fee_year }}</span>
            </div>
        </div>

        <!-- Detalhes do Pagamento -->
        <div class="payment-details no-break">
            <table>
                <thead>
                    <tr>
                        <th>Descrição</th>
                        <th style="text-align: right;">Valor (MT)</th>
                    </tr>
                </thead>
                <tbody>
                    @if(isset($base_amount) && $base_amount > 0)
                    <tr>
                        <td>Propina Base - {{ $payment->fee_month }}/{{ $payment->fee_year }}</td>
                        <td style="text-align: right;">{{ number_format($base_amount, 2, ',', '.') }}</td>
                    </tr>
                    @endif
                    @if(isset($fine_amount) && $fine_amount > 0)
                    <tr>
                        <td>Multa por Atraso</td>
                        <td style="text-align: right;">{{ number_format($fine_amount, 2, ',', '.') }}</td>
                    </tr>
                    @endif
                    @if(isset($discount_amount) && $discount_amount > 0)
                    <tr>
                        <td>Desconto Aplicado</td>
                        <td style="text-align: right;">-{{ number_format($discount_amount, 2, ',', '.') }}</td>
                    </tr>
                    @endif
                    <tr style="font-weight: bold; background-color: #f0f0f0;">
                        <td>TOTAL PAGO</td>
                        <td style="text-align: right;">{{ number_format($amount_paid, 2, ',', '.') }}</td>
                    </tr>
                </tbody>
            </table>
        </div>

        <!-- Forma de Pagamento -->
        <div class="info-row">
            <span class="info-label">Forma de Pagamento:</span>
            <span class="info-value">
                @if(isset($transaction_id) && $transaction_id)
                    <strong>POS - Transaction ID: {{ $transaction_id }}</strong>
                @else
                    {{ $payment_method ?? 'Pagamento via Referência' }}
                @endif
            </span>
        </div>

        @if(isset($reference_formatted) || (isset($payment->reference_number) && $payment->reference_number))
        <div class="info-row">
            <span class="info-label">Referência:</span>
            <span class="info-value">{{ $reference_formatted ?? $payment->reference_number }}</span>
        </div>
        @endif


        <!-- Observações -->
        @if(isset($notes) && !empty($notes))
        <div class="section">
            <div class="section-title">OBSERVAÇÕES:</div>
            <p style="padding: 5px 0;">{{ $notes }}</p>
        </div>
        @endif

        <!-- Rodapé -->
        <div class="footer no-break">
            <p><strong>RECIBO ELETRÓNICO - Válido sem assinatura ou carimbo</strong></p>
            <p style="margin-top: 5px;">Documento gerado automaticamente pelo sistema em {{ now()->format('d/m/Y \à\s H:i:s') }}</p>
            <p style="margin-top: 3px; font-size: 9px;">
                Para verificação da autenticidade deste documento, contacte o departamento financeiro com o número do recibo
            </p>
        </div>
    </div>
</body>
</html>
