<?php

namespace App\Http\Livewire\Admin\Paymentconformation;

use App\Models\Admin;

use App\Models\Classroom;
use App\Models\User;

use App\Models\PaymentConfirmation;
use Illuminate\Validation\ValidationException;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Note\Note;
use App\Http\Controllers\SystemController;
use App\Models\Category;
use Livewire\WithFileUploads;

class AddPayment extends Component
{
    use FindGuard, LivewireAlert, WithFileUploads;

    public $title, $description, $category_id, $photo,$pdf,$author,  $validatedData, $type, $class_id, $student_id;
    public $updateMode = false;
    public $user;
    protected $listeners = [
        'confirmed',
        'cancelled'
    ];

    protected array $rules = [
        'title' => ['required', 'string', 'max:255'],
        'photo' => ['required'], // 2MB Max
        //'pdf' => ['required', 'mimes:pdf'], // 2MB Max
    ];

    /**
     * D0 real time validations
     * @param $propertyName
     * @throws ValidationException
     */
    public function updated($propertyName)
    {
        $this->validateOnly($propertyName);

    }

    public function submit()
    {
        //$this->validatedData = $this->validate();

        $details = SystemController::store_media($this->photo);
        //$pdfd = SystemController::store_media($this->pdf);
        if(empty($this->type)){
            $this->type = "all";
        }
        $downloadcenter = PaymentConfirmation::query()->create([
            'title' => $this->title,
            'media_name'=> $details[0],
            'media_url'=>$details[1],
            'type'=>$this->type,
            'class_id'=> $this->class_id,
            'student_id'=>$this->student_id,
            
        ]);




        Note::createSystemNotification(Admin::class, 'Conf. de pagamento', 'Nova conf. de pagamento com sucesso ' . $this->title);
        $this->emit('noteAdded');
        $this->alert('success', 'Nova conf. de pagamento adicionada com sucesso ' . $this->title . $downloadcenter->slug);
        $this->reset();
        /*$this->confirm('Tem certeza de que deseja prosseguir?', [
            'toast' => false,
            'position' => 'center',
            'showConfirmButton' => true,
            'confirmButtonText' => 'Sim, eu tenho certeza!',
            'cancelButtonText' => 'Não, cancelar!',
            'onConfirmed' => 'confirmed',
            'onDismissed' => 'cancelled'
        ]);*/
    }

    public function confirmed()
    {

        
    }

    public function cancelled()
    {
        $this->alert('error', 'Você cancelou.');
    }
    public function render()
    {
        if(!empty($this->type)){
            return view('livewire.admin.paymentconfirmation.add-payment', [
                'Classroom' => Classroom::query()->orderBy('class')->get(),
                'students' => User::Where("classroom_id",$this->class_id)->get(),
            ]);
        }else{
            return view('livewire.admin.paymentconfirmation.add-payment', [
                'Classroom' => Classroom::query()->orderBy('class')->get(),
            ]);
        }
    }
}
