<?php

namespace App\Jobs;

use App\Mail\MailNote;
use Exception;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;

class MailJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(
        private readonly string      $name,
        private readonly string      $email,
        private readonly string      $subject,
        private readonly string      $body,
        private readonly bool        $show_btn = false,
        private readonly string|null $url = null,
        private readonly string|null $btn_name = null
    )
    {
        //
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle(): void
    {
        try {
            // send an email here
            Mail::to($this->email)->send(new MailNote(
                $this->name,
                $this->email,
                $this->subject,
                $this->body,
                $this->show_btn,
                $this->url,
                $this->btn_name
            ));
        } catch (Exception $exception) {
            Log::info('Mail failed to send to ' . $this->email);
            Log::error($exception->getMessage());
        }
    }
}
