<div>
    <div class="container">
        <div class="row justify-content-md-center">
            <div class="col-md-12 col-lg-4">
                <div class="card login-box-container">
                    <div class="card-body">
                        <div class="authent-logo">
                            <a href="{{ route('index') }}"> <img src="{{ asset('assets/images/logo.png') }}" alt=""
                                                                 style="width:300px"></a>
                        </div>
                        <div class="authent-text">
                            <p>Criar a sua conta</p>
                            <p>Por favor, cadastre-se para acessar nossos serviços.</p>
                            @include('inc.alert')
                        </div>
                        <form wire:submit.prevent="register">
                            <div class="mb-3">
                                <div class="form-floating">
                                    <input type="text" class="form-control @error('name') is-invalid @enderror"
                                           id="name" required placeholder="Insira o nome completo..." wire:model="name">
                                    <label for="name">Nome completo</label>
                                    @error('name')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="mb-3">
                                <div class="form-floating">
                                    <input type="email" class="form-control @error('email') is-invalid @enderror"
                                           id="email" required placeholder="Email..." wire:model="email">
                                    <label for="email">E-mail</label>
                                    @error('email')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="mb-3">
                                <div class="form-floating">
                                    <input type="text" class="form-control @error('phone_number') is-invalid @enderror"
                                           id="phone_number" required placeholder="258..." wire:model="phone_number">
                                    <label for="phone_number">Número celular</label>
                                    @error('phone_number')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="mb-3">
                                <div class="form-floating">
                                    <input type="password" class="form-control @error('password') is-invalid @enderror"
                                           id="password" required placeholder="xxxxxx" wire:model="password">
                                    <label for="password">Senha</label>
                                    @error('password')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="mb-3">
                                <div class="form-floating">
                                    <input type="password" class="form-control" name="password_confirmation"
                                           id="password_confirmation" required placeholder="xxxxxx" wire:model="password_confirmation">
                                    <label for="password_confirmation">Confirmar senha</label>
                                </div>
                            </div>
                            <div class="d-grid">
                                <button type="submit" class="btn btn-primary m-b-xs" wire:loading.class="disabled"
                                        wire:offline.attr="disabled"><span wire:target="loginUser"
                                                                           wire:loading.class="spinner-border spinner-border-lg"></span>
                                                                           Registar
                                </button>
                                <a href="{{ route('login') }}" class="btn btn-outline-success">Em vez disso, faça login!</a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
