<div>
    <div class="page-content" wire:poll.keep-alive>
      
        <div class="main-wrapper" wire:init="loadData">
               <div class="row">
            <div class="col-md-12">
                <input type="search" wire:model="search" placeholder="Pesquisar livro..."
                       class="form-control">
            </div>
        </div><br><br>
            @if (count($models))
                <div class="row">
                    @foreach ($models as $model)
                        <div class="col-md-3 col-lg-3">
                            <div class="card h-100">
                                <img src="{{ $model->media_url }}" class="card-img-top" alt="..." style="height:200px">
                                <div class="card-body">
                                    <h6>{{ $model->title }} &nbsp; <i>por: {{ $model->author }}</i></h6>
                                    <p class="card-text">{!! Str::limit($model->description, 50, ' .......') !!}</p>
                                    <a href="{{ route('user.show.book', $model->slug) }}"
                                        class="btn btn-outline-primary"><span class="fa fa-eye">&nbspVer descrição</span>
                                    </a>
                                    <a href="{{ route('user.show.book.chapter', $model->slug) }}"
                                        class="btn btn-outline-primary"><span class="fa fa-eye">&nbspMostrar capitulos
                                            {{ $model->chapters->count() }}</span>
                                    </a>
                                     <a href="{{ route('user.pd', $model->slug) }}"
                                        class="btn btn-outline-info btn-sm"> <span class="fas fa-book-reader">&nbspLer livro</i></span>
                                    </a>
                                    <br>
                                    <button wire:click="submit('{{ $model->id }}')"
                                        class="btn btn-primary btn-sm">Marcar como preferido
                                    </button>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
                <div class="row float-end">
                    {{ $models->links() }}
                </div>
            @else
                <br>
                <br>
                <div class="d-flex justify-content-center">
                    <div wire:loading class="spinner-border text-primary" role="status">
                        <span class="sr-only">Processando...</span>
                    </div>
                </div>
                <p class="text-center"><B>Nenhum dado foi encontrado no momento.</B></p>
            @endif
        </div>

    </div>
</div>
