<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class CleanAllPayments extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'payments:clean-all
                            {--force : Executar sem confirmação}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Limpar referências de pagamento e reconciliações falhadas';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->warn('╔════════════════════════════════════════════════════════╗');
        $this->warn('║  ATENÇÃO: Este comando irá APAGAR PERMANENTEMENTE:     ║');
        $this->warn('║  - Todas as referências de pagamento                   ║');
        $this->warn('║  - Todos os registos de reconciliação falhada          ║');
        $this->warn('╚════════════════════════════════════════════════════════╝');
        $this->newLine();

        // Mostrar contagem actual
        $this->info('Estado actual do sistema:');
        $this->table(
            ['Tabela', 'Registos'],
            [
                ['payment_references', DB::table('payment_references')->count()],
                ['failed_reconciliations', DB::table('failed_reconciliations')->count()],
            ]
        );

        if (!$this->option('force')) {
            if (!$this->confirm('Tem a certeza que deseja continuar? Esta acção é IRREVERSÍVEL!')) {
                $this->info('Operação cancelada.');
                return 0;
            }

            // Segunda confirmação
            $confirmation = $this->ask('Digite "CONFIRMAR" para prosseguir');
            if ($confirmation !== 'CONFIRMAR') {
                $this->info('Operação cancelada.');
                return 0;
            }
        }

        $this->newLine();
        $this->info('A iniciar limpeza...');

        DB::beginTransaction();

        try {
            // 1. Limpar failed_reconciliations
            $this->task('A limpar reconciliações falhadas', function () {
                DB::table('failed_reconciliations')->truncate();
                return true;
            });

            // 2. Limpar payment_references (incluindo soft deleted)
            $this->task('A limpar referências de pagamento', function () {
                DB::statement('SET FOREIGN_KEY_CHECKS=0;');
                DB::table('payment_references')->truncate();
                DB::statement('SET FOREIGN_KEY_CHECKS=1;');
                return true;
            });

            DB::commit();

            $this->newLine();
            $this->info('╔════════════════════════════════════════════════════════╗');
            $this->info('║  LIMPEZA CONCLUÍDA COM SUCESSO!                        ║');
            $this->info('╚════════════════════════════════════════════════════════╝');

            // Mostrar contagem após limpeza
            $this->newLine();
            $this->info('Estado após limpeza:');
            $this->table(
                ['Tabela', 'Registos'],
                [
                    ['payment_references', DB::table('payment_references')->count()],
                    ['failed_reconciliations', DB::table('failed_reconciliations')->count()],
                ]
            );

            return 0;

        } catch (\Exception $e) {
            DB::rollBack();
            $this->error('Erro durante a limpeza: ' . $e->getMessage());
            return 1;
        }
    }

    /**
     * Execute a task with visual feedback
     */
    protected function task($title, $callback)
    {
        $this->output->write("  $title... ");

        try {
            $result = $callback();
            if ($result) {
                $this->info('✓');
            } else {
                $this->error('✗');
            }
            return $result;
        } catch (\Exception $e) {
            $this->error('✗ ' . $e->getMessage());
            throw $e;
        }
    }
}
