<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use PhpOffice\PhpWord\PhpWord;
use PhpOffice\PhpWord\IOFactory;
use PhpOffice\PhpWord\SimpleType\TblWidth;
use ZipArchive;

class FixCertificateTemplate extends Command
{
    protected $signature = 'certificate:fix-template';
    protected $description = 'Fix certificate template alignment using tabs';

    public function handle()
    {
        $templatePath = resource_path('templates/certificate_template.docx');
        $backupPath = resource_path('templates/certificate_template_original.docx');

        // Create backup
        if (!file_exists($backupPath)) {
            copy($templatePath, $backupPath);
            $this->info('Backup criado: certificate_template_original.docx');
        }

        // Open the template as ZIP
        $zip = new ZipArchive();
        if ($zip->open($templatePath) !== true) {
            $this->error('Não foi possível abrir o template');
            return 1;
        }

        // Get document.xml
        $xmlContent = $zip->getFromName('word/document.xml');
        if ($xmlContent === false) {
            $zip->close();
            $this->error('Não foi possível ler document.xml');
            return 1;
        }

        // Add tab stops to the paragraph containing grades
        // Find the paragraph properties and add tab definitions

        // Define tab stops at fixed positions (in twips: 1 inch = 1440 twips)
        $tabStops = '<w:tabs>
            <w:tab w:val="left" w:pos="2160"/>
            <w:tab w:val="left" w:pos="4320"/>
            <w:tab w:val="left" w:pos="5760"/>
        </w:tabs>';

        // Replace multiple spaces with tab characters in the grades section
        // Pattern: Subject name followed by dashes, then extenso, then (nota), then Valores

        // First, let's replace the pattern in the XML
        // The grades lines look like: "Português   ----------------   ${Extenso1}    (${nota1})   Valores"

        // Replace sequences of spaces (3 or more) with a single tab
        $xmlContent = preg_replace('/(\w)(   +)([-]+)/u', '$1</w:t></w:r><w:r><w:tab/><w:t>$3', $xmlContent);
        $xmlContent = preg_replace('/([-]+)(   +)(\$\{Extenso)/u', '$1</w:t></w:r><w:r><w:tab/><w:t>$3', $xmlContent);
        $xmlContent = preg_replace('/(\})(   +)(\()/u', '$1</w:t></w:r><w:r><w:tab/><w:t>$3', $xmlContent);
        $xmlContent = preg_replace('/(\))(   +)(Valores)/u', '$1</w:t></w:r><w:r><w:tab/><w:t>$3', $xmlContent);

        // Save the modified content
        $zip->deleteName('word/document.xml');
        $zip->addFromString('word/document.xml', $xmlContent);
        $zip->close();

        $this->info('Template atualizado com sucesso!');
        $this->info('Por favor, abra o template no Word e ajuste as posições dos tabs na régua.');

        return 0;
    }
}
