<?php

namespace App\Exports;

use App\Models\Classroom;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class TurmasExport implements FromCollection, WithHeadings, ShouldAutoSize, WithStyles
{
    protected $filters;

    public function __construct($filters = [])
    {
        $this->filters = $filters;
    }

    public function collection()
    {
        $query = Classroom::query()->with('students');

        // Aplicar filtros
        if (!empty($this->filters['search'])) {
            $query->where(function ($q) {
                $q->where('name', 'like', '%' . $this->filters['search'] . '%')
                  ->orWhere('slug', 'like', '%' . $this->filters['search'] . '%')
                  ->orWhere('description', 'like', '%' . $this->filters['search'] . '%');
            });
        }

        if (!empty($this->filters['class'])) {
            $query->where('class', $this->filters['class']);
        }

        if (isset($this->filters['status']) && $this->filters['status'] !== '') {
            $query->where('is_active', $this->filters['status']);
        }

        $turmas = $query->orderByRaw('CAST(class AS UNSIGNED)')->orderBy('name')->get();

        return $turmas->map(function ($turma) {
            return [
                'turma' => $turma->name,
                'classe' => $turma->class . 'ª Classe',
                'descricao' => strip_tags($turma->description),
                'estudantes' => $turma->students->count() . ' alunos',
                'estado' => $turma->is_active ? 'Ativo' : 'Inativo',
                'data' => $turma->created_at->format('d/m/Y H:i'),
            ];
        });
    }

    public function headings(): array
    {
        return [
            'Turma',
            'Classe',
            'Descrição',
            'Estudantes',
            'Estado',
            'Data de Criação',
        ];
    }

    public function styles(Worksheet $sheet)
    {
        return [
            1 => ['font' => ['bold' => true]],
        ];
    }
}
