<?php

namespace App\Http\Livewire\Admin\Classes;

use App\Models\Classroom;
use App\Models\Project;
use App\Models\Exam;
use App\Models\Student;
use App\Models\Subject;
use App\Models\Trimester;
use App\Models\User;
use Illuminate\Validation\ValidationException;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Livewire\WithPagination;
use Note\Note;
use Carbon\Carbon;

class AcademicViewResults extends Component
{
    protected $lazy = false;
    use FindGuard, LivewireAlert;
    use WithPagination;

    public $search;
    public $model,$user, $project, $name;
    
    protected $queryString = ['search'];

    protected string $paginationTheme = 'bootstrap';

    public function updatingSearch()
    {
        $this->resetPage();
    }

    public bool $readyToLoad = false;

    public function loadData()
    {
        $this->readyToLoad = true;
    }

    public function mount($slug)
    {
        $this->model = Classroom::query()->where('slug', $slug)->first();
        $this->name = $this->model->name;
    }

    public function render()
    {
        $this->user = $this->findGuardType()->user();
        
        return view('livewire.admin.classes.academic-view-results', [
            'models' => $this->readyToLoad
                ? User::query() 
                            
                    ->where(function ($query) {                       
                        $query->orWhere('name', 'like', '%' . $this->search . '%')
                            ->orWhere('sex', 'like', '%' . $this->search . '%')
				            ->orWhere('phone_number', 'like', '%' . $this->search . '%')
                            ->orWhere('slug', 'like', '%' . $this->search . '%');
                    })
                    ->where('classroom_id', $this->model->id)
                    ->orderBy('name') // Order students by 'name' column
                    ->paginate(100)

                : []
                ],
        [
            'classes' => Classroom::query()->orderBy('name')->get(),
            'trimesters' => Trimester::query()->orderBy('name')->get(),
            'subjects' => Subject::query()->orderBy('name')->get(),
            'students' => Student::query()->orderBy('name')->get(),
            
            ]
    );
    }
}
