<?php

namespace App\Http\Livewire\Admin\Fee;

use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Livewire\WithPagination;
use App\Models\FeeStructure;

class ListFeeMaster extends Component
{
    use WithPagination, FindGuard, LivewireAlert;

    public $search;
    protected $queryString = ['search'];
    protected string $paginationTheme = 'bootstrap';
    public bool $readyToLoad = false;

    protected $listeners = [
        'FeeStructureDeleted' => '$refresh',
    ];

    /**
     * Reset pagination when searching
     */
    public function updatingSearch()
    {
        $this->resetPage();
    }

    /**
     * Load data when triggered
     */
    public function loadData()
    {
        $this->readyToLoad = true;
        $this->dispatchBrowserEvent('refreshTable'); // 🔥 Ensure UI updates
    }

       public function toggleActiveStatus($id)
    {
        // Find the FeeStructure by its ID
        $feeStructure = FeeStructure::find($id);

        // Toggle the active status
        $feeStructure->active = !$feeStructure->active;

        // Save the changes to the database
        $feeStructure->save();

        // Show a success message
        $this->alert('success', 'Status atualizado com sucesso!');
    }

    /**
     * Delete FeeStructure
     */
    public function delete($id)
    {
        $feeStructure = FeeStructure::find($id);

        if ($feeStructure) {
            $feeStructure->delete();

            // Emit event to refresh the list
            $this->emit('FeeStructureDeleted');
            $this->resetPage();

            // Show success alert
            $this->alert('success', 'Plano de taxa deletado com sucesso');
        } else {
            $this->alert('error', 'Plano de taxa não encontrado.');
        }
    }

    /**
     * Edit fee structure - redirect to add page with ID
     */
    public function edit($id)
    {
        return redirect()->route('admin.add.feemaster', ['id' => $id]);
    }

    /**
     * Render Livewire component
     */
    public function render()
    {
        $feeStructures = $this->readyToLoad
            ? FeeStructure::where('fee_name', 'like', '%' . $this->search . '%')
                ->latest('updated_at')
                ->paginate(10)
            : collect();

        return view('livewire.admin.fee.list-fee-master', [
            'feeStructures' => $feeStructures,
        ]);
    }
}
