<?php

namespace App\Http\Livewire\Admin\Secretary;

use App\Models\PreEnrollment;
use App\Services\SmsService;
use Exception;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;

class ShowPreEnrollment extends Component
{
    use FindGuard, LivewireAlert;

    public $preEnrollment;
    public $actionType;

    protected $listeners = ['confirmed', 'cancelled'];

    public function mount($id)
    {
        $this->preEnrollment = PreEnrollment::with(['desiredClassroom'])->findOrFail($id);
    }

    public function confirmInscricao()
    {
        $this->actionType = 'confirmar';
        $this->confirm('Confirmar esta pré-inscrição?', [
            'toast' => false,
            'position' => 'center',
            'showConfirmButton' => true,
            'confirmButtonText' => 'Sim, confirmar!',
            'cancelButtonText' => 'Cancelar',
            'onConfirmed' => 'confirmed',
            'onDismissed' => 'cancelled'
        ]);
    }

    public function anularInscricao()
    {
        $this->actionType = 'anular';
        $this->confirm('Tem certeza de que deseja anular esta inscrição?', [
            'toast' => false,
            'position' => 'center',
            'showConfirmButton' => true,
            'confirmButtonText' => 'Sim, anular!',
            'cancelButtonText' => 'Cancelar',
            'onConfirmed' => 'confirmed',
            'onDismissed' => 'cancelled'
        ]);
    }

    public function confirmed()
    {
        $adminId = auth()->guard('admin')->id();

        if ($this->actionType === 'confirmar') {
            $this->preEnrollment->update([
                'status' => 'confirmada',
                'confirmed_at' => now(),
                'confirmed_by' => $adminId,
            ]);

            // Send SMS
            try {
                $phone = $this->preEnrollment->guardian_phone ?: $this->preEnrollment->candidate_phone;
                $message = "COPMOZ: Pre-inscricao {$this->preEnrollment->code} confirmada! Dirija-se a secretaria para completar a matricula.";
                (new SmsService())->send($phone, $message);
            } catch (Exception $e) {
                // continue
            }

            $this->alert('success', 'Inscrição confirmada com sucesso!');
            $this->preEnrollment->refresh();

        } elseif ($this->actionType === 'anular') {
            $this->preEnrollment->update([
                'status' => 'anulada',
                'cancelled_at' => now(),
            ]);

            $this->alert('success', 'Inscrição anulada.');
            $this->preEnrollment->refresh();
        }

        $this->actionType = null;
    }

    public function cancelled()
    {
        $this->alert('info', 'Operação cancelada.');
        $this->actionType = null;
    }

    public function render()
    {
        $this->findGuardType()->user();
        return view('livewire.admin.secretary.show-pre-enrollment');
    }
}
