<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class BmepsTransaction extends Model
{
    protected $table = 'bmeps_transactions';

    protected $fillable = [
        'record_type',
        'reference',
        'amount',
        'commission',
        'transaction_date',
        'transaction_time',
        'transaction_id',
        'terminal_id',
        'terminal_location',
        'reconciliation_status',
        'payment_reference_id',
        'reconciled_at',
        'reconciliation_type',
        'reconciled_by',
        'reconciliation_notes',
        'bmeps_file_id',
        'raw_line',
    ];

    protected $casts = [
        'amount' => 'decimal:2',
        'commission' => 'decimal:2',
        'transaction_date' => 'datetime',
        'reconciled_at' => 'datetime',
    ];

    // Relationships
    public function file(): BelongsTo
    {
        return $this->belongsTo(BmepsFile::class, 'bmeps_file_id');
    }

    public function paymentReference(): BelongsTo
    {
        return $this->belongsTo(PaymentReference::class, 'payment_reference_id');
    }

    // Scopes
    public function scopePending($q) { return $q->where('reconciliation_status', 'pending'); }
    public function scopeReconciled($q) { return $q->where('reconciliation_status', 'reconciled'); }
    public function scopeIgnored($q) { return $q->where('reconciliation_status', 'ignored'); }
    public function scopeError($q) { return $q->where('reconciliation_status', 'error'); }
}