<?php

namespace App\Models;

use App\Traits\Uuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Sluggable\HasSlug;
use Spatie\Sluggable\SlugOptions;

class Classroom extends Model
{
    use HasFactory, Uuids, SoftDeletes, HasSlug;

    /**
     * stop the auto increment
     */
    public $incrementing = false;

    /**
     * type of auto-increment
     *
     * @string
     */
    protected $keyType = 'string';

    protected $fillable = [
        'name',
        'slug',
        'description',
        'class',
        'capacity',
    ];

    /**
     * Get the options for generating the slug.
     */
    public function getSlugOptions(): SlugOptions
    {
        return SlugOptions::create()
            ->generateSlugsFrom('name')
            ->saveSlugsTo('slug');
    }

    public function teachers(): HasMany
    {
        return $this->hasMany(Admin::class)->latest();
    }
//    public function students(): HasMany
//    {
//        return $this->hasMany(User::class)->latest();
//    }
    
    public function students(): HasMany
    {
        return $this->hasMany(User::class, 'classroom_id', 'id')->latest();
    }

    
    public function subjects(): HasMany
    {
        return $this->hasMany(TeacherSubject::class, 'classroom_id');
    }

    public function attendances(): HasMany
    {
        return $this->hasMany(Attendance::class, 'classroom_id');
    }

    public function renewals(): HasMany
    {
        return $this->hasMany(EnrollmentRenewal::class, 'from_classroom_id');
    }
}
