<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FeesDiscount extends Model
{
    use HasFactory;
    protected $fillable = [
        'name',
        'discount_code',
        'discount_type',
        'percentage',
        'amount',
        'description',
        'student_id',
        'months',
    ];

    /**
     * Get the discount type in a readable format.
     *
     * @return string
     */
    public function getDiscountTypeAttribute($value)
    {
        return ucfirst(str_replace('_', ' ', $value));
    }
}
