<?php

namespace App\Models\POS;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class StockMovement extends Model
{
    use HasFactory, HasUuids;

    protected $table = 'pos_stock_movements';

    protected $fillable = [
        'product_id',
        'supplier_id',
        'user_id',
        'type',
        'quantity',
        'stock_before',
        'stock_after',
        'unit_price',
        'total_price',
        'reference',
        'notes',
        'movement_date',
    ];

    protected $casts = [
        'quantity' => 'integer',
        'stock_before' => 'integer',
        'stock_after' => 'integer',
        'unit_price' => 'decimal:2',
        'total_price' => 'decimal:2',
        'movement_date' => 'datetime',
    ];

    // Relationships
    public function product()
    {
        return $this->belongsTo(Product::class, 'product_id');
    }

    public function supplier()
    {
        return $this->belongsTo(Supplier::class, 'supplier_id');
    }

    // Scopes
    public function scopePurchases($query)
    {
        return $query->where('type', 'purchase');
    }

    public function scopeSales($query)
    {
        return $query->where('type', 'sale');
    }

    public function scopeAdjustments($query)
    {
        return $query->where('type', 'adjustment');
    }

    public function scopeReturns($query)
    {
        return $query->where('type', 'return');
    }

    // Accessors
    public function getTypeNameAttribute()
    {
        return match($this->type) {
            'purchase' => 'Compra',
            'sale' => 'Venda',
            'adjustment' => 'Ajuste',
            'return' => 'Devolução',
        };
    }

    public function getTypeColorAttribute()
    {
        return match($this->type) {
            'purchase' => 'green',
            'sale' => 'blue',
            'adjustment' => 'orange',
            'return' => 'red',
        };
    }
}
