<?php

namespace App\Models\POS;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Supplier extends Model
{
    use HasFactory, HasUuids;

    protected $table = 'pos_suppliers';

    protected $fillable = [
        'name',
        'email',
        'phone',
        'nuit',
        'address',
        'notes',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    // Relationships
    public function stockMovements()
    {
        return $this->hasMany(StockMovement::class, 'supplier_id');
    }

    // Scopes
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    // Accessors
    public function getTotalPurchasesAttribute()
    {
        return $this->stockMovements()
            ->where('type', 'purchase')
            ->sum('total_price');
    }

    public function getTotalProductsSuppliedAttribute()
    {
        return $this->stockMovements()
            ->where('type', 'purchase')
            ->distinct('product_id')
            ->count();
    }
}
