<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sms_logs', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->string('gateway', 50)->default('movitel'); // movitel, twilio
            $table->string('phone_number', 20);
            $table->text('message');
            $table->string('message_id')->nullable(); // External message ID from gateway
            $table->enum('status', ['pending', 'sent', 'failed', 'delivered'])->default('pending');
            $table->text('error')->nullable();
            $table->json('response')->nullable(); // Full API response
            $table->timestamp('scheduled_at')->nullable();
            $table->uuid('sent_by')->nullable();
            $table->timestamps();

            // Indexes
            $table->index('gateway');
            $table->index('status');
            $table->index('phone_number');
            $table->index('created_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sms_logs');
    }
};
