<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('pos_stock_movements', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->uuid('product_id');
            $table->uuid('supplier_id')->nullable();
            $table->uuid('user_id'); // Admin que fez o movimento

            $table->enum('type', ['purchase', 'sale', 'adjustment', 'return']); // Compra, Venda, Ajuste, Devolução
            $table->integer('quantity');
            $table->integer('stock_before');
            $table->integer('stock_after');

            $table->decimal('unit_price', 10, 2)->nullable();
            $table->decimal('total_price', 10, 2)->nullable();

            $table->string('reference')->nullable(); // Referência da fatura/documento
            $table->text('notes')->nullable();
            $table->timestamp('movement_date');

            $table->timestamps();

            $table->foreign('product_id')->references('id')->on('pos_products')->onDelete('cascade');
            $table->foreign('supplier_id')->references('id')->on('pos_suppliers')->onDelete('set null');
        });
    }

    public function down()
    {
        Schema::dropIfExists('pos_stock_movements');
    }
};
