<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('noticeboards', function (Blueprint $table) {
            if (!Schema::hasColumn('noticeboards', 'author')) {
                $table->string('author')->nullable()->after('title');
            }
            if (!Schema::hasColumn('noticeboards', 'description')) {
                $table->text('description')->nullable()->after('author');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('noticeboards', function (Blueprint $table) {
            $table->dropColumn(['author', 'description']);
        });
    }
};
