<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Verificar se a coluna palenty_type existe antes de renomear
        if (Schema::hasColumn('fee_structures', 'palenty_type')) {
            // Se penalty_type já existe, copiar dados e remover palenty_type
            if (Schema::hasColumn('fee_structures', 'penalty_type')) {
                DB::statement('UPDATE fee_structures SET penalty_type = palenty_type WHERE palenty_type IS NOT NULL');
                Schema::table('fee_structures', function (Blueprint $table) {
                    $table->dropColumn('palenty_type');
                });
            } else {
                // Se penalty_type não existe, renomear palenty_type
                Schema::table('fee_structures', function (Blueprint $table) {
                    $table->renameColumn('palenty_type', 'penalty_type');
                });
            }
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Reverter: renomear de volta para palenty_type
        if (Schema::hasColumn('fee_structures', 'penalty_type')) {
            Schema::table('fee_structures', function (Blueprint $table) {
                $table->renameColumn('penalty_type', 'palenty_type');
            });
        }
    }
};
