<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('payment_references', function (Blueprint $table) {
            if (!Schema::hasColumn('payment_references', 'metadata')) {
                $table->text('metadata')->nullable()->after('expires_at');
            }
        });
    }

    public function down(): void
    {
        Schema::table('payment_references', function (Blueprint $table) {
            if (Schema::hasColumn('payment_references', 'metadata')) {
                $table->dropColumn('metadata');
            }
        });
    }
};
