<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('failed_reconciliations')) {
            Schema::create('failed_reconciliations', function (Blueprint $table) {
                $table->id();
                $table->string('reference_number', 20);
                $table->decimal('amount', 10, 2);
                $table->date('payment_date');
                $table->string('entity_code', 10)->nullable();
                $table->text('error_reason');
                $table->string('file_name')->nullable();
                $table->enum('status', ['pending', 'resolved', 'ignored'])->default('pending');
                $table->unsignedBigInteger('resolved_by')->nullable();
                $table->timestamp('resolved_at')->nullable();
                $table->text('resolution_notes')->nullable();
                $table->timestamps();

                $table->index(['status', 'created_at']);
                $table->index('reference_number');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('failed_reconciliations');
    }
};
