<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('payment_references', function (Blueprint $table) {
            // Remover constraint que impede múltiplas referências pendentes
            // Isso permite que estudantes tenham múltiplas compras no mesmo mês
            // (ex: uniforme, cartão, material escolar, etc)
            $table->dropUnique('unique_pending_ref');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('payment_references', function (Blueprint $table) {
            // Recriar constraint se necessário reverter
            $table->unique(['student_id', 'fee_month', 'fee_year', 'status'], 'unique_pending_ref');
        });
    }
};
