<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('certificates', function (Blueprint $table) {
            $table->dropColumn([
                'iva_applicable',
                'iva_rate',
                'price_charged',
                'price_includes_iva',
                'base_amount',
                'iva_amount',
                'total_amount'
            ]);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('certificates', function (Blueprint $table) {
            $table->boolean('iva_applicable')->default(false)->after('status');
            $table->decimal('iva_rate', 5, 2)->default(16.00)->after('iva_applicable');
            $table->decimal('price_charged', 10, 2)->nullable()->after('iva_rate');
            $table->boolean('price_includes_iva')->default(false)->after('price_charged');
            $table->decimal('base_amount', 10, 2)->nullable()->after('price_includes_iva');
            $table->decimal('iva_amount', 10, 2)->nullable()->after('base_amount');
            $table->decimal('total_amount', 10, 2)->nullable()->after('iva_amount');
        });
    }
};
