<?php

namespace Database\Seeders;

use App\Models\POS\Category;
use App\Models\POS\Product;
use App\Models\POS\Supplier;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class POSSeeder extends Seeder
{
    public function run()
    {
        // Criar categorias
        $categories = [
            [
                'name' => 'Uniformes Escolares',
                'slug' => 'uniformes-escolares',
                'description' => 'Uniformes completos para estudantes',
                'icon' => 'tshirt',
                'color' => '#4f46e5',
            ],
            [
                'name' => 'Livros e Materiais Didáticos',
                'slug' => 'livros-materiais',
                'description' => 'Livros, cadernos e materiais de estudo',
                'icon' => 'book',
                'color' => '#10b981',
            ],
            [
                'name' => 'Material Escolar',
                'slug' => 'material-escolar',
                'description' => 'Canetas, lápis, borrachas e outros materiais',
                'icon' => 'pen',
                'color' => '#f59e0b',
            ],
            [
                'name' => 'Cantina',
                'slug' => 'cantina',
                'description' => 'Lanches e bebidas',
                'icon' => 'utensils',
                'color' => '#ef4444',
            ],
        ];

        $createdCategories = [];
        foreach ($categories as $categoryData) {
            $createdCategories[$categoryData['slug']] = Category::create($categoryData);
        }

        // Criar fornecedores
        $suppliers = [
            [
                'name' => 'Uniformes Moçambique Lda',
                'email' => 'vendas@uniformesmoz.co.mz',
                'phone' => '840000001',
                'nuit' => '400000001',
                'address' => 'Av. Julius Nyerere, Maputo',
            ],
            [
                'name' => 'Papelaria Central',
                'email' => 'info@papelariacentral.co.mz',
                'phone' => '840000002',
                'nuit' => '400000002',
                'address' => 'Av. 25 de Setembro, Maputo',
            ],
        ];

        foreach ($suppliers as $supplierData) {
            Supplier::create($supplierData);
        }

        // Criar produtos de uniformes
        $uniformProducts = [
            [
                'category' => 'uniformes-escolares',
                'name' => 'Camisa Uniforme Branca - P',
                'sku' => 'UNI-CAM-BRA-P',
                'cost_price' => 150.00,
                'selling_price' => 250.00,
                'quantity' => 50,
            ],
            [
                'category' => 'uniformes-escolares',
                'name' => 'Camisa Uniforme Branca - M',
                'sku' => 'UNI-CAM-BRA-M',
                'cost_price' => 150.00,
                'selling_price' => 250.00,
                'quantity' => 80,
            ],
            [
                'category' => 'uniformes-escolares',
                'name' => 'Camisa Uniforme Branca - G',
                'sku' => 'UNI-CAM-BRA-G',
                'cost_price' => 150.00,
                'selling_price' => 250.00,
                'quantity' => 60,
            ],
            [
                'category' => 'uniformes-escolares',
                'name' => 'Calça Uniforme Azul - P',
                'sku' => 'UNI-CAL-AZU-P',
                'cost_price' => 200.00,
                'selling_price' => 350.00,
                'quantity' => 40,
            ],
            [
                'category' => 'uniformes-escolares',
                'name' => 'Calça Uniforme Azul - M',
                'sku' => 'UNI-CAL-AZU-M',
                'cost_price' => 200.00,
                'selling_price' => 350.00,
                'quantity' => 70,
            ],
            [
                'category' => 'uniformes-escolares',
                'name' => 'Calça Uniforme Azul - G',
                'sku' => 'UNI-CAL-AZU-G',
                'cost_price' => 200.00,
                'selling_price' => 350.00,
                'quantity' => 50,
            ],
        ];

        // Criar produtos de material escolar
        $materialProducts = [
            [
                'category' => 'material-escolar',
                'name' => 'Caderno 100 Folhas A4',
                'sku' => 'CAD-100-A4',
                'cost_price' => 80.00,
                'selling_price' => 120.00,
                'quantity' => 200,
            ],
            [
                'category' => 'material-escolar',
                'name' => 'Caneta Azul (Pack 10)',
                'sku' => 'CAN-AZU-10',
                'cost_price' => 40.00,
                'selling_price' => 70.00,
                'quantity' => 150,
            ],
            [
                'category' => 'material-escolar',
                'name' => 'Lápis HB (Pack 12)',
                'sku' => 'LAP-HB-12',
                'cost_price' => 30.00,
                'selling_price' => 55.00,
                'quantity' => 180,
            ],
            [
                'category' => 'material-escolar',
                'name' => 'Borracha Branca',
                'sku' => 'BOR-BRA',
                'cost_price' => 10.00,
                'selling_price' => 20.00,
                'quantity' => 300,
            ],
        ];

        // Criar produtos de livros
        $bookProducts = [
            [
                'category' => 'livros-materiais',
                'name' => 'Livro Matemática 10ª Classe',
                'sku' => 'LIV-MAT-10',
                'cost_price' => 350.00,
                'selling_price' => 500.00,
                'quantity' => 100,
            ],
            [
                'category' => 'livros-materiais',
                'name' => 'Livro Português 10ª Classe',
                'sku' => 'LIV-POR-10',
                'cost_price' => 350.00,
                'selling_price' => 500.00,
                'quantity' => 100,
            ],
            [
                'category' => 'livros-materiais',
                'name' => 'Livro Física 11ª Classe',
                'sku' => 'LIV-FIS-11',
                'cost_price' => 400.00,
                'selling_price' => 550.00,
                'quantity' => 80,
            ],
        ];

        // Criar produtos de cantina
        $cantinaProducts = [
            [
                'category' => 'cantina',
                'name' => 'Lanche Completo',
                'sku' => 'CAN-LAN-COM',
                'cost_price' => 40.00,
                'selling_price' => 80.00,
                'quantity' => 50,
                'track_stock' => false,
            ],
            [
                'category' => 'cantina',
                'name' => 'Refrigerante 500ml',
                'sku' => 'CAN-REF-500',
                'cost_price' => 15.00,
                'selling_price' => 30.00,
                'quantity' => 100,
            ],
            [
                'category' => 'cantina',
                'name' => 'Água Mineral 500ml',
                'sku' => 'CAN-AGU-500',
                'cost_price' => 10.00,
                'selling_price' => 20.00,
                'quantity' => 150,
            ],
        ];

        $allProducts = array_merge($uniformProducts, $materialProducts, $bookProducts, $cantinaProducts);

        foreach ($allProducts as $productData) {
            $category = $createdCategories[$productData['category']];
            unset($productData['category']);

            Product::create(array_merge($productData, [
                'category_id' => $category->id,
                'description' => 'Produto de qualidade para uso escolar',
                'min_stock' => 10,
                'unit' => 'Unidade',
                'is_active' => true,
                'track_stock' => $productData['track_stock'] ?? true,
            ]));
        }

        $this->command->info('Sistema POS populado com sucesso!');
        $this->command->info('Categorias: ' . Category::count());
        $this->command->info('Produtos: ' . Product::count());
        $this->command->info('Fornecedores: ' . Supplier::count());
    }
}
