<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Nova Referência de Pagamento</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 30px;
            text-align: center;
            border-radius: 10px 10px 0 0;
        }
        .content {
            background: #f8f9fa;
            padding: 30px;
            border-radius: 0 0 10px 10px;
        }
        .info-box {
            background: white;
            padding: 20px;
            margin: 15px 0;
            border-radius: 8px;
            border-left: 4px solid #667eea;
        }
        .info-row {
            display: flex;
            justify-content: space-between;
            padding: 8px 0;
            border-bottom: 1px solid #eee;
        }
        .info-row:last-child {
            border-bottom: none;
        }
        .label {
            font-weight: bold;
            color: #555;
        }
        .value {
            color: #333;
        }
        .status-badge {
            display: inline-block;
            padding: 5px 15px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: bold;
            background: #ffc107;
            color: #000;
        }
        .button {
            display: inline-block;
            padding: 12px 30px;
            background: #667eea;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            margin: 20px 0;
            text-align: center;
        }
        .button:hover {
            background: #5568d3;
        }
        .footer {
            text-align: center;
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #ddd;
            color: #666;
            font-size: 12px;
        }
        .alert {
            background: #fff3cd;
            border: 1px solid #ffc107;
            padding: 15px;
            border-radius: 5px;
            margin: 15px 0;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1 style="margin: 0;">🔔 COPMOZ</h1>
        <p style="margin: 10px 0 0 0;">Sistema de Gestão Escolar</p>
    </div>

    <div class="content">
        @if($totalCount > 1)
            <div class="alert">
                <strong>⚠️ Atenção!</strong> {{ $totalCount }} novas referências de pagamento foram geradas e aguardam sua aprovação.
            </div>
        @else
            <h2 style="margin-top: 0; color: #667eea;">Nova Referência Pendente de Aprovação</h2>
        @endif

        <p>Uma {{ $totalCount > 1 ? 'nova referência foi gerada' : 'nova referência de pagamento foi gerada' }} e requer sua aprovação antes de ser disponibilizada ao estudante.</p>

        <div class="info-box">
            <div class="info-row">
                <span class="label">Estudante:</span>
                <span class="value">{{ $reference->student->name ?? 'N/A' }}</span>
            </div>
            <div class="info-row">
                <span class="label">Código:</span>
                <span class="value">{{ $reference->student->student_id ?? 'N/A' }}</span>
            </div>
            <div class="info-row">
                <span class="label">Classe:</span>
                <span class="value">{{ $reference->classe ?? 'N/A' }} - {{ $reference->turma ?? 'N/A' }}</span>
            </div>
        </div>

        <div class="info-box">
            <div class="info-row">
                <span class="label">Referência:</span>
                <span class="value"><strong>{{ $reference->reference_number }}</strong></span>
            </div>
            <div class="info-row">
                <span class="label">Entidade:</span>
                <span class="value">{{ $reference->entity_code }}</span>
            </div>
            <div class="info-row">
                <span class="label">Valor:</span>
                <span class="value"><strong>{{ number_format($reference->amount, 2) }} MT</strong></span>
            </div>
            <div class="info-row">
                <span class="label">Mês/Ano:</span>
                <span class="value">{{ $reference->fee_month }}/{{ $reference->fee_year }}</span>
            </div>
            <div class="info-row">
                <span class="label">Status:</span>
                <span class="value"><span class="status-badge">PENDENTE APROVAÇÃO</span></span>
            </div>
        </div>

        <div class="info-box">
            <div class="info-row">
                <span class="label">Descrição:</span>
                <span class="value">{{ $reference->metadata['description'] ?? 'N/A' }}</span>
            </div>
            <div class="info-row">
                <span class="label">Válida de:</span>
                <span class="value">{{ $reference->valid_from ? $reference->valid_from->format('d/m/Y') : 'N/A' }}</span>
            </div>
            <div class="info-row">
                <span class="label">Expira em:</span>
                <span class="value">{{ $reference->expires_at ? $reference->expires_at->format('d/m/Y') : 'N/A' }}</span>
            </div>
            @if($reference->due_date)
            <div class="info-row">
                <span class="label">Vencimento:</span>
                <span class="value">{{ $reference->due_date->format('d/m/Y') }}</span>
            </div>
            @endif
        </div>

        <div style="text-align: center;">
            <a href="{{ route('admin.fee.approve-references') }}" class="button">
                Acessar Painel de Aprovação
            </a>
        </div>

        <p style="margin-top: 30px; font-size: 14px; color: #666;">
            <strong>⚡ Ação Necessária:</strong> Acesse o sistema para aprovar ou rejeitar esta referência.
            Apenas após sua aprovação, o estudante poderá efetuar o pagamento.
        </p>

        @if($totalCount > 1)
        <p style="font-size: 14px; color: #666;">
            <em>Esta é uma das {{ $totalCount }} referências geradas. Todas estão aguardando aprovação.</em>
        </p>
        @endif
    </div>

    <div class="footer">
        <p>
            Este é um email automático do <strong>COPMOZ - Sistema de Gestão Escolar</strong><br>
            Por favor, não responda a este email.
        </p>
        <p style="margin-top: 10px;">
            © {{ date('Y') }} COPMOZ. Todos os direitos reservados.
        </p>
    </div>
</body>
</html>
