<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Lista de Staff</title>
    <style>
        @page {
            size: A4;
            margin: 15mm;
        }
        body {
            font-family: Arial, sans-serif;
            font-size: 11px;
            margin: 0;
            padding: 0;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
            border-bottom: 2px solid #333;
            padding-bottom: 10px;
        }
        .header h1 {
            margin: 0;
            font-size: 18px;
            font-weight: bold;
        }
        .header p {
            margin: 5px 0;
            color: #666;
            font-size: 10px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 15px;
        }
        thead {
            background-color: #4e73df;
            color: white;
        }
        th {
            padding: 8px 5px;
            text-align: left;
            font-size: 10px;
            font-weight: bold;
        }
        td {
            padding: 6px 5px;
            border-bottom: 1px solid #ddd;
            font-size: 9px;
        }
        tr:nth-child(even) {
            background-color: #f8f9fa;
        }
        .footer {
            margin-top: 20px;
            text-align: center;
            font-size: 9px;
            color: #666;
            border-top: 1px solid #ddd;
            padding-top: 10px;
        }
        .badge-admin {
            background-color: #333;
            color: white;
            padding: 2px 6px;
            border-radius: 3px;
            font-size: 8px;
        }
        .badge-contabilidade {
            background-color: #4e73df;
            color: white;
            padding: 2px 6px;
            border-radius: 3px;
            font-size: 8px;
        }
        .badge-professor {
            background-color: #17a2b8;
            color: white;
            padding: 2px 6px;
            border-radius: 3px;
            font-size: 8px;
        }
        .badge-academico {
            background-color: #ffc107;
            color: #333;
            padding: 2px 6px;
            border-radius: 3px;
            font-size: 8px;
        }
        .badge-ativo {
            background-color: #28a745;
            color: white;
            padding: 2px 6px;
            border-radius: 3px;
            font-size: 8px;
        }
        .badge-suspenso {
            background-color: #dc3545;
            color: white;
            padding: 2px 6px;
            border-radius: 3px;
            font-size: 8px;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>COLÉGIO POLITÉCNICO DE MOÇAMBIQUE</h1>
        <p>Lista de Staff</p>
        <p>Gerado em: {{ date('d/m/Y H:i') }}</p>
    </div>

    <table>
        <thead>
            <tr>
                <th style="width: 25%;">Nome</th>
                <th style="width: 20%;">Email</th>
                <th style="width: 13%;">Telefone</th>
                <th style="width: 15%;">Função</th>
                <th style="width: 12%;">Estado</th>
                <th style="width: 15%;">Data</th>
            </tr>
        </thead>
        <tbody>
            @foreach($staff as $member)
                <tr>
                    <td><strong>{{ $member['nome'] }}</strong></td>
                    <td>{{ $member['email'] }}</td>
                    <td>{{ $member['telefone'] }}</td>
                    <td>
                        @if($member['funcao'] == 'Admin')
                            <span class="badge-admin">{{ $member['funcao'] }}</span>
                        @elseif($member['funcao'] == 'Contabilidade')
                            <span class="badge-contabilidade">{{ $member['funcao'] }}</span>
                        @elseif($member['funcao'] == 'Professor')
                            <span class="badge-professor">{{ $member['funcao'] }}</span>
                        @else
                            <span class="badge-academico">{{ $member['funcao'] }}</span>
                        @endif
                    </td>
                    <td>
                        @if($member['estado'] == 'Ativo')
                            <span class="badge-ativo">{{ $member['estado'] }}</span>
                        @else
                            <span class="badge-suspenso">{{ $member['estado'] }}</span>
                        @endif
                    </td>
                    <td>{{ $member['data'] }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>

    <div class="footer">
        <p><strong>Total de registros:</strong> {{ count($staff) }}</p>
        <p>Este documento foi gerado automaticamente pelo sistema.</p>
    </div>
</body>
</html>
