<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Pré-inscrição Online - Colégio Politécnico de Moçambique">
    <title>Pré-inscrição Online - COPMOZ</title>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background: linear-gradient(135deg, #1a5276 0%, #2e86de 100%);
            min-height: 100vh;
        }
        .enrollment-container {
            min-height: 100vh;
            display: flex;
            align-items: flex-start;
            justify-content: center;
            padding: 30px 15px;
        }
        .enrollment-card {
            background: white;
            border-radius: 16px;
            box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.25);
            max-width: 900px;
            width: 100%;
            overflow: hidden;
        }
        .enrollment-header {
            background: linear-gradient(135deg, #1a5276 0%, #2e86de 100%);
            color: white;
            padding: 25px 30px;
            text-align: center;
        }
        .enrollment-header h1 {
            font-size: 22px;
            font-weight: 600;
            margin-bottom: 5px;
        }
        .enrollment-header p {
            opacity: 0.9;
            margin-bottom: 0;
            font-size: 14px;
        }
        .enrollment-body {
            padding: 30px;
        }
        .step-indicator {
            display: flex;
            justify-content: center;
            gap: 8px;
            margin-bottom: 25px;
        }
        .step-dot {
            width: 36px;
            height: 36px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 14px;
            font-weight: 600;
            border: 2px solid #e2e8f0;
            color: #94a3b8;
            background: white;
            transition: all 0.3s;
        }
        .step-dot.active {
            background: #2e86de;
            color: white;
            border-color: #2e86de;
        }
        .step-dot.completed {
            background: #27ae60;
            color: white;
            border-color: #27ae60;
        }
        .step-line {
            width: 40px;
            height: 2px;
            background: #e2e8f0;
            align-self: center;
        }
        .step-line.completed {
            background: #27ae60;
        }
        .form-label {
            font-weight: 500;
            font-size: 0.875rem;
            color: #475569;
        }
        .form-control, .form-select {
            border: 1px solid #cbd5e1;
            border-radius: 8px;
            padding: 0.625rem 0.875rem;
            font-size: 0.875rem;
        }
        .form-control:focus, .form-select:focus {
            border-color: #2e86de;
            box-shadow: 0 0 0 0.2rem rgba(46, 134, 222, 0.15);
        }
        .section-title {
            font-size: 1rem;
            font-weight: 600;
            color: #1e293b;
            margin-bottom: 15px;
            padding-bottom: 8px;
            border-bottom: 2px solid #2e86de;
        }
        .btn-next {
            background: #2e86de;
            border: none;
            color: white;
            padding: 10px 30px;
            border-radius: 8px;
            font-weight: 600;
        }
        .btn-next:hover { background: #1a5276; color: white; }
        .btn-prev {
            background: #e2e8f0;
            border: none;
            color: #475569;
            padding: 10px 30px;
            border-radius: 8px;
            font-weight: 600;
        }
        .btn-prev:hover { background: #cbd5e1; color: #1e293b; }
        .btn-submit {
            background: #27ae60;
            border: none;
            color: white;
            padding: 12px 40px;
            border-radius: 8px;
            font-weight: 600;
            font-size: 1rem;
        }
        .btn-submit:hover { background: #219a52; color: white; }
        .success-card {
            text-align: center;
            padding: 40px 20px;
        }
        .success-icon {
            width: 80px;
            height: 80px;
            background: #d4edda;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 20px;
        }
        .success-icon i { font-size: 40px; color: #27ae60; }
        .code-display {
            font-size: 1.5rem;
            font-weight: 700;
            color: #1a5276;
            background: #f0f7ff;
            padding: 12px 24px;
            border-radius: 8px;
            display: inline-block;
            letter-spacing: 2px;
        }
        .footer-text {
            text-align: center;
            padding: 20px;
            color: rgba(255, 255, 255, 0.8);
            font-size: 14px;
        }
        .logo-circle {
            width: 70px;
            height: 70px;
            background: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 12px;
        }
        .logo-circle i { font-size: 35px; color: #1a5276; }
    </style>

    @livewireStyles
</head>
<body>
    <div class="enrollment-container">
        {{ $slot }}
    </div>

    <div class="footer-text">
        <p>&copy; {{ date('Y') }} Colégio Politécnico de Moçambique</p>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    @livewireScripts
    <x-livewire-alert::scripts />
</body>
</html>
