<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card border-0 shadow">
                        <div class="card-header bg-primary text-white py-3">
                            <h2 class="h5 mb-0">
                                <i class="fas fa-book-reader me-2"></i>Adicionar Capítulo de Livro
                            </h2>
                        </div>
                        <div class="card-body p-4">
                            <div class="row justify-content-center">
                                <div class="col-12 col-md-10 col-lg-8 col-xl-7">
                                    <form wire:submit.prevent="submit">
                                        <!-- Title -->
                                        <div class="mb-3">
                                            <label for="title" class="form-label fw-semibold">Título <span class="text-danger">*</span></label>
                                            <div class="input-group">
                                                <span class="input-group-text bg-light"><i class="fas fa-heading"></i></span>
                                                <input type="text"
                                                       class="form-control @error('title') is-invalid @enderror"
                                                       id="title"
                                                       wire:model="title"
                                                       placeholder="Insira o título do capítulo..."
                                                       required>
                                            </div>
                                            @error('title')
                                                <div class="invalid-feedback d-block">{{ $message }}</div>
                                            @enderror
                                        </div>

                                        <!-- Book -->
                                        <div class="mb-3">
                                            <label for="book_id" class="form-label fw-semibold">Livro <span class="text-danger">*</span></label>
                                            <div class="input-group">
                                                <span class="input-group-text bg-light"><i class="fas fa-book"></i></span>
                                                <select class="form-select @error('book_id') is-invalid @enderror"
                                                        id="book_id"
                                                        wire:model="book_id"
                                                        required>
                                                    <option value="">Selecione o livro</option>
                                                    @foreach($books as $book)
                                                        <option value="{{ $book->id }}">{{ $book->title }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                            @error('book_id')
                                                <div class="invalid-feedback d-block">{{ $message }}</div>
                                            @enderror
                                        </div>

                                        <!-- Description -->
                                        <div class="mb-3" wire:model.debounce.365ms="description" wire:ignore>
                                            <label for="description" class="form-label fw-semibold">Descrição <span class="text-danger">*</span></label>
                                            <div class="input-group">
                                                <span class="input-group-text bg-light align-items-start pt-2">
                                                    <i class="fas fa-align-left"></i>
                                                </span>
                                                <div class="form-control p-0 border-0">
                                                    <input id="description"
                                                           value="{{ $description }}"
                                                           type="hidden"
                                                           name="description">
                                                    <trix-editor input="description"></trix-editor>
                                                </div>
                                            </div>
                                            @error('description')
                                                <div class="invalid-feedback d-block">{{ $message }}</div>
                                            @enderror
                                        </div>

                                        <!-- Submit Button -->
                                        <div class="d-flex justify-content-end border-top pt-4 mt-4">
                                            <button type="submit"
                                                    class="btn btn-primary px-5"
                                                    wire:loading.attr="disabled"
                                                    wire:target="submit">
                                                <span wire:loading wire:target="submit" class="spinner-border spinner-border-sm me-2"></span>
                                                <i wire:loading.remove wire:target="submit" class="fas fa-save me-2"></i>
                                                Guardar
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
