<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">Editar Turma</h5>
                            <form class="row g-3" wire:submit.prevent="submit">
                                <div class="col-md-6">
                                    <label for="title" class="form-label">Turma</label>
                                    <input type="text" class="form-control @error('name') is-invalid @enderror"
                                           id="name" required placeholder="Escreva a designação..." wire:model="name">
                                    @error('name')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <label for="class" class="form-label">Classe</label>
                                    <select class="form-control @error('class') is-invalid @enderror"
                                            id="class" wire:model="class"
                                            class="form-control input-lg dynamic">
                                            <option value="">Por favor selecione a classe</option>
                                            <option value="1">1ª Classe</option>
                                            <option value="2">2ª Classe</option>
                                            <option value="3">3ª Classe</option>
                                            <option value="4">4ª Classe</option>
                                            <option value="5">5ª Classe</option>
                                            <option value="6">6ª Classe</option>
                                            <option value="7">7ª Classe</option>
                                            <option value="8">8ª Classe</option>
                                            <option value="9">9ª Classe</option>
                                            <option value="10">10ª Classe</option>
                                            <option value="11">11ª Classe</option>
                                            <option value="12">12ª Classe</option>
                                    </select>
                                    @error('class')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <label for="capacity" class="form-label">Capacidade Máxima <span class="text-muted small">(opcional)</span></label>
                                    <input type="number" class="form-control @error('capacity') is-invalid @enderror"
                                           id="capacity" wire:model="capacity" placeholder="Ex: 30" min="1" max="200">
                                    @error('capacity')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                                <div class="col-md-12" wire:model.debounce.365ms="description" wire:ignore>
                                    <label for="description" class="form-label"><b> Descrição</b></label>
                                    <input id="description"
                                           value="{{ $description }}"
                                           type="hidden"
                                           name="description">
                                    <trix-editor
                                        input="description"></trix-editor>
                                    @error('description')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                                <div class="col-12">
                                    <button type="submit" class="btn btn-primary btn-lg float-end"
                                            wire:loading.class="disabled"
                                            wire:offline.attr="disabled"><span wire:target="submit"
                                                                               wire:loading.class="spinner-border spinner-border-lg"></span>
                                        Guardar
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
