<div class="page-content">
    <div class="container-fluid">
        <!-- Page Header -->
        <div class="row mb-4 mt-3">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="pt-3">
                        <h1 class="h3 mb-1 text-primary">
                            <i class="fas fa-school me-2"></i>Lista de Turmas
                        </h1>
                        <p class="text-muted mb-0">
                            Gerencie as turmas e classes do sistema
                        </p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Filters Card -->
        <div class="card border-0 shadow-sm mb-4">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h5 class="card-title mb-0 text-primary">
                        <i class="fas fa-filter me-2"></i>Filtros de Pesquisa
                    </h5>
                    <div class="btn-group" role="group">
                        <button type="button" wire:click="exportPDF" class="btn btn-danger btn-sm">
                            <i class="fa fa-file-pdf me-1"></i>PDF
                        </button>
                        <button type="button" wire:click="exportExcel" class="btn btn-success btn-sm">
                            <i class="fa fa-file-excel me-1"></i>Excel
                        </button>
                    </div>
                </div>

                <div class="row g-3">
                    <div class="col-md-3">
                        <label for="selectedClass" class="form-label">Classe</label>
                        <select class="form-select" wire:model="selectedClass" id="selectedClass">
                            <option value="">Todas</option>
                            @foreach($classes as $class)
                                <option value="{{ $class->class }}">{{ $class->class }}ª Classe</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="col-md-3">
                        <label for="selectedStatus" class="form-label">Estado</label>
                        <select class="form-select" wire:model="selectedStatus" id="selectedStatus">
                            <option value="">Todos</option>
                            <option value="1">Ativo</option>
                            <option value="0">Inativo</option>
                        </select>
                    </div>

                    <div class="col-md-6">
                        <label for="search" class="form-label">Pesquisar</label>
                        <input
                            type="search"
                            wire:model.debounce.300ms="search"
                            placeholder="Buscar por turma, classe ou descrição..."
                            class="form-control"
                            id="search"
                        />
                    </div>
                </div>
            </div>
        </div>

        <!-- Table Card -->
        <div class="card border-0 shadow-sm">
            <div class="card-body" wire:init="loadData">
                <div class="table-responsive">
                    @if(count($models))
                        <table class="table table-hover align-middle mb-0">
                            <thead class="bg-light">
                                <tr>
                                    <th style="width: 50px;">#</th>
                                    <th>Turma</th>
                                    <th>Classe</th>
                                    <th>Descrição</th>
                                    <th>Estudantes</th>
                                    <th>Estado</th>
                                    <th>Data de Criação</th>
                                    <th class="text-end pe-4" style="width: 250px;">Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                            @foreach($models as $model)
                                <tr style="transition: all 0.2s;">
                                    <td><span class="text-muted fw-bold">{{ $loop->iteration }}</span></td>
                                    <td>
                                        <strong class="text-dark">{{ $model->name }}</strong>
                                    </td>
                                    <td>
                                        <span class="badge bg-primary">{{ $model->class }}ª Classe</span>
                                    </td>
                                    <td>
                                        <span class="text-muted">{{ Str::limit(strip_tags($model->description), 40) }}</span>
                                    </td>
                                    <td>
                                        <span class="badge bg-info">{{ $model->students->count() }} alunos</span>
                                    </td>
                                    <td>
                                        @if ($model->is_active == 1)
                                            <span class="badge bg-success">Ativo</span>
                                        @else
                                            <span class="badge bg-secondary">Inativo</span>
                                        @endif
                                    </td>
                                    <td>
                                        <small class="text-muted">{{ $model->created_at->format('d/m/Y H:i') }}</small>
                                    </td>
                                    <td>
                                        <div class="btn-group btn-group-sm" role="group">
                                            <a href="{{ route('admin.edit.class', $model->slug) }}"
                                                class="btn btn-outline-primary btn-sm"
                                                title="Editar">
                                                <span class="fa fa-edit"></span>
                                            </a>
                                            <a href="{{ route('admin.list.class.students', $model->slug) }}"
                                                class="btn btn-outline-info btn-sm"
                                                title="Ver Estudantes">
                                                <span class="fa fa-users"></span>
                                            </a>
                                            <a href="{{ route('admin.list.class.update.students', $model->slug) }}"
                                                class="btn btn-outline-warning btn-sm"
                                                title="Passagem de Classe">
                                                <span class="fa fa-arrow-up"></span>
                                            </a>
                                            @if ($model->is_active == 1)
                                                <button wire:click="toggleStudentStatus('{{ $model->id }}', 0)"
                                                    class="btn btn-outline-danger btn-sm"
                                                    title="Desativar Estudantes">
                                                    <span class="fa fa-times"></span>
                                                </button>
                                            @else
                                                <button wire:click="toggleStudentStatus('{{ $model->id }}', 1)"
                                                    class="btn btn-outline-success btn-sm"
                                                    title="Ativar Estudantes">
                                                    <span class="fa fa-check"></span>
                                                </button>
                                            @endif
                                            <button wire:click="submit('{{ $model->id }}')"
                                                class="btn btn-outline-danger btn-sm"
                                                title="Deletar">
                                                <span class="fa fa-trash"></span>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>

                        <div class="d-flex justify-content-center mt-3">
                            {{ $models->links() }}
                        </div>
                    @else
                        <div class="text-center py-5">
                            <div wire:loading class="spinner-border text-primary mb-3" role="status">
                                <span class="visually-hidden">Processando...</span>
                            </div>
                            <p class="text-muted"><strong>Nenhuma turma foi encontrada.</strong></p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <style>
        .table-hover tbody tr:hover {
            background-color: #f8f9fa;
            transform: translateY(-2px);
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        }

        .form-select:focus, .form-control:focus {
            border-color: #4e73df;
            box-shadow: 0 0 0 0.2rem rgba(78, 115, 223, 0.25);
        }

        .btn-group-sm .btn {
            padding: 0.25rem 0.5rem;
        }
    </style>
</div>
