<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-center mb-4">
                                <h5 class="card-title mb-0">Importação de Notas via Excel</h5>

                                <!-- Step Progress Indicator -->
                                <div class="d-flex align-items-center">
                                    <div class="step-indicator d-flex">
                                        <div class="step {{ $step >= 1 ? 'active' : '' }}">
                                            <span class="step-number">1</span>
                                            <span class="step-label">Seleção</span>
                                        </div>
                                        <div class="step {{ $step >= 2 ? 'active' : '' }}">
                                            <span class="step-number">2</span>
                                            <span class="step-label">Upload</span>
                                        </div>
                                        <div class="step {{ $step >= 3 ? 'active' : '' }}">
                                            <span class="step-number">3</span>
                                            <span class="step-label">Preview</span>
                                        </div>
                                        <div class="step {{ $step >= 4 ? 'active' : '' }}">
                                            <span class="step-number">4</span>
                                            <span class="step-label">Resultado</span>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Step 1: Selection Form -->
                            @if($step == 1)
                                <div class="selection-form">
                                    <h6 class="mb-3">Configurações da Importação</h6>

                                    <div class="row">
                                        <!-- Year Selection -->
                                        <div class="col-md-6 mb-3">
                                            <label for="year" class="form-label">Ano Lectivo</label>
                                            <select class="form-control @error('year') is-invalid @enderror" wire:model="year">
                                                <option value="">Selecione o ano</option>
                                                @php
                                                    $currentYear = (int)date('Y');
                                                    $startYear = $currentYear;
                                                    $endYear = $currentYear + 2;
                                                @endphp
                                                @for($year = $startYear; $year <= $endYear; $year++)
                                                    <option value="{{ $year }}">{{ $year }}</option>
                                                @endfor
                                            </select>
                                            @error('year') <span class="invalid-feedback">{{ $message }}</span> @enderror
                                        </div>

                                        <!-- Trimester Selection -->
                                        <div class="col-md-6 mb-3">
                                            <label for="trimester_id" class="form-label">Trimestre</label>
                                            <select class="form-control @error('trimester_id') is-invalid @enderror" wire:model="trimester_id">
                                                <option value="">Selecione o trimestre</option>
                                                <option value="1">Primeiro Trimestre</option>
                                                <option value="2">Segundo Trimestre</option>
                                                <option value="3">Terceiro Trimestre</option>
                                            </select>
                                            @error('trimester_id') <span class="invalid-feedback">{{ $message }}</span> @enderror
                                        </div>

                                        <!-- Class Level Selection -->
                                        <div class="col-md-6 mb-3">
                                            <label for="class_level" class="form-label">Classe</label>
                                            <select class="form-control @error('class_level') is-invalid @enderror" wire:model="class_level">
                                                <option value="">Selecione a classe</option>
                                                @if($isTeacher && !empty($availableClassLevels))
                                                    @foreach($availableClassLevels as $classLevel)
                                                        <option value="{{ $classLevel }}">{{ $classLevel }}ª Classe</option>
                                                    @endforeach
                                                @else
                                                    @for($i = 1; $i <= 12; $i++)
                                                        <option value="{{ $i }}">{{ $i }}ª Classe</option>
                                                    @endfor
                                                @endif
                                            </select>
                                            @error('class_level') <span class="invalid-feedback">{{ $message }}</span> @enderror
                                        </div>

                                        <!-- Classroom Selection -->
                                        <div class="col-md-6 mb-3">
                                            <label for="classroom_id" class="form-label">Turma</label>
                                            <select class="form-control @error('classroom_id') is-invalid @enderror" wire:model="classroom_id" {{ empty($class_level) ? 'disabled' : '' }}>
                                                <option value="">Selecione a turma</option>
                                                @foreach ($classrooms as $classroom)
                                                    <option value="{{ $classroom->id }}">{{ $classroom->name }}</option>
                                                @endforeach
                                            </select>
                                            @error('classroom_id') <span class="invalid-feedback">{{ $message }}</span> @enderror
                                        </div>

                                        <!-- Subject Selection -->
                                        <div class="col-md-12 mb-3">
                                            <label for="subject_id" class="form-label">Disciplina</label>
                                            <select class="form-control @error('subject_id') is-invalid @enderror" wire:model="subject_id" {{ empty($classroom_id) ? 'disabled' : '' }}>
                                                <option value="">Selecione a disciplina</option>
                                                @foreach ($subjects as $subject)
                                                    <option value="{{ $subject->id }}">{{ $subject->name }}</option>
                                                @endforeach
                                            </select>
                                            @error('subject_id') <span class="invalid-feedback">{{ $message }}</span> @enderror
                                        </div>

                                        <!-- Clean Existing Option -->
                                        <div class="col-md-12 mb-3">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" wire:model="clean_existing" id="clean_existing">
                                                <label class="form-check-label" for="clean_existing">
                                                    Limpar notas existentes antes da importação
                                                </label>
                                            </div>
                                            <small class="form-text text-muted">Se marcado, todas as notas existentes para esta configuração serão removidas antes da importação.</small>
                                        </div>
                                    </div>

                                    <div class="d-flex justify-content-end">
                                        <button type="button" class="btn btn-primary" wire:click="nextStep" {{ empty($subject_id) ? 'disabled' : '' }}>
                                            Próximo <i class="fas fa-arrow-right"></i>
                                        </button>
                                    </div>
                                </div>
                            @endif

                            <!-- Step 2: File Upload -->
                            @if($step == 2)
                                <div class="file-upload-form">
                                    <h6 class="mb-3">Upload do Arquivo Excel</h6>

                                    <div class="alert alert-info">
                                        <i class="fas fa-info-circle"></i>
                                        <strong>Formato esperado:</strong> O arquivo Excel deve conter os nomes dos estudantes na coluna B, começando aproximadamente na linha 10-15.
                                    </div>

                                    <div class="mb-3">
                                        <label for="excel_file" class="form-label">Arquivo Excel (.xlsx, .xls)</label>
                                        <input type="file" class="form-control @error('excel_file') is-invalid @enderror"
                                               wire:model="excel_file" accept=".xlsx,.xls">
                                        @error('excel_file') <span class="invalid-feedback">{{ $message }}</span> @enderror
                                    </div>

                                    <div wire:loading wire:target="excel_file" class="text-center my-3">
                                        <div class="spinner-border text-primary" role="status">
                                            <span class="sr-only">Validando arquivo...</span>
                                        </div>
                                        <p class="mt-2">Validando arquivo Excel...</p>
                                    </div>

                                    @if($validation_result && !$validation_result['valid'])
                                        <div class="alert alert-danger">
                                            <i class="fas fa-exclamation-triangle"></i>
                                            {{ $validation_result['message'] }}
                                        </div>
                                    @endif

                                    <div class="d-flex justify-content-between">
                                        <button type="button" class="btn btn-secondary" wire:click="previousStep">
                                            <i class="fas fa-arrow-left"></i> Voltar
                                        </button>
                                        <button type="button" class="btn btn-outline-danger" wire:click="resetImport">
                                            <i class="fas fa-times"></i> Cancelar
                                        </button>
                                    </div>
                                </div>
                            @endif

                            <!-- Step 3: Preview -->
                            @if($step == 3)
                                <div class="preview-section">
                                    <h6 class="mb-3">Preview dos Dados</h6>

                                    @if(!empty($preview_data))
                                        <!-- Applied Corrections Info -->
                                        @if(!empty($student_corrections))
                                            <div class="alert alert-info mb-3">
                                                <i class="fas fa-info-circle"></i>
                                                <strong>Correções Aplicadas:</strong> {{ count($student_corrections) }} correção(ões) de nome será(ão) aplicada(s) durante a importação.
                                            </div>
                                        @endif

                                        <div class="table-responsive mb-3">
                                            <table class="table table-sm table-bordered">
                                                <thead class="table-light">
                                                    <tr>
                                                        @foreach(array_slice(['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'], 0, count($preview_data[0] ?? [])) as $col)
                                                            <th>{{ $col }}</th>
                                                        @endforeach
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($preview_data as $rowIndex => $row)
                                                        <tr class="{{ $rowIndex > 9 ? 'table-warning' : '' }}">
                                                            @foreach($row as $cell)
                                                                <td>{{ $cell }}</td>
                                                            @endforeach
                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                        <p class="text-muted">
                                            <i class="fas fa-info-circle"></i>
                                            <strong>Atenção:</strong> Certifique-se de que os nomes dos estudantes correspondam aos nomes cadastrados no sistema.
                                        </p>
                                    @endif

                                    <div class="d-flex justify-content-between">
                                        <button type="button" class="btn btn-secondary" wire:click="previousStep">
                                            <i class="fas fa-arrow-left"></i> Voltar
                                        </button>
                                        <div>
                                            <button type="button" class="btn btn-outline-danger me-2" wire:click="resetImport">
                                                <i class="fas fa-times"></i> Cancelar
                                            </button>
                                            <button type="button" class="btn btn-success" wire:click="importMarks" wire:loading.attr="disabled">
                                                <span wire:loading wire:target="importMarks" class="spinner-border spinner-border-sm me-1"></span>
                                                <i class="fas fa-upload"></i> Importar Notas
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            @endif

                            <!-- Step 4: Results -->
                            @if($step == 4 && $import_result)
                                <div class="results-section">
                                    <h6 class="mb-3">Resultado da Importação</h6>

                                    @if($import_result['success'])
                                        @php $stats = $import_result['data']; @endphp

                                        <!-- Summary Cards -->
                                        <div class="row mb-4">
                                            <div class="col-md-3">
                                                <div class="card bg-light">
                                                    <div class="card-body text-center">
                                                        <h3 class="text-primary">{{ $stats['total_rows'] }}</h3>
                                                        <p class="mb-0">Total de Linhas</p>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="card bg-success text-white">
                                                    <div class="card-body text-center">
                                                        <h3>{{ $stats['successful'] }}</h3>
                                                        <p class="mb-0">Sucessos</p>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="card bg-danger text-white">
                                                    <div class="card-body text-center">
                                                        <h3>{{ $stats['failed'] }}</h3>
                                                        <p class="mb-0">Falhas</p>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="card bg-info text-white">
                                                    <div class="card-body text-center">
                                                        <h3>{{ number_format(($stats['successful'] / max($stats['total_rows'], 1)) * 100, 1) }}%</h3>
                                                        <p class="mb-0">Taxa de Sucesso</p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Detailed Error Reports -->
                                        @if($stats['failed'] > 0 && isset($stats['detailed_errors']))
                                            <div class="error-details">

                                                <!-- Students in Different Classrooms -->
                                                @if(!empty($stats['detailed_errors']['student_in_different_classroom']))
                                                    <div class="card mb-3">
                                                        <div class="card-header bg-warning">
                                                            <h6 class="mb-0">
                                                                <i class="fas fa-exchange-alt"></i>
                                                                Estudantes em Turmas Diferentes ({{ count($stats['detailed_errors']['student_in_different_classroom']) }})
                                                            </h6>
                                                        </div>
                                                        <div class="card-body">
                                                            <p class="text-muted mb-3">Os seguintes estudantes foram encontrados, mas estão em turmas diferentes:</p>
                                                            <div class="table-responsive">
                                                                <table class="table table-sm">
                                                                    <thead>
                                                                        <tr>
                                                                            <th>Linha Excel</th>
                                                                            <th>Nome do Estudante</th>
                                                                            <th>Turma Atual</th>
                                                                            <th>Ações</th>
                                                                        </tr>
                                                                    </thead>
                                                                    <tbody>
                                                                        @foreach($stats['detailed_errors']['student_in_different_classroom'] as $error)
                                                                            <tr>
                                                                                <td><span class="badge bg-secondary">{{ $error['row_number'] }}</span></td>
                                                                                <td>{{ $error['student_name'] }}</td>
                                                                                <td>{{ $error['current_classroom'] }}</td>
                                                                                <td>
                                                                                    <button class="btn btn-sm btn-outline-primary"
                                                                                            wire:click="moveStudentToCorrectClass('{{ $error['student_id'] }}', '{{ $classroom_id }}')"
                                                                                            title="Mover estudante para a turma correta">
                                                                                        <i class="fas fa-arrow-right"></i> Mover
                                                                                    </button>
                                                                                </td>
                                                                            </tr>
                                                                        @endforeach
                                                                    </tbody>
                                                                </table>
                                                            </div>
                                                        </div>
                                                    </div>
                                                @endif

                                                <!-- Students Not Found -->
                                                @if(!empty($stats['detailed_errors']['student_name_not_found']))
                                                    <div class="card mb-3">
                                                        <div class="card-header bg-danger text-white">
                                                            <h6 class="mb-0">
                                                                <i class="fas fa-user-times"></i>
                                                                Estudantes Não Encontrados ({{ count($stats['detailed_errors']['student_name_not_found']) }})
                                                            </h6>
                                                        </div>
                                                        <div class="card-body">
                                                            <p class="text-muted mb-3">Os seguintes nomes não foram encontrados no sistema:</p>
                                                            <div class="table-responsive">
                                                                <table class="table table-sm">
                                                                    <thead>
                                                                        <tr>
                                                                            <th>Linha Excel</th>
                                                                            <th>Nome no Excel</th>
                                                                            <th>Sugestões</th>
                                                                            <th>Ações</th>
                                                                        </tr>
                                                                    </thead>
                                                                    <tbody>
                                                                        @foreach($stats['detailed_errors']['student_name_not_found'] as $error)
                                                                            <tr>
                                                                                <td><span class="badge bg-secondary">{{ $error['row_number'] }}</span></td>
                                                                                <td>{{ $error['student_name'] }}</td>
                                                                                <td>
                                                                                    @if(!empty($error['suggestions']))
                                                                                        <div class="small">
                                                                                            @foreach(array_slice($error['suggestions'], 0, 3) as $suggestion)
                                                                                                <span class="badge bg-light text-dark me-1">{{ $suggestion }}</span>
                                                                                            @endforeach
                                                                                        </div>
                                                                                    @else
                                                                                        <span class="text-muted">Nenhuma sugestão</span>
                                                                                    @endif
                                                                                </td>
                                                                                <td>
                                                                                    <button class="btn btn-sm btn-outline-secondary"
                                                                                            wire:click="showCorrectionsModal('{{ $error['student_name'] }}', {{ $error['row_number'] }})"
                                                                                            title="Corrigir nome do estudante">
                                                                                        <i class="fas fa-edit"></i> Corrigir
                                                                                    </button>
                                                                                </td>
                                                                            </tr>
                                                                        @endforeach
                                                                    </tbody>
                                                                </table>
                                                            </div>
                                                        </div>
                                                    </div>
                                                @endif

                                                <!-- Applied Corrections Section -->
                                                @if(!empty($student_corrections))
                                                    <div class="card mb-3">
                                                        <div class="card-header bg-info text-white">
                                                            <h6 class="mb-0">
                                                                <i class="fas fa-check-circle"></i>
                                                                Correções Aplicadas ({{ count($student_corrections) }})
                                                            </h6>
                                                        </div>
                                                        <div class="card-body">
                                                            <p class="text-muted mb-3">As seguintes correções foram aplicadas:</p>
                                                            <div class="table-responsive">
                                                                <table class="table table-sm">
                                                                    <thead>
                                                                        <tr>
                                                                            <th>Nome no Excel</th>
                                                                            <th>Estudante Correto</th>
                                                                            <th>Ações</th>
                                                                        </tr>
                                                                    </thead>
                                                                    <tbody>
                                                                        @foreach($student_corrections as $excelName => $studentId)
                                                                            @php
                                                                                $correctedStudent = collect($available_students)->firstWhere('id', $studentId);
                                                                            @endphp
                                                                            <tr>
                                                                                <td>{{ $excelName }}</td>
                                                                                <td>
                                                                                    @if($correctedStudent)
                                                                                        {{ $correctedStudent['name'] }} ({{ $correctedStudent['student_id'] }})
                                                                                    @else
                                                                                        <span class="text-muted">Estudante não encontrado</span>
                                                                                    @endif
                                                                                </td>
                                                                                <td>
                                                                                    <button class="btn btn-sm btn-outline-danger"
                                                                                            wire:click="removeCorrectionForStudent('{{ $excelName }}')"
                                                                                            title="Remover correção">
                                                                                        <i class="fas fa-times"></i>
                                                                                    </button>
                                                                                </td>
                                                                            </tr>
                                                                        @endforeach
                                                                    </tbody>
                                                                </table>
                                                            </div>
                                                            <div class="mt-3">
                                                                <button type="button" class="btn btn-success" wire:click="importWithCorrections">
                                                                    <i class="fas fa-redo"></i> Re-importar com Correções
                                                                </button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                @endif

                                                <!-- Other Errors -->
                                                @if(!empty($stats['detailed_errors']['other_errors']))
                                                    <div class="card mb-3">
                                                        <div class="card-header bg-secondary text-white">
                                                            <h6 class="mb-0">
                                                                <i class="fas fa-exclamation-circle"></i>
                                                                Outros Erros ({{ count($stats['detailed_errors']['other_errors']) }})
                                                            </h6>
                                                        </div>
                                                        <div class="card-body">
                                                            <div class="table-responsive">
                                                                <table class="table table-sm">
                                                                    <thead>
                                                                        <tr>
                                                                            <th>Linha Excel</th>
                                                                            <th>Nome do Estudante</th>
                                                                            <th>Erro</th>
                                                                        </tr>
                                                                    </thead>
                                                                    <tbody>
                                                                        @foreach($stats['detailed_errors']['other_errors'] as $error)
                                                                            <tr>
                                                                                <td><span class="badge bg-secondary">{{ $error['row_number'] }}</span></td>
                                                                                <td>{{ $error['student_name'] }}</td>
                                                                                <td>{{ $error['message'] }}</td>
                                                                            </tr>
                                                                        @endforeach
                                                                    </tbody>
                                                                </table>
                                                            </div>
                                                        </div>
                                                    </div>
                                                @endif
                                            </div>
                                        @endif

                                        <div class="d-flex justify-content-between">
                                            <button type="button" class="btn btn-primary" wire:click="resetImport">
                                                <i class="fas fa-plus"></i> Nova Importação
                                            </button>
                                            @if($stats['failed'] > 0)
                                                <button type="button" class="btn btn-success" wire:click="importMarks">
                                                    <i class="fas fa-redo"></i> Tentar Importar Novamente
                                                </button>
                                            @endif
                                        </div>

                                    @else
                                        <div class="alert alert-danger">
                                            <i class="fas fa-exclamation-triangle"></i>
                                            <strong>Erro na importação:</strong> {{ $import_result['message'] }}
                                        </div>

                                        <div class="d-flex justify-content-between">
                                            <button type="button" class="btn btn-secondary" wire:click="previousStep">
                                                <i class="fas fa-arrow-left"></i> Voltar
                                            </button>
                                            <button type="button" class="btn btn-primary" wire:click="resetImport">
                                                <i class="fas fa-redo"></i> Tentar Novamente
                                            </button>
                                        </div>
                                    @endif
                                </div>
                            @endif

                            <!-- Student Correction Modal -->
                            @if($show_corrections_modal && $selected_student_for_correction)
                                <div class="modal fade show d-block" tabindex="-1" style="background-color: rgba(0,0,0,0.5);">
                                    <div class="modal-dialog">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title">Corrigir Nome do Estudante</h5>
                                                <button type="button" class="btn-close" wire:click="closeCorrectionsModal"></button>
                                            </div>
                                            <div class="modal-body">
                                                <p><strong>Nome no Excel:</strong> {{ $selected_student_for_correction['name'] }}</p>
                                                <p><strong>Linha:</strong> {{ $selected_student_for_correction['row'] }}</p>

                                                <label class="form-label">Selecione o estudante correto:</label>
                                                <select class="form-control" wire:model="selected_correction_student">
                                                    <option value="">Selecione um estudante...</option>
                                                    @foreach($available_students as $student)
                                                        <option value="{{ $student['id'] }}">{{ $student['name'] }} ({{ $student['student_id'] }})</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" wire:click="closeCorrectionsModal">Cancelar</button>
                                                <button type="button" class="btn btn-primary"
                                                        wire:click="applyCorrectionForStudent"
                                                        {{ empty($selected_correction_student) ? 'disabled' : '' }}>
                                                    Aplicar Correção
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<style>
    .step-indicator {
        display: flex;
        align-items: center;
        gap: 20px;
    }

    .step {
        display: flex;
        flex-direction: column;
        align-items: center;
        opacity: 0.5;
        transition: opacity 0.3s;
    }

    .step.active {
        opacity: 1;
    }

    .step-number {
        width: 30px;
        height: 30px;
        border-radius: 50%;
        background-color: #e9ecef;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: bold;
        color: #6c757d;
        margin-bottom: 5px;
        transition: all 0.3s;
    }

    .step.active .step-number {
        background-color: #007bff;
        color: white;
    }

    .step-label {
        font-size: 12px;
        color: #6c757d;
        font-weight: 500;
    }

    .step.active .step-label {
        color: #007bff;
    }

    /* Add connecting lines between steps */
    .step:not(:last-child)::after {
        content: '';
        position: absolute;
        width: 20px;
        height: 2px;
        background-color: #e9ecef;
        top: 15px;
        right: -20px;
        z-index: -1;
        transition: background-color 0.3s;
    }

    .step.active:not(:last-child)::after {
        background-color: #007bff;
    }

    .step {
        position: relative;
    }

    /* File upload styling */
    .file-upload-form input[type="file"] {
        border: 2px dashed #dee2e6;
        border-radius: 8px;
        padding: 20px;
        text-align: center;
        background-color: #f8f9fa;
        transition: border-color 0.3s, background-color 0.3s;
    }

    .file-upload-form input[type="file"]:hover {
        border-color: #007bff;
        background-color: #e3f2fd;
    }

    .file-upload-form input[type="file"]:focus {
        border-color: #007bff;
        box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25);
        outline: none;
    }

    /* Preview table styling */
    .preview-section .table {
        font-size: 12px;
    }

    .preview-section .table th {
        background-color: #f8f9fa;
        font-weight: 600;
        text-align: center;
        border: 1px solid #dee2e6;
    }

    .preview-section .table td {
        border: 1px solid #dee2e6;
        max-width: 150px;
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
    }

    .table-warning {
        background-color: #fff3cd !important;
    }

    /* Results section styling */
    .results-section .card {
        transition: transform 0.2s, box-shadow 0.2s;
    }

    .results-section .card:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
    }

    .results-section .card h3 {
        font-size: 2rem;
        font-weight: bold;
        margin-bottom: 0;
    }

    /* Error details styling */
    .error-details .card-header {
        border-bottom: 2px solid rgba(255, 255, 255, 0.2);
    }

    .error-details .card-header h6 {
        font-weight: 600;
    }

    .error-details .badge {
        font-size: 0.8em;
    }

    .error-details .table th {
        background-color: rgba(0, 0, 0, 0.05);
        font-weight: 600;
        font-size: 0.85em;
        border: 1px solid #dee2e6;
    }

    .error-details .table td {
        vertical-align: middle;
        font-size: 0.85em;
        border: 1px solid #dee2e6;
    }

    /* Modal styling improvements */
    .modal.show {
        animation: fadeIn 0.3s ease;
    }

    @keyframes fadeIn {
        from { opacity: 0; }
        to { opacity: 1; }
    }

    .modal-content {
        border-radius: 10px;
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.3);
    }

    .modal-header {
        border-bottom: 2px solid #e9ecef;
        background-color: #f8f9fa;
        border-radius: 10px 10px 0 0;
    }

    .modal-footer {
        border-top: 2px solid #e9ecef;
        background-color: #f8f9fa;
        border-radius: 0 0 10px 10px;
    }

    /* Alert styling improvements */
    .alert {
        border-radius: 8px;
        border: none;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
    }

    .alert i {
        margin-right: 8px;
    }

    /* Button styling improvements */
    .btn {
        border-radius: 6px;
        font-weight: 500;
        transition: all 0.3s;
    }

    .btn:hover {
        transform: translateY(-1px);
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.15);
    }

    .btn i {
        margin-right: 5px;
    }

    .btn-outline-danger:hover,
    .btn-outline-secondary:hover,
    .btn-outline-primary:hover,
    .btn-outline-info:hover {
        transform: translateY(-1px);
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.15);
    }

    /* Form styling improvements */
    .form-control:focus {
        border-color: #007bff;
        box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25);
    }

    .form-check-input:focus {
        box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25);
    }

    /* Selection form styling */
    .selection-form .form-label {
        font-weight: 600;
        color: #495057;
        margin-bottom: 5px;
    }

    .selection-form select:disabled {
        background-color: #f8f9fa;
        opacity: 0.6;
    }

    /* Loading spinner improvements */
    .spinner-border {
        animation: spin 1s linear infinite;
    }

    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }

    /* Responsive improvements */
    @media (max-width: 768px) {
        .step-indicator {
            gap: 10px;
        }

        .step-label {
            display: none;
        }

        .results-section .row .col-md-3 {
            margin-bottom: 15px;
        }

        .error-details .table-responsive {
            font-size: 0.8rem;
        }

        .btn {
            font-size: 0.9rem;
            padding: 8px 12px;
        }
    }

    @media (max-width: 576px) {
        .step-number {
            width: 25px;
            height: 25px;
            font-size: 0.8rem;
        }

        .d-flex.justify-content-between {
            flex-direction: column;
            gap: 10px;
        }

        .d-flex.justify-content-between .btn {
            width: 100%;
        }
    }

    /* Card hover effects */
    .card {
        transition: all 0.3s ease;
        border: 1px solid #dee2e6;
        border-radius: 10px;
    }

    .card:hover {
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
    }

    /* Additional utility classes */
    .text-truncate-custom {
        max-width: 200px;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }

    .border-warning-custom {
        border: 2px solid #ffc107 !important;
    }

    .bg-light-custom {
        background-color: #f8f9fa !important;
    }

    /* Success/Error state indicators */
    .status-success {
        color: #28a745;
        font-weight: 600;
    }

    .status-error {
        color: #dc3545;
        font-weight: 600;
    }

    .status-warning {
        color: #ffc107;
        font-weight: 600;
    }

    /* Progress indicators */
    .progress-custom {
        height: 8px;
        border-radius: 4px;
        background-color: #e9ecef;
        overflow: hidden;
    }

    .progress-bar-custom {
        height: 100%;
        background-color: #007bff;
        transition: width 0.3s ease;
    }
</style>
