<div class="page-content">
    <div class="main-wrapper">
        <!-- Header -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h4 class="mb-1"><i class="fas fa-user-shield text-primary me-2"></i>Gestão de Permissões</h4>
                        <p class="text-muted mb-0">Controle o acesso dos usuários às funcionalidades do sistema</p>
                    </div>
                    <div class="d-flex gap-2">
                        <a href="{{ route('admin.home') }}" class="btn btn-outline-secondary">
                            <i class="fas fa-arrow-left me-1"></i> Voltar
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <!-- Left Sidebar - User List -->
            <div class="col-md-4 mb-4">
                <div class="card shadow-sm">
                    <div class="card-header bg-primary text-white">
                        <h5 class="mb-0"><i class="fas fa-users me-2"></i>Selecionar Usuário</h5>
                    </div>
                    <div class="card-body p-0">
                        <!-- Search Box -->
                        <div class="p-3 border-bottom">
                            <input
                                type="text"
                                wire:model.debounce.500ms="search"
                                class="form-control"
                                placeholder="Pesquisar usuário..."
                            >
                        </div>

                        <!-- User List -->
                        <div class="list-group list-group-flush" style="max-height: 600px; overflow-y: auto;">
                            @forelse($admins as $admin)
                                <button
                                    type="button"
                                    wire:click="selectAdmin('{{ $admin->id }}')"
                                    class="list-group-item list-group-item-action {{ $selectedAdmin && $selectedAdmin->id == $admin->id ? 'active' : '' }}"
                                >
                                    <div class="d-flex w-100 justify-content-between align-items-center">
                                        <div>
                                            <h6 class="mb-1">{{ $admin->name }}</h6>
                                            <small class="{{ $selectedAdmin && $selectedAdmin->id == $admin->id ? 'text-white-50' : 'text-muted' }}">
                                                {{ $admin->email }}
                                            </small>
                                        </div>
                                        @if($selectedAdmin && $selectedAdmin->id == $admin->id)
                                            <i class="fas fa-chevron-right"></i>
                                        @endif
                                    </div>
                                    <div class="mt-2 d-flex gap-2 align-items-center flex-wrap">
                                        <span class="badge bg-{{ $admin->role == 0 ? 'danger' : ($admin->role == 1 ? 'warning' : ($admin->role == 2 ? 'info' : ($admin->role == 3 ? 'success' : ($admin->role == 4 ? 'primary' : ($admin->role == 5 ? 'dark' : 'secondary'))))) }}">
                                            @if($admin->role == 0)
                                                <i class="fas fa-crown me-1"></i> PCA
                                            @elseif($admin->role == 1)
                                                Reg Academico
                                            @elseif($admin->role == 2)
                                                Professor
                                            @elseif($admin->role == 3)
                                                Diretor
                                            @elseif($admin->role == 4)
                                                Admin
                                            @elseif($admin->role == 5)
                                                Contabilidade
                                            @else
                                                Secretaria
                                            @endif
                                        </span>
                                        @if($admin->role == 0)
                                            <span class="badge bg-light text-danger border border-danger" style="font-size: 0.7rem;">
                                                <i class="fas fa-check-circle me-1"></i> Aprovar refs
                                            </span>
                                        @endif
                                    </div>
                                </button>
                            @empty
                                <div class="list-group-item text-center py-4 text-muted">
                                    <i class="fas fa-users fa-2x mb-2 d-block"></i>
                                    Nenhum usuário encontrado
                                </div>
                            @endforelse
                        </div>
                    </div>
                </div>
            </div>

            <!-- Right Content - Permissions -->
            <div class="col-md-8">
                @if($selectedAdmin)
                    <div class="card shadow-sm">
                        <div class="card-header bg-light">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <h5 class="mb-0">
                                        <i class="fas fa-key text-warning me-2"></i>Permissões de {{ $selectedAdmin->name }}
                                    </h5>
                                    <small class="text-muted">{{ $selectedAdmin->email }}</small>
                                    <br>
                                    <span class="badge bg-{{ $selectedAdmin->role == 0 ? 'danger' : ($selectedAdmin->role == 1 ? 'warning' : ($selectedAdmin->role == 2 ? 'info' : 'success')) }} mt-1">
                                        {{ $selectedAdmin->getRoleName() }}
                                    </span>
                                </div>
                                <div class="btn-group btn-group-sm">
                                    <button wire:click="grantAll" class="btn btn-success">
                                        <i class="fas fa-check-double me-1"></i> Marcar Todas
                                    </button>
                                    <button wire:click="revokeAll" class="btn btn-danger">
                                        <i class="fas fa-times-circle me-1"></i> Desmarcar Todas
                                    </button>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <!-- Role Management Card - Destacado -->
                            <div class="card mb-4" style="border: 2px solid {{ $selectedAdmin->role == 0 ? '#dc3545' : '#0d6efd' }}; background: linear-gradient(135deg, {{ $selectedAdmin->role == 0 ? '#fff5f5' : '#f8f9ff' }} 0%, #ffffff 100%);">
                                <div class="card-body">
                                    <div class="row align-items-center">
                                        <div class="col-md-8">
                                            <h6 class="mb-3">
                                                <i class="fas fa-user-cog me-2" style="color: {{ $selectedAdmin->role == 0 ? '#dc3545' : '#0d6efd' }};"></i>
                                                <strong>Nível de Acesso do Usuário</strong>
                                            </h6>

                                            <div class="mb-3">
                                                <label class="form-label fw-semibold mb-2">
                                                    <i class="fas fa-shield-alt me-1"></i> Perfil/Role do Sistema
                                                </label>
                                                <select class="form-select form-select-lg" wire:change="changeRole($event.target.value)" style="cursor: pointer; max-width: 500px;">
                                                    <option value="0" {{ $selectedAdmin->role == 0 ? 'selected' : '' }}>
                                                        🔴 PCA (Super Admin) - Acesso Total
                                                    </option>
                                                    <option value="1" {{ $selectedAdmin->role == 1 ? 'selected' : '' }}>
                                                        🟡 Reg Academico - Gestão Acadêmica Completa
                                                    </option>
                                                    <option value="2" {{ $selectedAdmin->role == 2 ? 'selected' : '' }}>
                                                        🔵 Professor - Ensino e Notas
                                                    </option>
                                                    <option value="3" {{ $selectedAdmin->role == 3 ? 'selected' : '' }}>
                                                        🟢 Diretor - Supervisão Geral
                                                    </option>
                                                    <option value="4" {{ $selectedAdmin->role == 4 ? 'selected' : '' }}>
                                                        🟣 Admin - Gestão Ampla (sem aprovar refs)
                                                    </option>
                                                    <option value="5" {{ $selectedAdmin->role == 5 ? 'selected' : '' }}>
                                                        🟠 Contabilidade - Financeiro e POS
                                                    </option>
                                                    <option value="6" {{ $selectedAdmin->role == 6 ? 'selected' : '' }}>
                                                        ⚪ Secretaria - Inscrições e Matrículas
                                                    </option>
                                                </select>
                                            </div>

                                            @if($selectedAdmin->role == 0)
                                                <div class="alert alert-danger mb-0">
                                                    <i class="fas fa-crown me-2"></i>
                                                    <strong>PCA (Super Admin):</strong> Este usuário tem acesso total e irrestrito a todas as funcionalidades do sistema, incluindo aprovação de referências de pagamento.
                                                </div>
                                            @else
                                                <div class="alert alert-info mb-0">
                                                    <i class="fas fa-info-circle me-2"></i>
                                                    <strong>Permissões do Role "{{ $selectedAdmin->getRoleName() }}":</strong>
                                                    Este role possui permissões padrão ativadas. Você pode personalizar adicionando ou removendo permissões abaixo.
                                                </div>
                                            @endif
                                        </div>

                                        <div class="col-md-4 text-center">
                                            <div class="p-4 rounded" style="background: {{ $selectedAdmin->role == 0 ? 'linear-gradient(135deg, #dc3545 0%, #c82333 100%)' : 'linear-gradient(135deg, #0d6efd 0%, #0a58ca 100%)' }};">
                                                <i class="fas {{ $selectedAdmin->role == 0 ? 'fa-crown' : 'fa-user-shield' }} fa-3x text-white mb-3"></i>
                                                <h5 class="text-white mb-1">
                                                    {{ $selectedAdmin->role == 0 ? 'PCA' : $selectedAdmin->getRoleName() }}
                                                </h5>
                                                <small class="text-white-50">
                                                    {{ $selectedAdmin->role == 0 ? 'Acesso Total' : 'Acesso Personalizado' }}
                                                </small>
                                            </div>

                                            @if($selectedAdmin->role == 0)
                                                <div class="mt-3">
                                                    <span class="badge bg-danger p-2">
                                                        <i class="fas fa-check-circle me-1"></i> Pode aprovar referências
                                                    </span>
                                                </div>
                                            @else
                                                <div class="mt-3">
                                                    <span class="badge bg-secondary p-2">
                                                        <i class="fas fa-lock me-1"></i> Não pode aprovar referências
                                                    </span>
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Permissões -->
                            <div class="card mb-4">
                                <div class="card-header bg-light d-flex justify-content-between align-items-center">
                                    <h6 class="mb-0">
                                        <i class="fas fa-key text-warning me-2"></i>Permissões do Sistema
                                    </h6>
                                    @if($selectedAdmin->role != 0)
                                    <div class="btn-group btn-group-sm">
                                        <button wire:click="grantAll" class="btn btn-success">
                                            <i class="fas fa-check-double me-1"></i> Marcar Todas
                                        </button>
                                        <button wire:click="revokeAll" class="btn btn-danger">
                                            <i class="fas fa-times-circle me-1"></i> Desmarcar Todas
                                        </button>
                                    </div>
                                    @endif
                                </div>
                                <div class="card-body">
                                    @if($selectedAdmin->role == 0)
                                        <!-- PCA - Mostrar todas as permissões marcadas e desabilitadas -->
                                        <div class="alert alert-success mb-3">
                                            <i class="fas fa-crown me-2"></i>
                                            <strong>PCA tem TODAS as permissões ativadas automaticamente.</strong>
                                            As permissões abaixo estão apenas para visualização.
                                        </div>
                                    @else
                                        <!-- Info sobre customização -->
                                        <div class="alert alert-info mb-3">
                                            <div class="d-flex align-items-start">
                                                <i class="fas fa-info-circle fa-2x me-3 mt-1"></i>
                                                <div class="flex-grow-1">
                                                    <h6 class="mb-2"><strong>Permissões 100% Customizáveis</strong></h6>
                                                    <p class="mb-2">O role "{{ $selectedAdmin->getRoleName() }}" tem permissões padrão, mas você pode:</p>
                                                    <ul class="mb-2">
                                                        <li><strong>Adicionar</strong> permissões extras marcando abaixo</li>
                                                        <li><strong>Remover</strong> permissões padrão desmarcando</li>
                                                    </ul>
                                                    <small class="text-muted">
                                                        <i class="fas fa-tag text-primary me-1"></i> <strong>Azul</strong> = Padrão do role
                                                        <i class="fas fa-plus-circle text-success ms-3 me-1"></i> <strong>Verde</strong> = Permissão extra adicionada
                                                        <i class="fas fa-minus-circle text-danger ms-3 me-1"></i> <strong>Vermelho</strong> = Permissão padrão removida
                                                    </small>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Grupos Rápidos -->
                                        <div class="card bg-light mb-3">
                                            <div class="card-body">
                                                <h6 class="mb-2">
                                                    <i class="fas fa-bolt text-warning me-2"></i>Grupos Rápidos
                                                    <small class="text-muted">(Aplicar template de permissões)</small>
                                                </h6>
                                                <div class="row g-2">
                                                    @foreach($quickGroups as $groupKey => $group)
                                                        <div class="col-md-4">
                                                            <button
                                                                wire:click="applyQuickGroup('{{ $groupKey }}')"
                                                                class="btn btn-sm btn-outline-{{ $group['color'] }} w-100 text-start"
                                                            >
                                                                <i class="fas fa-{{ $group['icon'] }} me-2"></i>
                                                                <strong>{{ $group['label'] }}</strong>
                                                                <br>
                                                                <small class="text-muted">{{ count($group['permissions']) }} permissões</small>
                                                            </button>
                                                        </div>
                                                    @endforeach
                                                </div>
                                            </div>
                                        </div>
                                    @endif

                                    @foreach($availablePermissions as $groupKey => $group)
                                        <div class="mb-4">
                                            <h6 class="border-bottom pb-2 mb-3">
                                                <i class="fas fa-folder-open text-primary me-2"></i>{{ $group['label'] }}
                                            </h6>

                                            <div class="row">
                                                @foreach($group['permissions'] as $permissionKey => $permissionLabel)
                                                    @php
                                                        $isRoleDefault = in_array($permissionKey, $roleDefaults);
                                                        $isChecked = in_array($permissionKey, $adminPermissions);
                                                        $isExtra = $isChecked && !$isRoleDefault; // Adicionada
                                                        $isRevoked = !$isChecked && $isRoleDefault; // Removida do padrão
                                                    @endphp
                                                    <div class="col-md-6 mb-3">
                                                        <div class="form-check form-switch d-flex align-items-center">
                                                            <input
                                                                class="form-check-input"
                                                                type="checkbox"
                                                                id="perm_{{ $permissionKey }}"
                                                                @if($selectedAdmin->role != 0)
                                                                    wire:click="togglePermission('{{ $permissionKey }}')"
                                                                    style="cursor: pointer; width: 3em; height: 1.5em;"
                                                                @else
                                                                    disabled
                                                                    style="width: 3em; height: 1.5em; cursor: not-allowed; opacity: 0.5;"
                                                                @endif
                                                                {{ $isChecked ? 'checked' : '' }}
                                                            >
                                                            <label
                                                                class="form-check-label ms-2 flex-grow-1 {{ $selectedAdmin->role == 0 ? 'text-muted' : '' }}"
                                                                for="perm_{{ $permissionKey }}"
                                                                style="{{ $selectedAdmin->role != 0 ? 'cursor: pointer;' : 'cursor: not-allowed;' }}"
                                                            >
                                                                {{ $permissionLabel }}
                                                            </label>
                                                            @if($selectedAdmin->role != 0)
                                                                @if($isExtra)
                                                                    <span class="badge bg-success" style="font-size: 0.65rem;" title="Permissão extra adicionada">
                                                                        <i class="fas fa-plus-circle"></i> Extra
                                                                    </span>
                                                                @elseif($isRevoked)
                                                                    <span class="badge bg-danger" style="font-size: 0.65rem;" title="Permissão padrão removida">
                                                                        <i class="fas fa-minus-circle"></i> Removida
                                                                    </span>
                                                                @elseif($isRoleDefault && $isChecked)
                                                                    <span class="badge bg-primary" style="font-size: 0.65rem;" title="Permissão padrão do role">
                                                                        <i class="fas fa-tag"></i> Padrão
                                                                    </span>
                                                                @endif
                                                            @else
                                                                <i class="fas fa-check-circle text-success ms-1"></i>
                                                            @endif
                                                        </div>
                                                    </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    @endforeach

                                    @if($selectedAdmin->role != 0)
                                        <!-- Summary -->
                                        <div class="alert alert-info mt-4">
                                            <i class="fas fa-info-circle me-2"></i>
                                            <strong>Total de permissões selecionadas:</strong> {{ count($adminPermissions) }}
                                        </div>

                                        <!-- Save Button -->
                                        <div class="d-flex justify-content-end gap-2 border-top pt-4">
                                            <button wire:click="loadAdminPermissions" class="btn btn-outline-secondary">
                                                <i class="fas fa-undo me-1"></i> Resetar
                                            </button>
                                            <button wire:click="save" class="btn btn-primary btn-lg">
                                                <i class="fas fa-save me-2"></i> Salvar Permissões
                                            </button>
                                        </div>
                                    @else
                                        <!-- PCA - Sem botões de salvar -->
                                        <div class="alert alert-success mt-4 mb-0">
                                            <i class="fas fa-crown me-2"></i>
                                            <strong>PCA tem todas as {{ count($adminPermissions) }} permissões ativadas automaticamente.</strong>
                                            Não é necessário salvar alterações.
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                @else
                    <!-- Empty State -->
                    <div class="card shadow-sm">
                        <div class="card-body text-center py-5">
                            <i class="fas fa-hand-pointer fa-4x text-muted mb-3"></i>
                            <h5 class="text-muted">Selecione um usuário</h5>
                            <p class="text-muted">Escolha um usuário da lista à esquerda para gerenciar suas permissões</p>
                        </div>
                    </div>
                @endif
            </div>
        </div>

        <!-- Info Cards -->
        <div class="row mt-4">
            <!-- Roles Info -->
            <div class="col-md-6 mb-4">
                <div class="card shadow-sm h-100">
                    <div class="card-header bg-primary text-white">
                        <h6 class="mb-0"><i class="fas fa-user-shield me-2"></i>Perfis/Roles do Sistema</h6>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <div class="d-flex align-items-center mb-2">
                                <span class="badge bg-danger me-2" style="width: 40px;">PCA</span>
                                <strong>PCA (Super Admin)</strong>
                            </div>
                            <p class="mb-0 ms-5 text-muted small">
                                <i class="fas fa-crown me-1 text-danger"></i> Acesso total e irrestrito ao sistema
                                <br><i class="fas fa-check-circle me-1 text-success"></i> Pode aprovar/rejeitar referências de pagamento
                                <br><i class="fas fa-shield-alt me-1 text-info"></i> Todas as permissões ativadas
                            </p>
                        </div>
                        <hr>
                        <div class="mb-3">
                            <div class="d-flex align-items-center mb-2">
                                <span class="badge bg-warning me-2" style="width: 45px;">REG</span>
                                <strong>Reg Academico</strong>
                            </div>
                            <p class="mb-0 ms-5 text-muted small">
                                Gestão acadêmica completa, matrículas, documentos, pagamentos
                                <br><i class="fas fa-lock me-1 text-muted"></i> Não pode aprovar referências (apenas visualizar)
                            </p>
                        </div>
                        <hr>
                        <div class="mb-3">
                            <div class="d-flex align-items-center mb-2">
                                <span class="badge bg-info me-2" style="width: 45px;">PROF</span>
                                <strong>Professor</strong>
                            </div>
                            <p class="mb-0 ms-5 text-muted small">
                                Gestão de notas, avaliações e turmas
                                <br><i class="fas fa-lock me-1 text-muted"></i> Acesso limitado ao sistema
                            </p>
                        </div>
                        <hr>
                        <div class="mb-3">
                            <div class="d-flex align-items-center mb-2">
                                <span class="badge bg-success me-2" style="width: 45px;">DIR</span>
                                <strong>Diretor</strong>
                            </div>
                            <p class="mb-0 ms-5 text-muted small">
                                Supervisão geral, relatórios, visão ampla do sistema
                                <br><i class="fas fa-lock me-1 text-muted"></i> Não pode aprovar referências
                            </p>
                        </div>
                        <hr>
                        <div class="mb-3">
                            <div class="d-flex align-items-center mb-2">
                                <span class="badge bg-primary me-2" style="width: 45px;">ADM</span>
                                <strong>Admin</strong>
                            </div>
                            <p class="mb-0 ms-5 text-muted small">
                                Gestão ampla do sistema, quase todas as permissões
                                <br><i class="fas fa-lock me-1 text-muted"></i> Não pode aprovar referências de pagamento
                            </p>
                        </div>
                        <hr>
                        <div class="mb-3">
                            <div class="d-flex align-items-center mb-2">
                                <span class="badge bg-dark me-2" style="width: 45px;">CONT</span>
                                <strong>Contabilidade</strong>
                            </div>
                            <p class="mb-0 ms-5 text-muted small">
                                Foco em financeiro: pagamentos, POS, relatórios
                                <br><i class="fas fa-lock me-1 text-muted"></i> Não pode aprovar referências
                            </p>
                        </div>
                        <hr>
                        <div class="mb-0">
                            <div class="d-flex align-items-center mb-2">
                                <span class="badge bg-secondary me-2" style="width: 45px;">SEC</span>
                                <strong>Secretaria</strong>
                            </div>
                            <p class="mb-0 ms-5 text-muted small">
                                Inscrições, matrículas, documentação de estudantes
                                <br><i class="fas fa-lock me-1 text-muted"></i> Não pode aprovar referências
                            </p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Permissions Info -->
            <div class="col-md-6 mb-4">
                <div class="card shadow-sm h-100">
                    <div class="card-header bg-info text-white">
                        <h6 class="mb-0"><i class="fas fa-key me-2"></i>Categorias de Permissões</h6>
                    </div>
                    <div class="card-body">
                        <ul class="mb-0">
                            <li class="mb-2">
                                <i class="fas fa-cash-register text-primary me-2"></i>
                                <strong>POS:</strong> Sistema de ponto de venda e produtos
                            </li>
                            <li class="mb-2">
                                <i class="fas fa-user-graduate text-success me-2"></i>
                                <strong>Estudantes/Professores:</strong> Gestão de registros acadêmicos
                            </li>
                            <li class="mb-2">
                                <i class="fas fa-file-alt text-warning me-2"></i>
                                <strong>Notas e Exames:</strong> Avaliações e cadernetas
                            </li>
                            <li class="mb-2">
                                <i class="fas fa-money-bill text-success me-2"></i>
                                <strong>Pagamentos:</strong> Módulo financeiro e referências
                            </li>
                            <li class="mb-2">
                                <i class="fas fa-book text-info me-2"></i>
                                <strong>Biblioteca:</strong> Gestão de livros digitais
                            </li>
                            <li class="mb-2">
                                <i class="fas fa-cogs text-secondary me-2"></i>
                                <strong>Sistema:</strong> Configurações e gestão de staff
                            </li>
                        </ul>

                        <div class="alert alert-warning mt-3 mb-0">
                            <small>
                                <i class="fas fa-exclamation-triangle me-1"></i>
                                <strong>Importante:</strong> Apenas usuários com role PCA podem aprovar ou rejeitar referências de pagamento no sistema.
                            </small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
