<div class="page-content">
    <div class="main-wrapper">
        <!-- Header -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h4 class="mb-1"><i class="fas fa-cog text-primary me-2"></i>Configurações POS</h4>
                        <p class="text-muted mb-0">Gerencie as configurações do sistema de ponto de venda</p>
                    </div>
                    <div class="d-flex gap-2">
                        <a href="{{ route('admin.pos.interface') }}" class="btn btn-outline-primary">
                            <i class="fas fa-cash-register me-1"></i> Ir para POS
                        </a>
                        <a href="{{ route('admin.pos.dashboard') }}" class="btn btn-outline-info">
                            <i class="fas fa-chart-line me-1"></i> Dashboard
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-8 mx-auto">
                <div class="card shadow-sm">
                    <div class="card-header bg-primary text-white">
                        <h5 class="mb-0">
                            <i class="fas fa-sliders-h me-2"></i>Configurações Gerais
                        </h5>
                    </div>

                    <div class="card-body">
                        <form wire:submit.prevent="save">
                            <!-- Store Information -->
                            <div class="mb-4">
                                <h6 class="border-bottom pb-2 mb-3">
                                    <i class="fas fa-store text-primary me-2"></i>Informações da Loja
                                </h6>

                                <div class="row">
                                    <div class="col-md-8 mb-3">
                                        <label class="form-label">Nome da Loja <span class="text-danger">*</span></label>
                                        <input
                                            type="text"
                                            wire:model="store_name"
                                            class="form-control @error('store_name') is-invalid @enderror"
                                            placeholder="Ex: COPMOZ Store"
                                        />
                                        @error('store_name')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                        <small class="text-muted">Nome que aparecerá nos recibos</small>
                                    </div>

                                    <div class="col-md-4 mb-3">
                                        <label class="form-label">Moeda <span class="text-danger">*</span></label>
                                        <input
                                            type="text"
                                            wire:model="currency"
                                            class="form-control @error('currency') is-invalid @enderror"
                                            placeholder="MT"
                                        />
                                        @error('currency')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="col-md-4 mb-3">
                                        <label class="form-label">Prefixo do Recibo <span class="text-danger">*</span></label>
                                        <input
                                            type="text"
                                            wire:model="sale_number_prefix"
                                            class="form-control @error('sale_number_prefix') is-invalid @enderror"
                                            placeholder="POS"
                                            maxlength="10"
                                            style="text-transform: uppercase;"
                                        />
                                        @error('sale_number_prefix')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                        <small class="text-muted">Ex: POS, FAT, REC, VD</small>
                                    </div>

                                    <div class="col-12 mb-3">
                                        <label class="form-label">Rodapé do Recibo</label>
                                        <textarea
                                            wire:model="receipt_footer"
                                            class="form-control @error('receipt_footer') is-invalid @enderror"
                                            rows="3"
                                            placeholder="Mensagem que aparecerá no final do recibo (opcional)"
                                        ></textarea>
                                        @error('receipt_footer')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                        <small class="text-muted">Ex: Obrigado pela sua preferência! Volte sempre.</small>
                                    </div>
                                </div>
                            </div>

                            <!-- Tax Settings -->
                            <div class="mb-4">
                                <h6 class="border-bottom pb-2 mb-3">
                                    <i class="fa fa-percentage text-success me-2"></i>Configurações de IVA
                                </h6>

                                <div class="row">
                                    <div class="col-md-12 mb-3">
                                        <div class="form-check form-switch">
                                            <input
                                                class="form-check-input"
                                                type="checkbox"
                                                wire:model="tax_enabled"
                                                id="taxEnabled"
                                                style="cursor: pointer; width: 3em; height: 1.5em;"
                                            />
                                            <label class="form-check-label ms-2" for="taxEnabled" style="cursor: pointer;">
                                                <strong>Ativar IVA nas Vendas POS</strong>
                                            </label>
                                        </div>
                                        <small class="text-muted d-block mt-2">
                                            Quando ativado, o IVA será calculado automaticamente nas vendas do POS
                                        </small>
                                    </div>
                                </div>

                                @if($tax_enabled)
                                    <div class="alert alert-success mb-0">
                                        <i class="fa fa-info-circle me-2"></i>
                                        <strong>IVA Ativado:</strong> Será aplicado {{ number_format((float) $tax_rate, 2) }}% de IVA em todas as vendas do POS
                                    </div>
                                @else
                                    <div class="alert alert-warning mb-0">
                                        <i class="fa fa-exclamation-triangle me-2"></i>
                                        <strong>IVA Desativado:</strong> Nenhuma taxa será aplicada nas vendas do POS
                                    </div>
                                @endif

                                <div class="alert alert-info mt-3 mb-0">
                                    <i class="fa fa-cog me-2"></i>
                                    <strong>Taxa de IVA:</strong> A taxa de IVA ({{ number_format((float) $tax_rate, 2) }}%) é configurada globalmente em
                                    <a href="{{ route('admin.settings.iva') }}" class="alert-link fw-bold">Configurações → Taxa de IVA</a>
                                </div>
                            </div>

                            <!-- Inventory Settings -->
                            <div class="mb-4">
                                <h6 class="border-bottom pb-2 mb-3">
                                    <i class="fas fa-boxes text-warning me-2"></i>Configurações de Inventário
                                </h6>

                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Alerta de Stock Baixo <span class="text-danger">*</span></label>
                                        <input
                                            type="number"
                                            wire:model="low_stock_alert"
                                            class="form-control @error('low_stock_alert') is-invalid @enderror"
                                            min="1"
                                            max="1000"
                                        />
                                        @error('low_stock_alert')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                        <small class="text-muted">Produtos com quantidade igual ou menor que este valor serão marcados como "Stock Baixo"</small>
                                    </div>
                                </div>
                            </div>

                            <!-- Printer Settings -->
                            <div class="mb-4">
                                <h6 class="border-bottom pb-2 mb-3">
                                    <i class="fas fa-print text-info me-2"></i>Configurações de Impressão
                                </h6>

                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Formato do Recibo <span class="text-danger">*</span></label>
                                        <select
                                            wire:model="receipt_format"
                                            class="form-select @error('receipt_format') is-invalid @enderror"
                                        >
                                            <option value="a4">A4 / Carta (Padrão)</option>
                                            <option value="80mm">80mm (Impressora Térmica)</option>
                                        </select>
                                        @error('receipt_format')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                        <small class="text-muted">Escolha o formato do recibo de acordo com sua impressora</small>
                                    </div>

                                    <div class="col-md-6 mb-3">
                                        <div class="form-check form-switch">
                                            <input
                                                class="form-check-input"
                                                type="checkbox"
                                                wire:model="receipt_printer"
                                                id="receiptPrinter"
                                                style="cursor: pointer; width: 3em; height: 1.5em;"
                                            />
                                            <label class="form-check-label ms-2" for="receiptPrinter" style="cursor: pointer;">
                                                <strong>Impressão Automática</strong>
                                            </label>
                                        </div>
                                        <small class="text-muted d-block mt-2">
                                            Ativar impressão automática de recibos após cada venda
                                        </small>
                                    </div>
                                </div>
                            </div>

                            <!-- Action Buttons -->
                            <div class="d-flex justify-content-between align-items-center border-top pt-4">
                                <button
                                    type="button"
                                    wire:click="resetToDefaults"
                                    class="btn btn-outline-secondary"
                                >
                                    <i class="fas fa-undo me-1"></i> Restaurar Padrões
                                </button>

                                <button
                                    type="submit"
                                    class="btn btn-primary btn-lg"
                                >
                                    <i class="fas fa-save me-2"></i> Salvar Configurações
                                </button>
                            </div>
                        </form>
                    </div>
                </div>

                <!-- Info Card -->
                <div class="card shadow-sm mt-4">
                    <div class="card-body">
                        <h6 class="mb-3"><i class="fas fa-info-circle text-info me-2"></i>Informações</h6>
                        <ul class="mb-0">
                            <li class="mb-2">
                                <strong>IVA:</strong> Quando ativado, o imposto é calculado automaticamente como: (Subtotal - Desconto) × Taxa%
                            </li>
                            <li class="mb-2">
                                <strong>Stock Baixo:</strong> Produtos com alerta de stock baixo aparecem destacados na interface POS
                            </li>
                            <li class="mb-2">
                                <strong>Recibos:</strong> Todas as configurações são aplicadas imediatamente nos recibos gerados
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
