<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>Recibo {{ $sale->sale_number }}</title>
    <style>
        @page {
            margin: {{ $format === '80mm' ? '10mm 8mm' : '15mm' }};
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'DejaVu Sans', sans-serif;
            font-size: {{ $format === '80mm' ? '9px' : '11px' }};
            color: #2c3e50;
            line-height: 1.5;
        }

        @if($format === '80mm')
        /* ========== 80MM THERMAL RECEIPT ========== */
        .receipt-container {
            width: 100%;
        }

        .receipt-header {
            text-align: center;
            margin-bottom: 12px;
            padding-bottom: 8px;
            border-bottom: 2px dashed #333;
        }

        .company-name {
            font-size: 13px;
            font-weight: 700;
            margin-bottom: 3px;
        }

        .company-tagline {
            font-size: 8px;
            color: #666;
            margin-bottom: 5px;
        }

        .company-details {
            font-size: 7px;
            color: #666;
            line-height: 1.3;
        }

        .receipt-type {
            font-size: 8px;
            font-weight: 700;
            text-align: center;
            margin: 8px 0 4px 0;
        }

        .receipt-number {
            font-size: 13px;
            font-weight: 700;
            text-align: center;
            font-family: 'Courier New', monospace;
            margin-bottom: 6px;
        }

        .receipt-date {
            font-size: 8px;
            text-align: center;
            margin-bottom: 8px;
        }

        .info-box {
            margin: 8px 0;
            padding: 6px;
            background: #f5f5f5;
            border-left: 2px solid #333;
        }

        .info-title {
            font-size: 7px;
            font-weight: 700;
            margin-bottom: 4px;
        }

        .info-line {
            font-size: 8px;
            margin-bottom: 3px;
        }

        .items-table {
            width: 100%;
            margin: 8px 0;
            border-collapse: collapse;
        }

        .items-table th {
            border-bottom: 2px solid #333;
            padding: 5px 2px;
            font-size: 7px;
            font-weight: 700;
            text-align: left;
        }

        .items-table th.right {
            text-align: right;
        }

        .items-table td {
            border-bottom: 1px dashed #ccc;
            padding: 5px 2px;
            font-size: 8px;
        }

        .items-table td.right {
            text-align: right;
        }

        .product-name {
            font-weight: 700;
        }

        .product-info {
            font-size: 7px;
            color: #666;
        }

        .totals {
            margin: 8px 0;
            border-top: 2px dashed #333;
            padding-top: 6px;
        }

        .total-line {
            margin: 4px 0;
            font-size: 9px;
        }

        .total-line.grand {
            background: #333;
            color: white;
            padding: 6px 4px;
            margin-top: 5px;
            font-size: 10px;
            font-weight: 700;
        }

        .total-label {
            display: inline-block;
            width: 55%;
        }

        .total-value {
            display: inline-block;
            width: 43%;
            text-align: right;
            font-family: 'Courier New', monospace;
        }

        .notes {
            margin: 8px 0;
            padding: 6px;
            background: #f5f5f5;
            border-left: 2px solid #333;
            font-size: 8px;
        }

        .status {
            text-align: center;
            margin: 8px 0;
        }

        .status-badge {
            display: inline-block;
            padding: 5px 10px;
            background: #333;
            color: white;
            font-size: 8px;
            font-weight: 700;
        }

        .footer {
            margin-top: 12px;
            padding-top: 8px;
            border-top: 2px dashed #333;
            text-align: center;
            font-size: 7px;
            color: #666;
        }

        .footer-msg {
            font-size: 8px;
            font-weight: 700;
            color: #333;
            margin-bottom: 4px;
        }

        @else
        /* ========== A4 PROFESSIONAL RECEIPT ========== */
        .receipt-container {
            max-width: 750px;
            margin: 0 auto;
            padding: 0;
        }

        /* Header */
        .header {
            border-bottom: 3px solid #2c3e50;
            padding-bottom: 15px;
            margin-bottom: 20px;
        }

        .header-table {
            width: 100%;
            border-collapse: collapse;
        }

        .header-table td {
            vertical-align: top;
        }

        .header-left {
            width: 50%;
        }

        .header-right {
            width: 50%;
            text-align: right;
        }

        .company-name {
            font-size: 22px;
            font-weight: 700;
            color: #2c3e50;
            margin-bottom: 4px;
        }

        .company-tagline {
            font-size: 10px;
            color: #7f8c8d;
            font-style: italic;
            margin-bottom: 6px;
        }

        .company-details {
            font-size: 10px;
            color: #6c757d;
            line-height: 1.6;
        }

        .receipt-type {
            font-size: 9px;
            color: #7f8c8d;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 1.2px;
            margin-bottom: 6px;
        }

        .receipt-number {
            font-size: 18px;
            font-weight: 700;
            color: #2c3e50;
            font-family: 'Courier New', monospace;
            letter-spacing: 1px;
            margin-bottom: 8px;
        }

        .receipt-date {
            font-size: 10px;
            color: #6c757d;
            line-height: 1.5;
        }

        /* Info Grid */
        .info-grid {
            margin: 15px 0;
        }

        .info-table {
            width: 100%;
            border-collapse: collapse;
        }

        .info-cell {
            width: 48%;
            vertical-align: top;
            background: #f8f9fa;
            padding: 10px;
            border-left: 3px solid #3498db;
        }

        .info-cell.client {
            border-left-color: #27ae60;
        }

        .info-spacer {
            width: 4%;
        }

        .info-title {
            font-size: 9px;
            font-weight: 700;
            color: #7f8c8d;
            text-transform: uppercase;
            letter-spacing: 0.8px;
            margin-bottom: 10px;
        }

        .info-line {
            margin-bottom: 8px;
            font-size: 10px;
        }

        .info-label {
            color: #6c757d;
            font-weight: 600;
            display: block;
            margin-bottom: 2px;
        }

        .info-value {
            color: #2c3e50;
            font-weight: 700;
        }

        .payment-badge {
            display: inline-block;
            padding: 3px 8px;
            background: #2c3e50;
            color: white;
            font-size: 8px;
            font-weight: 700;
        }

        /* Items Table */
        .items-table {
            width: 100%;
            margin: 15px 0;
            border-collapse: collapse;
            border: 1px solid #dee2e6;
        }

        .items-table thead {
            background: #2c3e50;
        }

        .items-table th {
            padding: 10px 8px;
            text-align: left;
            font-size: 9px;
            font-weight: 700;
            color: white;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .items-table th.right {
            text-align: right;
        }

        .items-table td {
            padding: 10px 8px;
            border-bottom: 1px solid #dee2e6;
            font-size: 10px;
            vertical-align: top;
        }

        .items-table tr:last-child td {
            border-bottom: 2px solid #2c3e50;
        }

        .items-table td.right {
            text-align: right;
        }

        .items-table td.center {
            text-align: center;
        }

        .item-num {
            color: #95a5a6;
            font-weight: 700;
        }

        .product-name {
            font-weight: 700;
            color: #2c3e50;
            margin-bottom: 3px;
        }

        .product-info {
            font-size: 9px;
            color: #6c757d;
        }

        /* Totals */
        .totals-section {
            margin-top: 15px;
        }

        .totals-outer {
            width: 100%;
            border-collapse: collapse;
        }

        .totals-outer td {
            vertical-align: top;
        }

        .totals-left {
            width: 52%;
        }

        .totals-right {
            width: 48%;
        }

        .totals-box {
            width: 100%;
            background: #f8f9fa;
            border: 1px solid #dee2e6;
            border-collapse: collapse;
        }

        .totals-box tr {
            border-bottom: 1px solid #dee2e6;
        }

        .totals-box tr.grand {
            background: #2c3e50;
            border-bottom: none;
        }

        .totals-box td {
            padding: 8px 12px;
            font-size: 11px;
        }

        .totals-box td.label {
            color: #6c757d;
            font-weight: 600;
            width: 50%;
        }

        .totals-box td.value {
            text-align: right;
            font-weight: 700;
            color: #2c3e50;
            font-family: 'Courier New', monospace;
            width: 50%;
        }

        .totals-box tr.discount td.value {
            color: #e74c3c;
        }

        .totals-box tr.grand td {
            padding: 12px;
            font-size: 14px;
            color: white;
            font-weight: 700;
        }

        /* Notes */
        .notes {
            margin: 15px 0;
            padding: 10px;
            background: #fff3cd;
            border-left: 3px solid #ffc107;
        }

        .notes-title {
            font-size: 10px;
            color: #856404;
            font-weight: 700;
            text-transform: uppercase;
            margin-bottom: 6px;
            letter-spacing: 0.5px;
        }

        .notes-text {
            font-size: 11px;
            color: #856404;
            line-height: 1.6;
        }

        /* Status */
        .status {
            text-align: center;
            margin: 15px 0;
        }

        .status-badge {
            display: inline-block;
            padding: 10px 25px;
            background: #27ae60;
            color: white;
            font-size: 11px;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 1px;
        }

        /* Footer */
        .footer {
            margin-top: 25px;
            padding-top: 15px;
            border-top: 2px solid #dee2e6;
            text-align: center;
        }

        .footer-msg {
            font-size: 11px;
            color: #2c3e50;
            font-weight: 700;
            margin-bottom: 8px;
        }

        .footer-info {
            font-size: 10px;
            color: #6c757d;
            margin: 4px 0;
        }

        .footer-time {
            font-size: 9px;
            color: #95a5a6;
            margin-top: 8px;
            font-style: italic;
        }

        @endif
    </style>
</head>
<body>
    <div class="receipt-container">
        @if($format === '80mm')
            {{-- 80MM THERMAL RECEIPT --}}
            <div class="receipt-header">
                <div class="company-name">{{ $store_name }}</div>
                <div class="company-tagline">Sistema de Gestão Escolar</div>
                <div class="company-details">
                    Tel: +258 84 123 4567<br>
                    info@copmoz.co.mz<br>
                    Maputo, Moçambique
                </div>
            </div>

            <div class="receipt-type">RECIBO DE VENDA</div>
            <div class="receipt-number">{{ $sale->sale_number }}</div>
            <div class="receipt-date">
                Data: {{ $sale->sale_date->format('d/m/Y') }}<br>
                Hora: {{ $sale->sale_date->format('H:i:s') }}
            </div>

            <div class="info-box">
                <div class="info-title">CAIXA</div>
                <div class="info-line">Operador: {{ $sale->cashier->name ?? 'Sistema' }}</div>
                <div class="info-line">
                    Pagamento:
                    @if($sale->payment_method == 'cash')DINHEIRO
                    @elseif($sale->payment_method == 'mpesa')M-PESA
                    @elseif($sale->payment_method == 'emola')E-MOLA
                    @elseif($sale->payment_method == 'bank_transfer')TRANSFERÊNCIA
                    @else{{ strtoupper($sale->payment_method) }}
                    @endif
                </div>
            </div>

            @if($sale->user)
            <div class="info-box">
                <div class="info-title">CLIENTE</div>
                <div class="info-line">{{ $sale->user->name }}</div>
                @if($sale->user->student_id)
                <div class="info-line">ID: {{ $sale->user->student_id }}</div>
                @endif
            </div>
            @endif

            <table class="items-table">
                <thead>
                    <tr>
                        <th>PRODUTO</th>
                        <th class="right">QTD</th>
                        <th class="right">TOTAL</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($sale->items as $item)
                    <tr>
                        <td>
                            <div class="product-name">{{ $item->product_name }}</div>
                            <div class="product-info">{{ number_format($item->unit_price, 2) }} MT x {{ $item->quantity }}</div>
                        </td>
                        <td class="right">{{ $item->quantity }}</td>
                        <td class="right">{{ number_format($item->total, 2) }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>

            <div class="totals">
                <div class="total-line">
                    <span class="total-label">Subtotal</span>
                    <span class="total-value">{{ number_format($sale->subtotal, 2) }} MT</span>
                </div>
                @if($sale->discount > 0)
                <div class="total-line">
                    <span class="total-label">Desconto</span>
                    <span class="total-value">-{{ number_format($sale->discount, 2) }} MT</span>
                </div>
                @endif
                @if($sale->tax > 0)
                <div class="total-line">
                    <span class="total-label">IVA (17%)</span>
                    <span class="total-value">{{ number_format($sale->tax, 2) }} MT</span>
                </div>
                @endif
                <div class="total-line grand">
                    <span class="total-label">TOTAL</span>
                    <span class="total-value">{{ number_format($sale->total, 2) }} MT</span>
                </div>
            </div>

        @else
            {{-- A4 PROFESSIONAL RECEIPT --}}
            <div class="header">
                <table class="header-table">
                    <tr>
                        <td class="header-left">
                            <div class="company-name">{{ $store_name }}</div>
                            <div class="company-tagline">Sistema de Gestão Escolar</div>
                            <div class="company-details">
                                +258 84 123 4567<br>
                                info@copmoz.co.mz<br>
                                Maputo, Moçambique
                            </div>
                        </td>
                        <td class="header-right">
                            <div class="receipt-type">RECIBO DE VENDA</div>
                            <div class="receipt-number">{{ $sale->sale_number }}</div>
                            <div class="receipt-date">
                                Data: {{ $sale->sale_date->format('d/m/Y') }}<br>
                                Hora: {{ $sale->sale_date->format('H:i:s') }}
                            </div>
                        </td>
                    </tr>
                </table>
            </div>

            <div class="info-grid">
                <table class="info-table">
                    <tr>
                        <td class="info-cell">
                            <div class="info-title">INFORMAÇÕES DO CAIXA</div>
                            <div class="info-line">
                                <span class="info-label">Operador</span>
                                <span class="info-value">{{ $sale->cashier->name ?? 'Sistema' }}</span>
                            </div>
                            <div class="info-line">
                                <span class="info-label">Método de Pagamento</span><br>
                                <span class="info-value">
                                    @if($sale->payment_method == 'cash')
                                        <span class="payment-badge" style="background:#27ae60;">DINHEIRO</span>
                                    @elseif($sale->payment_method == 'mpesa')
                                        <span class="payment-badge" style="background:#e74c3c;">M-PESA</span>
                                    @elseif($sale->payment_method == 'emola')
                                        <span class="payment-badge" style="background:#9b59b6;">E-MOLA</span>
                                    @elseif($sale->payment_method == 'bank_transfer')
                                        <span class="payment-badge" style="background:#3498db;">TRANSFERÊNCIA</span>
                                    @else
                                        <span class="payment-badge">{{ strtoupper($sale->payment_method) }}</span>
                                    @endif
                                </span>
                            </div>
                        </td>
                        <td class="info-spacer"></td>
                        @if($sale->user)
                        <td class="info-cell client">
                            <div class="info-title">INFORMAÇÕES DO CLIENTE</div>
                            <div class="info-line">
                                <span class="info-label">Nome</span>
                                <span class="info-value">{{ $sale->user->name }}</span>
                            </div>
                            @if($sale->user->student_id)
                            <div class="info-line">
                                <span class="info-label">ID Estudante</span>
                                <span class="info-value">{{ $sale->user->student_id }}</span>
                            </div>
                            @endif
                        </td>
                        @endif
                    </tr>
                </table>
            </div>

            <table class="items-table">
                <thead>
                    <tr>
                        <th style="width:5%;">#</th>
                        <th style="width:45%;">PRODUTO</th>
                        <th style="width:12%;" class="center">QTD</th>
                        <th style="width:19%;" class="right">PREÇO UNIT.</th>
                        <th style="width:19%;" class="right">TOTAL</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($sale->items as $index => $item)
                    <tr>
                        <td class="item-num">{{ $index + 1 }}</td>
                        <td>
                            <div class="product-name">{{ $item->product_name }}</div>
                            <div class="product-info">
                                @if($item->variant)Var: {{ $item->variant }} • @endif
                                SKU: {{ $item->product_sku }}
                            </div>
                        </td>
                        <td class="center">{{ $item->quantity }}</td>
                        <td class="right">{{ number_format($item->unit_price, 2) }}</td>
                        <td class="right"><strong>{{ number_format($item->total, 2) }}</strong></td>
                    </tr>
                    @endforeach
                </tbody>
            </table>

            <div class="totals-section">
                <table class="totals-outer">
                    <tr>
                        <td class="totals-left"></td>
                        <td class="totals-right">
                            <table class="totals-box">
                                <tr>
                                    <td class="label">Subtotal</td>
                                    <td class="value">{{ number_format($sale->subtotal, 2) }} MT</td>
                                </tr>
                                @if($sale->discount > 0)
                                <tr class="discount">
                                    <td class="label">Desconto</td>
                                    <td class="value">-{{ number_format($sale->discount, 2) }} MT</td>
                                </tr>
                                @endif
                                @if($sale->tax > 0)
                                <tr>
                                    <td class="label">IVA (17%)</td>
                                    <td class="value">{{ number_format($sale->tax, 2) }} MT</td>
                                </tr>
                                @endif
                                <tr class="grand">
                                    <td class="label">TOTAL A PAGAR</td>
                                    <td class="value">{{ number_format($sale->total, 2) }} MT</td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                </table>
            </div>
        @endif

        {{-- Common sections --}}
        @if($sale->notes)
        <div class="notes">
            <div class="notes-title">OBSERVAÇÕES</div>
            <div class="notes-text">{{ $sale->notes }}</div>
        </div>
        @endif

        @if($sale->status == 'completed')
        <div class="status">
            <span class="status-badge">PAGAMENTO CONFIRMADO</span>
        </div>
        @endif

        <div class="footer">
            <div class="footer-msg">{{ $receipt_footer }}</div>
            <div class="footer-info">Este documento foi gerado eletronicamente e tem validade sem assinatura.</div>
            <div class="footer-info">Sistema de Gestão Escolar COPMOZ &copy; {{ date('Y') }}</div>
            <div class="footer-time">Impresso em: {{ now()->format('d/m/Y H:i:s') }}</div>
        </div>
    </div>
</body>
</html>
