<div>
    <div class="page-content">
        <div class="main-wrapper">

            <!-- Header -->
            <div class="d-flex align-items-center justify-content-between mb-4">
                <div>
                    <h2 class="h4 mb-0 fw-bold"><i class="fas fa-rotate me-2 text-primary"></i>Gestão de Renovações de Matrícula</h2>
                    <p class="text-muted small mb-0">Controle o período de reserva de vagas e acompanhe as renovações</p>
                </div>
            </div>

            <!-- Settings Card -->
            <div class="row g-3 mb-4">
                <!-- Toggle Period -->
                <div class="col-md-6">
                    <div class="card border-0 shadow-sm h-100">
                        <div class="card-body d-flex align-items-center gap-3">
                            <div class="rounded-circle d-flex align-items-center justify-content-center flex-shrink-0"
                                 style="width:56px;height:56px;background:{{ $periodOpen ? '#d1fae5' : '#fee2e2' }}">
                                <i class="fas fa-{{ $periodOpen ? 'lock-open' : 'lock' }} fa-lg"
                                   style="color:{{ $periodOpen ? '#059669' : '#dc2626' }}"></i>
                            </div>
                            <div class="flex-grow-1">
                                <h6 class="mb-1 fw-semibold">Período de Renovação</h6>
                                <span class="badge {{ $periodOpen ? 'bg-success' : 'bg-danger' }}">
                                    {{ $periodOpen ? 'Aberto' : 'Fechado' }}
                                </span>
                            </div>
                            <button wire:click="togglePeriod"
                                    wire:loading.attr="disabled"
                                    class="btn btn-sm {{ $periodOpen ? 'btn-outline-danger' : 'btn-outline-success' }}">
                                <span wire:loading.remove wire:target="togglePeriod">
                                    {{ $periodOpen ? 'Fechar Período' : 'Abrir Período' }}
                                </span>
                                <span wire:loading wire:target="togglePeriod">
                                    <span class="spinner-border spinner-border-sm me-1"></span>A processar...
                                </span>
                            </button>
                        </div>
                    </div>
                </div>

                <!-- Academic Year -->
                <div class="col-md-6">
                    <div class="card border-0 shadow-sm h-100">
                        <div class="card-body">
                            <h6 class="fw-semibold mb-2"><i class="fas fa-calendar-alt me-1 text-primary"></i>Ano Académico Alvo</h6>
                            <div class="input-group">
                                <input type="text" wire:model="academicYear"
                                       class="form-control @error('academicYear') is-invalid @enderror"
                                       placeholder="Ex: 2026">
                                <button wire:click="saveAcademicYear"
                                        wire:loading.attr="disabled"
                                        class="btn btn-primary">
                                    <span wire:loading.remove wire:target="saveAcademicYear">Guardar</span>
                                    <span wire:loading wire:target="saveAcademicYear"><span class="spinner-border spinner-border-sm"></span></span>
                                </button>
                            </div>
                            @error('academicYear') <span class="text-danger small">{{ $message }}</span> @enderror
                        </div>
                    </div>
                </div>
            </div>

            <!-- Auto-Schedule Card -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-light py-2 d-flex align-items-center justify-content-between">
                    <h6 class="mb-0 fw-semibold">
                        <i class="fas fa-clock me-1 text-primary"></i>Abertura / Fecho Automático
                    </h6>
                    <span class="badge bg-info text-dark small">Executado diariamente às 00:01</span>
                </div>
                <div class="card-body">
                    <p class="text-muted small mb-3">
                        Configure as datas em que o período de renovação abre e fecha automaticamente.
                        Use o formato <strong>DD/MM</strong> (ex: <code>01/03</code> para 1 de Março).
                        Deixe em branco para gestão apenas manual.
                    </p>
                    <div class="row g-3 align-items-end">
                        <div class="col-md-4">
                            <label class="form-label fw-semibold small">
                                <i class="fas fa-door-open me-1 text-success"></i>Data de Abertura (DD/MM)
                            </label>
                            <input type="text" wire:model="autoOpenDate"
                                   class="form-control @error('autoOpenDate') is-invalid @enderror"
                                   placeholder="Ex: 01/03">
                            @error('autoOpenDate')
                                <span class="text-danger small">{{ $message }}</span>
                            @enderror
                        </div>
                        <div class="col-md-4">
                            <label class="form-label fw-semibold small">
                                <i class="fas fa-door-closed me-1 text-danger"></i>Data de Fecho (DD/MM)
                            </label>
                            <input type="text" wire:model="autoCloseDate"
                                   class="form-control @error('autoCloseDate') is-invalid @enderror"
                                   placeholder="Ex: 31/03">
                            @error('autoCloseDate')
                                <span class="text-danger small">{{ $message }}</span>
                            @enderror
                        </div>
                        <div class="col-md-4 d-flex gap-2">
                            <button wire:click="saveSchedule"
                                    wire:loading.attr="disabled"
                                    class="btn btn-primary flex-grow-1">
                                <span wire:loading.remove wire:target="saveSchedule">
                                    <i class="fas fa-save me-1"></i>Guardar Datas
                                </span>
                                <span wire:loading wire:target="saveSchedule">
                                    <span class="spinner-border spinner-border-sm me-1"></span>A guardar...
                                </span>
                            </button>
                            @if($autoOpenDate || $autoCloseDate)
                            <button wire:click="clearSchedule"
                                    wire:loading.attr="disabled"
                                    class="btn btn-outline-secondary"
                                    title="Remover datas automáticas">
                                <i class="fas fa-times"></i>
                            </button>
                            @endif
                        </div>
                    </div>
                    @if($autoOpenDate || $autoCloseDate)
                    <div class="alert alert-success alert-sm mt-3 mb-0 py-2 small">
                        <i class="fas fa-check-circle me-1"></i>
                        Agendamento activo:
                        @if($autoOpenDate) Abre em <strong>{{ $autoOpenDate }}</strong> @endif
                        @if($autoOpenDate && $autoCloseDate) — @endif
                        @if($autoCloseDate) Fecha em <strong>{{ $autoCloseDate }}</strong> @endif
                    </div>
                    @else
                    <div class="alert alert-light border mt-3 mb-0 py-2 small text-muted">
                        <i class="fas fa-info-circle me-1"></i>Sem agendamento automático. O período é gerido manualmente.
                    </div>
                    @endif
                </div>
            </div>

            <!-- Per-Classroom Summary -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-light py-2">
                    <h6 class="mb-0 fw-semibold"><i class="fas fa-table me-1"></i>Resumo por Turma — Ano {{ $academicYear }}</h6>
                </div>
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead class="table-light">
                            <tr>
                                <th class="text-center">Classe</th>
                                <th>Turma</th>
                                <th class="text-center">Capacidade</th>
                                <th class="text-center">Pendentes</th>
                                <th class="text-center">Confirmadas</th>
                                <th class="text-center">Canceladas</th>
                                <th class="text-center">Vagas Livres</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($classrooms as $classroom)
                            @php
                                $pending   = $classroom->renewals->where('status', 'pendente')->count();
                                $confirmed = $classroom->renewals->where('status', 'confirmada')->count();
                                $cancelled = $classroom->renewals->where('status', 'cancelada')->count();
                                $cap       = $classroom->capacity;
                                $free      = $cap ? max(0, $cap - $confirmed) : '—';
                            @endphp
                            <tr>
                                <td class="text-center fw-semibold">{{ $classroom->class }}ª</td>
                                <td>{{ $classroom->name }}</td>
                                <td class="text-center">
                                    @if($cap)
                                        <span class="badge bg-secondary">{{ $cap }}</span>
                                    @else
                                        <span class="text-muted small">—</span>
                                    @endif
                                </td>
                                <td class="text-center">
                                    @if($pending > 0)
                                        <span class="badge bg-warning text-dark">{{ $pending }}</span>
                                    @else
                                        <span class="text-muted">0</span>
                                    @endif
                                </td>
                                <td class="text-center">
                                    <span class="badge bg-success">{{ $confirmed }}</span>
                                </td>
                                <td class="text-center">
                                    @if($cancelled > 0)
                                        <span class="badge bg-danger">{{ $cancelled }}</span>
                                    @else
                                        <span class="text-muted">0</span>
                                    @endif
                                </td>
                                <td class="text-center">
                                    @if(is_numeric($free))
                                        <span class="badge {{ $free <= 5 ? 'bg-danger' : ($free <= 10 ? 'bg-warning text-dark' : 'bg-success') }}">
                                            {{ $free }}
                                        </span>
                                    @else
                                        <span class="text-muted">—</span>
                                    @endif
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="7" class="text-center text-muted py-3">Nenhuma turma encontrada.</td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Individual Renewals Table -->
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-light py-2 d-flex align-items-center justify-content-between flex-wrap gap-2">
                    <h6 class="mb-0 fw-semibold"><i class="fas fa-list-check me-1"></i>Renovações Individuais</h6>
                    <div class="d-flex gap-2 flex-wrap align-items-center">
                        <!-- Filter by Class -->
                        <select wire:model="filterClass" class="form-select form-select-sm" style="width:auto">
                            <option value="">Todas as classes</option>
                            @foreach($classes as $c)
                                <option value="{{ $c }}">{{ $c }}ª Classe</option>
                            @endforeach
                        </select>
                        <!-- Filter by Turma -->
                        <select wire:model="filterClassroom" class="form-select form-select-sm" style="width:auto">
                            <option value="">Todas as turmas</option>
                            @foreach($filterClassrooms as $cr)
                                <option value="{{ $cr->id }}">
                                    @if(!$filterClass){{ $cr->class }}ª — @endif{{ $cr->name }}
                                </option>
                            @endforeach
                        </select>
                        <!-- Filter by Status -->
                        <select wire:model="filterStatus" class="form-select form-select-sm" style="width:auto">
                            <option value="">Todos os estados</option>
                            <option value="pendente">Pendente</option>
                            <option value="confirmada">Confirmada</option>
                            <option value="cancelada">Cancelada</option>
                        </select>
                        <!-- Notification toggles -->
                        <div class="d-flex align-items-center gap-2 border-start ps-2">
                            <small class="text-muted fw-semibold">Notificar:</small>
                            <div class="form-check form-check-inline mb-0" title="Push Notification (app)">
                                <input class="form-check-input" type="checkbox" wire:model="notifyPush" id="notifyPush">
                                <label class="form-check-label small" for="notifyPush">
                                    <i class="fas fa-mobile-alt text-primary"></i> Push
                                </label>
                            </div>
                            <div class="form-check form-check-inline mb-0" title="SMS (Movitel)">
                                <input class="form-check-input" type="checkbox" wire:model="notifySms" id="notifySms">
                                <label class="form-check-label small" for="notifySms">
                                    <i class="fas fa-comment-sms text-success"></i> SMS
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead class="table-light">
                            <tr>
                                <th class="text-center">De</th>
                                <th class="text-center">Para</th>
                                <th>Turma Actual</th>
                                <th>Aluno</th>
                                <th class="text-center">Estado</th>
                                <th class="text-center">Submetido</th>
                                <th class="text-center">Ações</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($renewals as $renewal)
                            <tr>
                                <td class="text-center"><span class="badge bg-secondary">{{ $renewal->from_class }}ª</span></td>
                                <td class="text-center"><span class="badge bg-primary">{{ $renewal->to_class }}ª</span></td>
                                <td>{{ $renewal->fromClassroom->name ?? '—' }}</td>
                                <td>
                                    <div class="fw-semibold">{{ $renewal->student->name ?? '—' }}</div>
                                    <div class="text-muted small">{{ $renewal->student->phone_number ?? '' }}</div>
                                </td>
                                <td class="text-center">
                                    @if($renewal->status === 'pendente')
                                        <span class="badge bg-warning text-dark">Pendente</span>
                                    @elseif($renewal->status === 'confirmada')
                                        <span class="badge bg-success">Confirmada</span>
                                    @else
                                        <span class="badge bg-danger">Cancelada</span>
                                    @endif
                                </td>
                                <td class="text-center text-muted small">{{ $renewal->created_at->format('d/m/Y H:i') }}</td>
                                <td class="text-center">
                                    @if($renewal->isPendente())
                                    <button wire:click="confirmRenewal('{{ $renewal->id }}')"
                                            wire:loading.attr="disabled"
                                            class="btn btn-sm btn-success me-1"
                                            title="Confirmar">
                                        <i class="fas fa-check"></i>
                                    </button>
                                    <button wire:click="cancelRenewal('{{ $renewal->id }}')"
                                            wire:loading.attr="disabled"
                                            class="btn btn-sm btn-outline-danger"
                                            title="Cancelar">
                                        <i class="fas fa-times"></i>
                                    </button>
                                    @elseif($renewal->status === 'confirmada')
                                    <button wire:click="cancelRenewal('{{ $renewal->id }}')"
                                            wire:loading.attr="disabled"
                                            class="btn btn-sm btn-outline-danger"
                                            title="Cancelar renovação confirmada">
                                        <i class="fas fa-times"></i>
                                    </button>
                                    @else
                                    <span class="text-muted small">—</span>
                                    @endif
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="7" class="text-center text-muted py-4">
                                    <i class="fas fa-inbox fa-2x mb-2 d-block opacity-50"></i>
                                    Nenhuma renovação encontrada para os filtros seleccionados.
                                </td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                @if($renewals->count() > 0)
                <div class="card-footer bg-light text-muted small">
                    Total: {{ $renewals->count() }} renovação(ões)
                </div>
                @endif
            </div>

            <!-- Class Transition Card -->
            @if($confirmedNotTransitioned->count() > 0 || $transitionedCount > 0)
            <div class="card border-0 shadow-sm mt-4">
                <div class="card-header bg-light py-2 d-flex align-items-center justify-content-between">
                    <h6 class="mb-0 fw-semibold">
                        <i class="fas fa-rotate me-1 text-danger"></i>Transição de Classe para {{ $academicYear }}
                    </h6>
                    <div class="d-flex gap-2">
                        <span class="badge bg-success">{{ $transitionedCount }} transitado(s)</span>
                        <span class="badge bg-warning text-dark">{{ $confirmedNotTransitioned->count() }} por transitar</span>
                    </div>
                </div>

                @if($confirmedNotTransitioned->count() > 0)
                <div class="card-body pb-2">
                    <div class="row g-3 align-items-end mb-3">
                        <div class="col-md-5">
                            <label class="form-label fw-semibold small">
                                <i class="fas fa-school me-1 text-primary"></i>Turma de Destino
                                @if($filterClass)
                                    <span class="text-muted">({{ (int)$filterClass + 1 }}ª Classe)</span>
                                @endif
                            </label>
                            <select wire:model="transitionToClassroom" class="form-select @error('transitionToClassroom') is-invalid @enderror">
                                <option value="">— Escolher turma destino —</option>
                                @foreach($toClassrooms as $tc)
                                    <option value="{{ $tc->id }}">{{ $tc->class }}ª Classe — {{ $tc->name }}</option>
                                @endforeach
                            </select>
                            @if(!$filterClass)
                            <div class="form-text text-muted small">
                                <i class="fas fa-info-circle me-1"></i>Filtre por classe acima para ver apenas as turmas da classe seguinte.
                            </div>
                            @endif
                        </div>
                        <div class="col-md-4 d-flex align-items-end gap-2">
                            <button wire:click="executeTransition"
                                    wire:loading.attr="disabled"
                                    @if(empty($transitionSelected) || !$transitionToClassroom) disabled @endif
                                    class="btn btn-danger">
                                <span wire:loading.remove wire:target="executeTransition">
                                    <i class="fas fa-arrow-right me-1"></i>
                                    Executar Transição
                                    @if(count($transitionSelected) > 0)
                                        ({{ count($transitionSelected) }} aluno(s))
                                    @endif
                                </span>
                                <span wire:loading wire:target="executeTransition">
                                    <span class="spinner-border spinner-border-sm me-1"></span>A transitar...
                                </span>
                            </button>
                        </div>
                    </div>
                </div>
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead class="table-light">
                            <tr>
                                <th style="width:40px" class="text-center">
                                    <input type="checkbox" wire:model="transitionSelectAll" class="form-check-input">
                                </th>
                                <th>Aluno</th>
                                <th class="text-center">Turma Actual</th>
                                <th class="text-center">Transição</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($confirmedNotTransitioned as $r)
                            <tr>
                                <td class="text-center">
                                    <input type="checkbox"
                                           wire:model="transitionSelected"
                                           value="{{ $r->id }}"
                                           class="form-check-input">
                                </td>
                                <td>
                                    <div class="fw-semibold">{{ $r->student->name ?? '—' }}</div>
                                    <div class="text-muted small">{{ $r->student->phone_number ?? '' }}</div>
                                </td>
                                <td class="text-center">
                                    <span class="badge bg-secondary">{{ $r->fromClassroom->name ?? '—' }}</span>
                                </td>
                                <td class="text-center">
                                    <span class="badge bg-secondary">{{ $r->from_class }}ª</span>
                                    <i class="fas fa-arrow-right mx-1 text-muted small"></i>
                                    <span class="badge bg-primary">{{ $r->to_class }}ª</span>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                @endif

                @if($transitionedCount > 0)
                <div class="card-footer bg-light py-2">
                    <small class="text-success fw-semibold">
                        <i class="fas fa-check-circle me-1"></i>{{ $transitionedCount }} aluno(s) já transitado(s) para {{ $academicYear }}.
                    </small>
                </div>
                @endif
            </div>
            @endif

        </div>
    </div>
</div>
