<div class="page-content">
    <div class="main-wrapper">
        <!-- Header -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h4 class="mb-1"><i class="fas fa-file-invoice-dollar text-primary me-2"></i>Relatório de IVA</h4>
                        <p class="text-muted mb-0">Gere relatórios de IVA para declaração à Autoridade Tributária</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Filter Card -->
        <div class="card shadow-sm mb-4">
            <div class="card-header bg-primary text-white">
                <h5 class="mb-0"><i class="fas fa-filter me-2"></i>Filtros do Relatório</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="mb-3">
                            <label for="startDate" class="form-label">Data Início</label>
                            <input type="date" wire:model="startDate" class="form-control" id="startDate">
                            @error('startDate') <span class="text-danger small">{{ $message }}</span> @enderror
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="mb-3">
                            <label for="endDate" class="form-label">Data Fim</label>
                            <input type="date" wire:model="endDate" class="form-control" id="endDate">
                            @error('endDate') <span class="text-danger small">{{ $message }}</span> @enderror
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="mb-3">
                            <label for="category" class="form-label">Categoria (Opcional)</label>
                            <select wire:model="category" class="form-control" id="category">
                                <option value="">Todas as Categorias</option>
                                <option value="pos">POS</option>
                                <option value="certificado">Certificados</option>
                                <option value="declaracao">Declarações</option>
                                <option value="propina">Propinas</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <button wire:click="generateReport" class="btn btn-primary me-2">
                            <i class="fas fa-chart-bar me-1"></i> Gerar Relatório
                        </button>
                        <button wire:click="syncTransactions" class="btn btn-info me-2">
                            <i class="fas fa-sync me-1"></i> Sincronizar Transações
                        </button>
                    </div>
                </div>
            </div>
        </div>

        @if($showReport && $reportData)
        <!-- Statistics Cards -->
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <div class="d-flex justify-content-between">
                            <div>
                                <p class="text-muted mb-1">Base Tributável</p>
                                <h5 class="mb-0">{{ number_format($reportData['totals']['base_amount'], 2) }} MT</h5>
                            </div>
                            <div>
                                <i class="fas fa-coins fa-2x text-info"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <div class="d-flex justify-content-between">
                            <div>
                                <p class="text-muted mb-1">IVA Liquidado</p>
                                <h5 class="mb-0 text-success">{{ number_format($reportData['totals']['iva_amount'], 2) }} MT</h5>
                            </div>
                            <div>
                                <i class="fas fa-dollar-sign fa-2x text-success"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <div class="d-flex justify-content-between">
                            <div>
                                <p class="text-muted mb-1">Total Faturado</p>
                                <h5 class="mb-0 text-primary">{{ number_format($reportData['totals']['total_amount'], 2) }} MT</h5>
                            </div>
                            <div>
                                <i class="fas fa-receipt fa-2x text-primary"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <div class="d-flex justify-content-between">
                            <div>
                                <p class="text-muted mb-1">Nº Transações</p>
                                <h5 class="mb-0">{{ $reportData['totals']['transaction_count'] }}</h5>
                            </div>
                            <div>
                                <i class="fas fa-file-invoice fa-2x text-warning"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- By Category -->
        <div class="row mb-4">
            <div class="col-md-6">
                <div class="card shadow-sm">
                    <div class="card-header bg-light">
                        <h5 class="mb-0"><i class="fas fa-tags me-2"></i>IVA por Categoria</h5>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-sm">
                                <thead>
                                    <tr>
                                        <th>Categoria</th>
                                        <th class="text-end">Base</th>
                                        <th class="text-end">IVA</th>
                                        <th class="text-end">Total</th>
                                        <th class="text-center">Qtd</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($reportData['by_category'] as $cat => $data)
                                    <tr>
                                        <td><strong>{{ ucfirst($cat) }}</strong></td>
                                        <td class="text-end">{{ number_format($data['base'], 2) }}</td>
                                        <td class="text-end text-success">{{ number_format($data['iva'], 2) }}</td>
                                        <td class="text-end">{{ number_format($data['total'], 2) }}</td>
                                        <td class="text-center"><span class="badge bg-primary">{{ $data['count'] }}</span></td>
                                    </tr>
                                    @empty
                                    <tr>
                                        <td colspan="5" class="text-center text-muted">Nenhuma transação encontrada</td>
                                    </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <!-- By Rate -->
            <div class="col-md-6">
                <div class="card shadow-sm">
                    <div class="card-header bg-light">
                        <h5 class="mb-0"><i class="fas fa-percent me-2"></i>IVA por Taxa</h5>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-sm">
                                <thead>
                                    <tr>
                                        <th>Taxa</th>
                                        <th class="text-end">Base</th>
                                        <th class="text-end">IVA</th>
                                        <th class="text-end">Total</th>
                                        <th class="text-center">Qtd</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($reportData['by_rate'] as $rate => $data)
                                    <tr>
                                        <td><strong>{{ $rate }}%</strong></td>
                                        <td class="text-end">{{ number_format($data['base'], 2) }}</td>
                                        <td class="text-end text-success">{{ number_format($data['iva'], 2) }}</td>
                                        <td class="text-end">{{ number_format($data['total'], 2) }}</td>
                                        <td class="text-center"><span class="badge bg-primary">{{ $data['count'] }}</span></td>
                                    </tr>
                                    @empty
                                    <tr>
                                        <td colspan="5" class="text-center text-muted">Nenhuma transação encontrada</td>
                                    </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Export Buttons -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <h5 class="mb-3"><i class="fas fa-download me-2"></i>Exportar Relatório</h5>
                        <button wire:click="exportPdf" class="btn btn-danger me-2">
                            <i class="fas fa-file-pdf me-1"></i> Exportar PDF
                        </button>
                        <button wire:click="exportExcel" class="btn btn-success">
                            <i class="fas fa-file-excel me-1"></i> Exportar Excel
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Transactions Detail -->
        <div class="card shadow-sm">
            <div class="card-header bg-light">
                <h5 class="mb-0"><i class="fas fa-list me-2"></i>Detalhes das Transações</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Data</th>
                                <th>Categoria</th>
                                <th>Descrição</th>
                                <th class="text-end">Base</th>
                                <th class="text-end">IVA</th>
                                <th class="text-end">Total</th>
                                <th>Ref</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($reportData['transactions'] as $transaction)
                            <tr>
                                <td>{{ \Carbon\Carbon::parse($transaction->transaction_date)->format('d/m/Y') }}</td>
                                <td><span class="badge bg-info">{{ $transaction->category }}</span></td>
                                <td>{{ $transaction->description }}</td>
                                <td class="text-end">{{ number_format($transaction->base_amount, 2) }}</td>
                                <td class="text-end text-success">{{ number_format($transaction->iva_amount, 2) }}</td>
                                <td class="text-end"><strong>{{ number_format($transaction->total_amount, 2) }}</strong></td>
                                <td><small class="text-muted">{{ $transaction->reference_number }}</small></td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="7" class="text-center text-muted py-4">Nenhuma transação encontrada no período selecionado</td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        @endif

        @if(!$showReport)
        <div class="card shadow-sm">
            <div class="card-body text-center py-5">
                <i class="fas fa-chart-bar fa-4x text-muted mb-3"></i>
                <h5 class="text-muted">Selecione o período e clique em "Gerar Relatório"</h5>
            </div>
        </div>
        @endif
    </div>
</div>
