<div>
    <div class="page-content">
        <div class="main-wrapper">

            <div class="card border-0 shadow">

                <!-- ── Header ──────────────────────────────────────── -->
                <div class="card-header bg-primary text-white py-3 d-flex justify-content-between align-items-center flex-wrap gap-2">
                    <h2 class="h5 mb-0">
                        <i class="fas fa-chart-pie me-2"></i>Visão Geral de Admissões
                    </h2>
                    <div class="d-flex align-items-center gap-2">
                        <label class="mb-0 small fw-semibold opacity-75">Ano:</label>
                        <select wire:model="year" class="form-select form-select-sm" style="min-width:110px">
                            @foreach($availableYears as $y)
                                <option value="{{ $y }}">{{ $y }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>

                <div class="card-body">

                    <!-- ── Stat Cards ──────────────────────────────── -->
                    <div class="row g-3 mb-4">
                        @php
                            $statCards = [
                                ['val'=>$preTotal,        'label'=>'Pré-inscrições',     'icon'=>'fa-file-alt',       'bg'=>'#e0e7ff','color'=>'#4f46e5'],
                                ['val'=>$preConfirmada,   'label'=>'Pré-insc. Confirm.', 'icon'=>'fa-check-circle',   'bg'=>'#d1fae5','color'=>'#16a34a'],
                                ['val'=>$preMatriculada,  'label'=>'Novos Matriculados', 'icon'=>'fa-user-graduate',  'bg'=>'#fef9c3','color'=>'#ca8a04'],
                                ['val'=>$renewTotal,      'label'=>'Renovações',         'icon'=>'fa-rotate',         'bg'=>'#ede9fe','color'=>'#7c3aed'],
                                ['val'=>$renewTransitioned,'label'=>'Transitados',       'icon'=>'fa-arrow-right',    'bg'=>'#fee2e2','color'=>'#dc2626'],
                            ];
                        @endphp
                        @foreach($statCards as $card)
                        <div class="col-6 col-md-4 col-xl">
                            <div class="card border-0 h-100" style="background:#f8f9fa">
                                <div class="card-body d-flex align-items-center gap-3 py-3 px-3">
                                    <div class="rounded-circle d-flex align-items-center justify-content-center flex-shrink-0"
                                         style="width:48px;height:48px;background:{{ $card['bg'] }}">
                                        <i class="fas {{ $card['icon'] }}" style="color:{{ $card['color'] }}"></i>
                                    </div>
                                    <div>
                                        <div class="fw-bold" style="font-size:1.75rem;line-height:1;color:{{ $card['color'] }}">{{ $card['val'] }}</div>
                                        <div class="text-muted small mt-1">{{ $card['label'] }}</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>

                    <!-- ── Funil + Renovações ─────────────────────── -->
                    <div class="row g-3 mb-4">

                        <!-- Funil Novos Alunos -->
                        <div class="col-md-6">
                            <div class="card border-0 h-100" style="background:#f8f9fa">
                                <div class="card-header bg-light border-0 py-2 d-flex align-items-center justify-content-between">
                                    <h6 class="mb-0 fw-semibold">
                                        <i class="fas fa-filter me-1 text-primary"></i>Funil — Novos Alunos {{ $year }}
                                    </h6>
                                </div>
                                <div class="card-body">
                                    @php $funnelMax = max($preTotal, 1); @endphp

                                    @foreach([
                                        ['label'=>'Pré-inscrições','val'=>$preTotal,       'pct'=>100,                                             'cls'=>'bg-primary'],
                                        ['label'=>'Confirmadas',   'val'=>$preConfirmada,  'pct'=>round($preConfirmada/$funnelMax*100),            'cls'=>'bg-success'],
                                        ['label'=>'Matriculadas',  'val'=>$preMatriculada, 'pct'=>round($preMatriculada/$funnelMax*100),           'cls'=>'','style'=>'background:#ca8a04'],
                                        ['label'=>'Anuladas',      'val'=>$preAnulada,     'pct'=>round($preAnulada/$funnelMax*100),              'cls'=>'bg-danger'],
                                        ['label'=>'Pendentes',     'val'=>$prePendente,    'pct'=>round($prePendente/$funnelMax*100),             'cls'=>'bg-warning'],
                                    ] as $row)
                                    @if($row['val'] > 0)
                                    <div class="mb-3">
                                        <div class="d-flex justify-content-between small fw-semibold mb-1">
                                            <span class="text-muted">{{ $row['label'] }}</span>
                                            <span class="badge {{ $row['cls'] }} {{ $row['cls']==='bg-warning'?'text-dark':'' }}"
                                                  @isset($row['style']) style="{{ $row['style'] }}" @endisset>{{ $row['val'] }}</span>
                                        </div>
                                        <div class="progress" style="height:14px;border-radius:4px">
                                            <div class="progress-bar {{ $row['cls'] }}"
                                                 style="width:{{ $row['pct'] }}%;border-radius:4px;{{ $row['style'] ?? '' }}"></div>
                                        </div>
                                    </div>
                                    @endif
                                    @endforeach

                                    <!-- Géneros -->
                                    <hr class="my-3">
                                    <div class="d-flex gap-3 justify-content-center">
                                        <div class="text-center">
                                            <div class="fw-bold fs-5 text-primary">{{ $preBySex['M'] ?? 0 }}</div>
                                            <div class="small text-muted"><i class="fas fa-mars me-1"></i>Masculino</div>
                                        </div>
                                        <div class="vr"></div>
                                        <div class="text-center">
                                            <div class="fw-bold fs-5" style="color:#db2777">{{ $preBySex['F'] ?? 0 }}</div>
                                            <div class="small text-muted"><i class="fas fa-venus me-1"></i>Feminino</div>
                                        </div>
                                        @if(isset($preBySex['']))
                                        <div class="vr"></div>
                                        <div class="text-center">
                                            <div class="fw-bold fs-5 text-muted">{{ $preBySex[''] ?? 0 }}</div>
                                            <div class="small text-muted">N/D</div>
                                        </div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Renovações por Estado -->
                        <div class="col-md-6">
                            <div class="card border-0 h-100" style="background:#f8f9fa">
                                <div class="card-header bg-light border-0 py-2">
                                    <h6 class="mb-0 fw-semibold">
                                        <i class="fas fa-rotate me-1" style="color:#7c3aed"></i>Renovações por Estado {{ $year }}
                                    </h6>
                                </div>
                                <div class="card-body">
                                    @php $renewMax = max($renewTotal, 1); @endphp

                                    @foreach([
                                        ['label'=>'Total Renovações','val'=>$renewTotal,       'pct'=>100,                                       'color'=>'#7c3aed'],
                                        ['label'=>'Confirmadas',     'val'=>$renewConfirmada,  'pct'=>round($renewConfirmada/$renewMax*100),    'color'=>'#16a34a'],
                                        ['label'=>'Pendentes',       'val'=>$renewPendente,    'pct'=>round($renewPendente/$renewMax*100),      'color'=>'#f59e0b'],
                                        ['label'=>'Canceladas',      'val'=>$renewCancelada,   'pct'=>round($renewCancelada/$renewMax*100),     'color'=>'#dc2626'],
                                        ['label'=>'Transitados',     'val'=>$renewTransitioned,'pct'=>round($renewTransitioned/$renewMax*100),  'color'=>'#0891b2'],
                                    ] as $row)
                                    @if($row['val'] > 0)
                                    <div class="mb-3">
                                        <div class="d-flex justify-content-between small fw-semibold mb-1">
                                            <span class="text-muted">{{ $row['label'] }}</span>
                                            <span class="badge rounded-pill" style="background:{{ $row['color'] }}">{{ $row['val'] }}</span>
                                        </div>
                                        <div class="progress" style="height:14px;border-radius:4px">
                                            <div class="progress-bar" style="width:{{ $row['pct'] }}%;background:{{ $row['color'] }};border-radius:4px"></div>
                                        </div>
                                    </div>
                                    @endif
                                    @endforeach

                                    <!-- Totais -->
                                    <hr class="my-3">
                                    <div class="d-flex gap-3 justify-content-center">
                                        <div class="text-center">
                                            <div class="fw-bold fs-5 text-primary">{{ $preMatriculada + $renewConfirmada }}</div>
                                            <div class="small text-muted">Total Alunos {{ $year }}</div>
                                        </div>
                                        <div class="vr"></div>
                                        <div class="text-center">
                                            <div class="fw-bold fs-5 text-success">{{ $preMatriculada }}</div>
                                            <div class="small text-muted">Novos</div>
                                        </div>
                                        <div class="vr"></div>
                                        <div class="text-center">
                                            <div class="fw-bold fs-5" style="color:#7c3aed">{{ $renewConfirmada }}</div>
                                            <div class="small text-muted">Renovados</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- ── Vagas por Turma ─────────────────────────── -->
                    @if($classroomStats->count() > 0)
                    <div class="card border-0 mb-4" style="background:#f8f9fa">
                        <div class="card-header bg-light border-0 py-2">
                            <h6 class="mb-0 fw-semibold"><i class="fas fa-school me-1 text-primary"></i>Vagas por Turma — {{ $year }}</h6>
                        </div>
                        <div class="table-responsive">
                            <table class="table table-hover align-middle mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th class="text-center">Classe</th>
                                        <th>Turma</th>
                                        <th class="text-center">Capacidade</th>
                                        <th class="text-center">Renovações</th>
                                        <th class="text-center">Novos</th>
                                        <th class="text-center" style="min-width:130px">Ocupação</th>
                                        <th class="text-center">Vagas Livres</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($classroomStats as $cs)
                                    @php
                                        $pct = $cs['capacity'] ? min(100, round($cs['used']/$cs['capacity']*100)) : null;
                                        $barCls = $pct >= 90 ? 'bg-danger' : ($pct >= 70 ? 'bg-warning' : 'bg-success');
                                    @endphp
                                    <tr>
                                        <td class="text-center fw-semibold">{{ $cs['class'] }}ª</td>
                                        <td>{{ $cs['name'] }}</td>
                                        <td class="text-center">
                                            @if($cs['capacity'])
                                                <span class="badge bg-secondary">{{ $cs['capacity'] }}</span>
                                            @else
                                                <span class="text-muted">—</span>
                                            @endif
                                        </td>
                                        <td class="text-center">
                                            <span class="badge" style="background:#7c3aed">{{ $cs['renew_confirmed'] }}</span>
                                        </td>
                                        <td class="text-center">
                                            <span class="badge" style="background:#ca8a04">{{ $cs['new_enrolled'] }}</span>
                                        </td>
                                        <td>
                                            @if($pct !== null)
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="progress flex-grow-1" style="height:12px;border-radius:4px">
                                                    <div class="progress-bar {{ $barCls }}"
                                                         style="width:{{ $pct }}%;border-radius:4px"
                                                         title="{{ $cs['used'] }}/{{ $cs['capacity'] }}"></div>
                                                </div>
                                                <span class="small fw-semibold" style="min-width:32px">{{ $pct }}%</span>
                                            </div>
                                            @else
                                                <span class="text-muted small fst-italic">—</span>
                                            @endif
                                        </td>
                                        <td class="text-center">
                                            @if($cs['free'] !== null)
                                                <span class="badge {{ $cs['free']<=3?'bg-danger':($cs['free']<=8?'bg-warning text-dark':'bg-success') }}">
                                                    {{ $cs['free'] }}
                                                </span>
                                            @else
                                                <span class="text-muted">—</span>
                                            @endif
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                    @endif

                    <!-- ── Pré-inscrições por Classe ───────────────── -->
                    @if($preByClass->count() > 0)
                    <div class="card border-0" style="background:#f8f9fa">
                        <div class="card-header bg-light border-0 py-2">
                            <h6 class="mb-0 fw-semibold"><i class="fas fa-layer-group me-1 text-primary"></i>Pré-inscrições por Classe — {{ $year }}</h6>
                        </div>
                        <div class="table-responsive">
                            <table class="table table-hover align-middle mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th class="text-center">Classe</th>
                                        <th class="text-center">Total</th>
                                        <th class="text-center">Pendentes</th>
                                        <th class="text-center">Confirmadas</th>
                                        <th class="text-center">Matriculadas</th>
                                        <th class="text-center">Anuladas</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($preByClass as $class => $rows)
                                    @php
                                        $byStatus = $rows->pluck('total', 'status');
                                        $rowTotal = $rows->sum('total');
                                    @endphp
                                    <tr>
                                        <td class="text-center fw-semibold">{{ $class }}ª Classe</td>
                                        <td class="text-center"><span class="badge bg-primary">{{ $rowTotal }}</span></td>
                                        <td class="text-center">
                                            @if($byStatus->get('pendente', 0) > 0)
                                                <span class="badge bg-warning text-dark">{{ $byStatus->get('pendente', 0) }}</span>
                                            @else<span class="text-muted small">—</span>@endif
                                        </td>
                                        <td class="text-center">
                                            <span class="badge bg-success">{{ $byStatus->get('confirmada', 0) }}</span>
                                        </td>
                                        <td class="text-center">
                                            <span class="badge" style="background:#ca8a04">{{ $byStatus->get('matriculada', 0) }}</span>
                                        </td>
                                        <td class="text-center">
                                            @if($byStatus->get('anulada', 0) > 0)
                                                <span class="badge bg-danger">{{ $byStatus->get('anulada', 0) }}</span>
                                            @else<span class="text-muted small">—</span>@endif
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                    @endif

                    <!-- Empty state -->
                    @if($preTotal === 0 && $renewTotal === 0)
                    <div class="text-center text-muted py-5">
                        <i class="fas fa-chart-pie fa-3x mb-3 d-block opacity-25"></i>
                        <p class="mb-0 fw-semibold">Sem dados para o ano <strong>{{ $year }}</strong></p>
                        <p class="small">Verifique o ano seleccionado ou aguarde candidaturas.</p>
                    </div>
                    @endif

                </div>{{-- card-body --}}
            </div>{{-- card --}}

        </div>
    </div>
</div>
