<div class="page-content">
    <div class="main-wrapper">
        <!-- Header -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h4 class="mb-1"><i class="fas fa-sms text-primary me-2"></i>Configurações de SMS</h4>
                        <p class="text-muted mb-0">Configure o gateway de envio de SMS (Movitel ou Twilio)</p>
                    </div>
                    <div class="d-flex gap-2">
                        <a href="{{ route('admin.add.sms') }}" class="btn btn-outline-primary">
                            <i class="fas fa-paper-plane me-1"></i> Enviar SMS
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-8 mx-auto">
                <div class="card shadow-sm">
                    <div class="card-header bg-primary text-white">
                        <h5 class="mb-0">
                            <i class="fas fa-sliders-h me-2"></i>Gateway SMS
                        </h5>
                    </div>

                    <div class="card-body">
                        <form wire:submit.prevent="save">
                            <!-- Gateway Selection -->
                            <div class="mb-4">
                                <h6 class="border-bottom pb-2 mb-3">
                                    <i class="fas fa-network-wired text-primary me-2"></i>Selecionar Gateway
                                </h6>

                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <div class="form-check form-check-inline">
                                            <input
                                                class="form-check-input"
                                                type="radio"
                                                wire:model.defer="gateway"
                                                wire:change="$refresh"
                                                id="gatewayMovitel"
                                                value="movitel"
                                            />
                                            <label class="form-check-label" for="gatewayMovitel">
                                                <strong>Movitel</strong>
                                                <small class="text-muted d-block">Bulk SMS Moçambique</small>
                                            </label>
                                        </div>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <div class="form-check form-check-inline">
                                            <input
                                                class="form-check-input"
                                                type="radio"
                                                wire:model.defer="gateway"
                                                wire:change="$refresh"
                                                id="gatewayTwilio"
                                                value="twilio"
                                            />
                                            <label class="form-check-label" for="gatewayTwilio">
                                                <strong>Twilio</strong>
                                                <small class="text-muted d-block">SMS internacional via Twilio</small>
                                            </label>
                                        </div>
                                    </div>
                                </div>

                                @if($gateway === 'movitel')
                                    <div class="alert alert-info mb-0">
                                        <i class="fas fa-info-circle me-2"></i>
                                        <strong>Movitel Gateway Activo:</strong> SMS serão enviados via Movitel
                                    </div>
                                @else
                                    <div class="alert alert-secondary mb-0">
                                        <i class="fas fa-info-circle me-2"></i>
                                        <strong>Twilio Gateway Activo:</strong> SMS serão enviados via Twilio
                                    </div>
                                @endif
                            </div>

                            <!-- Movitel Settings -->
                            <div class="mb-4 {{ $gateway !== 'movitel' ? 'opacity-50' : '' }}">
                                <h6 class="border-bottom pb-2 mb-3">
                                    <i class="fas fa-mobile-alt text-success me-2"></i>Configurações Movitel
                                </h6>

                                <div class="row">
                                    <div class="col-12 mb-3">
                                        <label class="form-label">URL da API <span class="text-danger">*</span></label>
                                        <input
                                            type="url"
                                            wire:model="movitel_api_url"
                                            class="form-control @error('movitel_api_url') is-invalid @enderror"
                                            placeholder="https://sms.itcore.app/api/http/sms/send"
                                            {{ $gateway !== 'movitel' ? 'disabled' : '' }}
                                        />
                                        @error('movitel_api_url')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="col-12 mb-3">
                                        <label class="form-label">API Token <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <input
                                                type="password"
                                                wire:model="movitel_api_token"
                                                class="form-control @error('movitel_api_token') is-invalid @enderror"
                                                placeholder="Seu token da API Movitel"
                                                id="movitelToken"
                                                {{ $gateway !== 'movitel' ? 'disabled' : '' }}
                                            />
                                            <button class="btn btn-outline-secondary" type="button" onclick="togglePassword('movitelToken')">
                                                <i class="fas fa-eye"></i>
                                            </button>
                                            @error('movitel_api_token')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                        <small class="text-muted">Token de autenticação Bearer da API</small>
                                    </div>

                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Sender ID <span class="text-danger">*</span></label>
                                        <input
                                            type="text"
                                            wire:model="movitel_sender_id"
                                            class="form-control @error('movitel_sender_id') is-invalid @enderror"
                                            placeholder="COPMOZ"
                                            maxlength="11"
                                            {{ $gateway !== 'movitel' ? 'disabled' : '' }}
                                        />
                                        @error('movitel_sender_id')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                        <small class="text-muted">Nome que aparece como remetente (max 11 caracteres)</small>
                                    </div>
                                </div>
                            </div>

                            <!-- Twilio Settings -->
                            <div class="mb-4 {{ $gateway !== 'twilio' ? 'opacity-50' : '' }}">
                                <h6 class="border-bottom pb-2 mb-3">
                                    <i class="fas fa-phone-alt text-danger me-2"></i>Configurações Twilio
                                </h6>

                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Account SID <span class="text-danger">*</span></label>
                                        <input
                                            type="text"
                                            wire:model="twilio_sid"
                                            class="form-control @error('twilio_sid') is-invalid @enderror"
                                            placeholder="ACxxxxxxxxxxxxxxxxxxxxxxxxx"
                                            {{ $gateway !== 'twilio' ? 'disabled' : '' }}
                                        />
                                        @error('twilio_sid')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Auth Token <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <input
                                                type="password"
                                                wire:model="twilio_token"
                                                class="form-control @error('twilio_token') is-invalid @enderror"
                                                placeholder="Seu Auth Token"
                                                id="twilioToken"
                                                {{ $gateway !== 'twilio' ? 'disabled' : '' }}
                                            />
                                            <button class="btn btn-outline-secondary" type="button" onclick="togglePassword('twilioToken')">
                                                <i class="fas fa-eye"></i>
                                            </button>
                                            @error('twilio_token')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">From (Remetente) <span class="text-danger">*</span></label>
                                        <input
                                            type="text"
                                            wire:model="twilio_from"
                                            class="form-control @error('twilio_from') is-invalid @enderror"
                                            placeholder="COPMOZ ou +1234567890"
                                            {{ $gateway !== 'twilio' ? 'disabled' : '' }}
                                        />
                                        @error('twilio_from')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                        <small class="text-muted">Número ou nome alfanumérico</small>
                                    </div>
                                </div>
                            </div>

                            <!-- General Settings -->
                            <div class="mb-4">
                                <h6 class="border-bottom pb-2 mb-3">
                                    <i class="fas fa-cogs text-warning me-2"></i>Configurações Gerais
                                </h6>

                                <div class="row">
                                    <div class="col-md-4 mb-3">
                                        <label class="form-label">Código do País <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <span class="input-group-text">+</span>
                                            <input
                                                type="text"
                                                wire:model="country_code"
                                                class="form-control @error('country_code') is-invalid @enderror"
                                                placeholder="258"
                                            />
                                            @error('country_code')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                        <small class="text-muted">Moçambique: 258</small>
                                    </div>

                                    <div class="col-md-8 mb-3">
                                        <label class="form-label d-block">&nbsp;</label>
                                        <div class="form-check form-switch">
                                            <input
                                                class="form-check-input"
                                                type="checkbox"
                                                wire:model="log_messages"
                                                id="logMessages"
                                                style="cursor: pointer; width: 3em; height: 1.5em;"
                                            />
                                            <label class="form-check-label ms-2" for="logMessages" style="cursor: pointer;">
                                                <strong>Guardar Log de Mensagens</strong>
                                            </label>
                                        </div>
                                        <small class="text-muted d-block mt-1">
                                            Registar todas as mensagens enviadas na base de dados
                                        </small>
                                    </div>
                                </div>
                            </div>

                            <!-- Action Buttons -->
                            <div class="d-flex justify-content-end align-items-center border-top pt-4">
                                <button
                                    type="submit"
                                    class="btn btn-primary btn-lg"
                                    wire:loading.attr="disabled"
                                >
                                    <span wire:loading.remove wire:target="save">
                                        <i class="fas fa-save me-2"></i> Salvar Configurações
                                    </span>
                                    <span wire:loading wire:target="save">
                                        <i class="fas fa-spinner fa-spin me-2"></i> Salvando...
                                    </span>
                                </button>
                            </div>
                        </form>
                    </div>
                </div>

                <!-- Test SMS Card -->
                <div class="card shadow-sm mt-4">
                    <div class="card-header bg-success text-white">
                        <h5 class="mb-0">
                            <i class="fas fa-vial me-2"></i>Testar Envio de SMS
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <label class="form-label">Número de Telefone</label>
                                <div class="input-group">
                                    <span class="input-group-text">+{{ $country_code }}</span>
                                    <input
                                        type="text"
                                        wire:model="test_phone"
                                        class="form-control"
                                        placeholder="841234567"
                                    />
                                </div>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Mensagem de Teste</label>
                                <input
                                    type="text"
                                    wire:model="test_message"
                                    class="form-control"
                                    placeholder="Mensagem de teste..."
                                />
                            </div>
                            <div class="col-md-2 mb-3">
                                <label class="form-label d-block">&nbsp;</label>
                                <button
                                    type="button"
                                    wire:click="sendTestSms"
                                    class="btn btn-success w-100"
                                    wire:loading.attr="disabled"
                                >
                                    <span wire:loading.remove wire:target="sendTestSms">
                                        <i class="fas fa-paper-plane"></i> Enviar
                                    </span>
                                    <span wire:loading wire:target="sendTestSms">
                                        <i class="fas fa-spinner fa-spin"></i>
                                    </span>
                                </button>
                            </div>
                        </div>
                        <small class="text-muted">
                            <i class="fas fa-info-circle me-1"></i>
                            Envia um SMS de teste usando o gateway activo ({{ $gateway === 'movitel' ? 'Movitel' : 'Twilio' }})
                        </small>
                    </div>
                </div>

                <!-- Info Card -->
                <div class="card shadow-sm mt-4">
                    <div class="card-body">
                        <h6 class="mb-3"><i class="fas fa-info-circle text-info me-2"></i>Informações</h6>
                        <ul class="mb-0">
                            <li class="mb-2">
                                <strong>Movitel:</strong> Gateway recomendado para envio de SMS em Moçambique.
                                Obtenha API na Movitel.
                            </li>
                            <li class="mb-2">
                                <strong>Twilio:</strong> Gateway internacional para envio de SMS.
                                Registe-se em <a href="https://www.twilio.com" target="_blank">twilio.com</a>
                            </li>
                            <li class="mb-2">
                                <strong>Sender ID:</strong> Nome ou número que aparece como remetente da mensagem (máximo 11 caracteres)
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function togglePassword(inputId) {
    const input = document.getElementById(inputId);
    if (input.type === 'password') {
        input.type = 'text';
    } else {
        input.type = 'password';
    }
}
</script>
