<div class="page-content">
    <div class="container-fluid">
        <!-- Page Header -->
        <div class="row mb-4 mt-3">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="pt-3">
                        <h1 class="h3 mb-1 text-primary">
                            <i class="fas fa-user-graduate me-2"></i>Lista de Estudantes
                        </h1>
                        <p class="text-muted mb-0">
                            Gerencie os estudantes matriculados no sistema
                        </p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Filters Card -->
        <div class="card border-0 shadow-sm mb-4">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h5 class="card-title mb-0 text-primary">
                        <i class="fas fa-filter me-2"></i>Filtros de Pesquisa
                        @php
                            $activeFilters = 0;
                            if($selectedClass) $activeFilters++;
                            if($selectedTurma) $activeFilters++;
                            if($selectedStatus !== '') $activeFilters++;
                            if($selectedPaymentStatus !== '') $activeFilters++;
                            if($search) $activeFilters++;
                        @endphp
                        @if($activeFilters > 0)
                            <span class="badge bg-info ms-2">{{ $activeFilters }} ativo{{ $activeFilters > 1 ? 's' : '' }}</span>
                        @endif
                    </h5>
                    <div class="d-flex gap-2">
                        <div class="btn-group" role="group">
                            <button type="button" wire:click="exportPDF" class="btn btn-danger btn-sm">
                                <i class="fa fa-file-pdf me-1"></i>PDF
                            </button>
                            <button type="button" wire:click="exportExcel" class="btn btn-success btn-sm">
                                <i class="fa fa-file-excel me-1"></i>Excel
                            </button>
                        </div>
                        @if($activeFilters > 0)
                        <button wire:click="$set('selectedClass', ''); $set('selectedTurma', ''); $set('selectedStatus', ''); $set('selectedPaymentStatus', ''); $set('search', '')"
                                class="btn btn-sm btn-outline-secondary">
                            <i class="fas fa-times me-1"></i>Limpar Filtros
                        </button>
                        @endif
                    </div>
                </div>

                <div class="row g-3">
                    <!-- Classe -->
                    <div class="col-md-2">
                        <label for="selectedClass" class="form-label">Classe</label>
                        <select class="form-select" wire:model="selectedClass">
                            <option value="">Todas</option>
                            @foreach($classes as $class)
                                <option value="{{ $class->class }}">{{ $class->class }}ª</option>
                            @endforeach
                        </select>
                    </div>

                    <!-- Turma -->
                    <div class="col-md-2">
                        <label for="selectedTurma" class="form-label">Turma</label>
                        <select class="form-select" wire:model="selectedTurma" {{ !$selectedClass ? 'disabled' : '' }}>
                            <option value="">Todas</option>
                            @foreach($turmas as $turma)
                                <option value="{{ $turma->id }}">{{ $turma->name }}</option>
                            @endforeach
                        </select>
                    </div>

                    <!-- Estado de Pagamento -->
                    <div class="col-md-2">
                        <label for="selectedPaymentStatus" class="form-label">Pagamento</label>
                        <select class="form-select" wire:model="selectedPaymentStatus">
                            <option value="">Todos</option>
                            <option value="1">Pago (Regular)</option>
                            <option value="0">Não Pago</option>
                        </select>
                    </div>

                    <!-- Estado de Acesso -->
                    <div class="col-md-2">
                        <label for="selectedStatus" class="form-label">Acesso</label>
                        <select class="form-select" wire:model="selectedStatus">
                            <option value="">Todos</option>
                            <option value="1">Ativo</option>
                            <option value="0">Desativado</option>
                        </select>
                    </div>

                    <!-- Pesquisar -->
                    <div class="col-md-4">
                        <label for="search" class="form-label">Pesquisar</label>
                        <div class="input-group">
                            <input type="search"
                                   class="form-control"
                                   wire:model.debounce.300ms="search"
                                   placeholder="Nome, ID, telefone...">
                            <span class="input-group-text">
                                <i class="fas fa-search"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Students Card -->
        <div class="card border-0 shadow-sm">
            <div class="card-body p-0">
                <div class="d-flex justify-content-between align-items-center p-4 border-bottom">
                    <h5 class="card-title mb-0 text-primary">
                        <i class="fas fa-users me-2"></i>Estudantes
                        @if(count($models))
                            <span class="badge bg-primary ms-2">{{ $models->total() }}</span>
                        @endif
                    </h5>
                </div>

                <div class="table-responsive" wire:init="loadData">
                    @if(count($models))
                        <table class="table table-hover align-middle mb-0 students-table">
                            <thead class="bg-light">
                                <tr>
                                    <th>#</th>
                                    <th>Nome</th>
                                    <th>ID Estudante</th>
                                    <th>Sexo</th>
                                    <th>Data Nasc.</th>
                                    <th>Celular</th>
                                    <th>Classe</th>
                                    <th>Turma</th>
                                    <th>Pagamento</th>
                                    <th>Acesso</th>
                                    <th class="text-end pe-4">Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php($count = 1)
                                @foreach($models as $model)
                                    <tr>
                                        <td>
                                            <span class="text-muted fw-bold">{{ $count++ }}</span>
                                        </td>
                                        <td>
                                            <strong>{{ $model->name }}</strong>
                                        </td>
                                        <td>
                                            <span class="text-muted">{{ $model->student_id }}</span>
                                        </td>
                                        <td>{{ $model->sex }}</td>
                                        <td>
                                            <span class="text-muted">{{ $model->dob }}</span>
                                        </td>
                                        <td>
                                            <span class="text-muted">{{ $model->phone_number }}</span>
                                        </td>
                                        <td>
                                            @if($model->class)
                                                <span class="badge bg-info">{{ $model->class->class }}ª Classe</span>
                                            @else
                                                <span class="text-muted">-</span>
                                            @endif
                                        </td>
                                        <td>
                                            @if($model->class)
                                                {{ $model->class->name }}
                                            @else
                                                <span class="text-muted">-</span>
                                            @endif
                                        </td>
                                        <td>
                                            @if($model->is_paid)
                                                <span class="badge bg-success">Pago</span>
                                            @else
                                                <span class="badge bg-danger">Não Pago</span>
                                            @endif
                                        </td>
                                        <td>
                                            <button wire:click="toggleActive('{{ $model->id }}')"
                                                    class="btn btn-sm {{ $model->is_active ? 'btn-success' : 'btn-danger' }}">
                                                {{ $model->is_active ? 'Ativo' : 'Desativado' }}
                                            </button>
                                        </td>
                                        <td class="pe-4">
                                            <div class="d-flex justify-content-end gap-2 action-cell">
                                                <a href="{{ route('admin.edit.student', $model->slug) }}"
                                                   class="btn btn-sm btn-outline-primary"
                                                   title="Editar">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                @if($user->role == 0)
                                                    <button type="button"
                                                            wire:click="submitcomplete('{{ $model->id }}')"
                                                            class="btn btn-sm btn-outline-warning"
                                                            title="Marcar como não pago">
                                                        <i class="fas fa-exclamation-triangle"></i>
                                                    </button>
                                                @endif
                                                <button type="button"
                                                        wire:click="submit('{{ $model->id }}')"
                                                        class="btn btn-sm btn-outline-danger"
                                                        title="Deletar">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>

                        <!-- Pagination -->
                        <div class="d-flex justify-content-center p-4 border-top">
                            {{ $models->links() }}
                        </div>
                    @else
                        <div class="text-center py-5">
                            <div wire:loading class="mb-3">
                                <div class="spinner-border text-primary" style="width: 3rem; height: 3rem;" role="status">
                                    <span class="visually-hidden">Carregando...</span>
                                </div>
                                <p class="mt-3 mb-0">Processando...</p>
                            </div>
                            <div wire:loading.remove>
                                <i class="fas fa-user-slash text-muted" style="font-size: 3rem;"></i>
                                <h5 class="mt-3">Nenhum estudante encontrado</h5>
                                <p class="text-muted">Ajuste os filtros ou adicione novos estudantes</p>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .students-table {
        font-size: 14px;
    }

    .students-table thead th {
        font-weight: 600;
        text-transform: uppercase;
        font-size: 12px;
        letter-spacing: 0.5px;
        color: #495057;
        border-bottom: 2px solid #dee2e6;
        padding: 1rem;
    }

    .students-table tbody td {
        padding: 1rem;
        vertical-align: middle;
    }

    .students-table tbody tr:hover {
        background-color: #f8f9fa;
    }

    .action-cell .btn {
        transition: all 0.2s ease;
    }

    .action-cell .btn:hover {
        transform: translateY(-2px);
    }

    .badge {
        padding: 0.35rem 0.65rem;
        font-weight: 500;
        font-size: 11px;
    }

    .card {
        transition: box-shadow 0.3s ease;
    }

    .card:hover {
        box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.1) !important;
    }

    .input-group-text {
        background-color: #f8f9fa;
        border-left: none;
    }

    .input-group .form-control {
        border-right: none;
    }

    .input-group .form-control:focus {
        border-color: #ced4da;
        box-shadow: none;
    }

    .input-group .form-control:focus + .input-group-text {
        border-color: #80bdff;
    }

    /* Disabled select styling */
    .form-select:disabled {
        background-color: #e9ecef;
        cursor: not-allowed;
        opacity: 0.6;
    }

    /* Badge info color adjustment */
    .badge.bg-info {
        font-size: 0.75rem;
        padding: 0.25rem 0.5rem;
    }

    @media (max-width: 768px) {
        .students-table {
            font-size: 12px;
        }

        .students-table thead {
            display: none;
        }

        .students-table tbody tr {
            display: block;
            margin-bottom: 1rem;
            border: 1px solid #dee2e6;
            border-radius: 0.25rem;
        }

        .students-table tbody td {
            display: block;
            text-align: right;
            padding: 0.75rem 1rem;
            border-bottom: 1px solid #f0f0f0;
        }

        .students-table tbody td:last-child {
            border-bottom: none;
        }

        .action-cell {
            justify-content: flex-end !important;
        }
    }
</style>
