<div>
    <div class="page-content">
        <div class="main-wrapper">

            @if(!$student)
                <div class="text-center py-5">
                    <p class="text-muted">Estudante não encontrado.</p>
                    <a href="{{ route('guardian.dashboard') }}" class="btn btn-outline-primary btn-sm">
                        <i class="fas fa-arrow-left me-1"></i>Voltar
                    </a>
                </div>
            @else

            <!-- Student Banner -->
            <div class="card border-0 shadow-sm mb-4" style="background:linear-gradient(135deg,#1e40af,#3b82f6);">
                <div class="card-body p-4 text-white">
                    <div class="d-flex align-items-center gap-3">
                        <a href="{{ route('guardian.dashboard') }}" class="text-white me-1" title="Voltar">
                            <i class="fas fa-arrow-left fa-lg"></i>
                        </a>
                        @if($student->avatar && Str::startsWith($student->avatar, 'http'))
                            <img src="{{ $student->avatar }}" alt="{{ $student->name }}"
                                 class="rounded-circle" style="width:60px;height:60px;object-fit:cover;border:2px solid rgba(255,255,255,.3);">
                        @else
                            <div class="rounded-circle d-flex align-items-center justify-content-center"
                                 style="width:60px;height:60px;background:rgba(255,255,255,.2);font-size:22px;">
                                <i class="fas fa-user"></i>
                            </div>
                        @endif
                        <div>
                            <h4 class="mb-0 fw-bold">{{ $student->name }}</h4>
                            <p class="mb-0 opacity-75 small">
                                Código: <strong>{{ $student->student_id ?? 'N/A' }}</strong>
                                &nbsp;|&nbsp;
                                {{ $student->classroom?->class ?? 'N/A' }}ª {{ $student->classroom?->name ?? '' }}
                            </p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Summary Cards -->
            <div class="row g-3 mb-4">
                <div class="col-md-3">
                    <div class="card border-0 shadow-sm text-center py-4">
                        <div class="rounded-circle mx-auto mb-2 d-flex align-items-center justify-content-center" style="width:48px;height:48px;background:#dbeafe;">
                            <i class="fas fa-check-circle text-primary"></i>
                        </div>
                        <h4 class="fw-bold text-primary mb-0">{{ $paid_count }}</h4>
                        <p class="text-muted small mb-0">Pagamentos feitos</p>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card border-0 shadow-sm text-center py-4">
                        <div class="rounded-circle mx-auto mb-2 d-flex align-items-center justify-content-center" style="width:48px;height:48px;background:#fef3c7;">
                            <i class="fas fa-exclamation-triangle text-warning"></i>
                        </div>
                        <h4 class="fw-bold text-warning mb-0">{{ $pending_count }}</h4>
                        <p class="text-muted small mb-0">Mensalidades pendentes</p>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card border-0 shadow-sm text-center py-4">
                        <div class="rounded-circle mx-auto mb-2 d-flex align-items-center justify-content-center" style="width:48px;height:48px;background:#d1fae5;">
                            <i class="fas fa-money-bill-wave text-success"></i>
                        </div>
                        <h4 class="fw-bold text-success mb-0 small">MT {{ number_format($total_paid, 2, ',', '.') }}</h4>
                        <p class="text-muted small mb-0">Total pago</p>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card border-0 shadow-sm text-center py-4">
                        <div class="rounded-circle mx-auto mb-2 d-flex align-items-center justify-content-center" style="width:48px;height:48px;background:#ede9fe;">
                            <i class="fas fa-bell text-purple" style="color:#7c3aed;"></i>
                        </div>
                        <h4 class="fw-bold mb-0" style="color:#7c3aed;">{{ $recent_notices->count() }}</h4>
                        <p class="text-muted small mb-0">Comunicados activos</p>
                    </div>
                </div>
            </div>

            <!-- Quick Links + Recent Notices -->
            <div class="row g-3">
                <div class="col-md-6">
                    <div class="card border-0 shadow-sm h-100">
                        <div class="card-header bg-white py-3">
                            <h6 class="mb-0 fw-semibold"><i class="fas fa-bolt me-2 text-primary"></i>Acesso Rápido</h6>
                        </div>
                        <div class="card-body">
                            <div class="d-grid gap-2">
                                <a href="{{ route('guardian.pagamentos') }}" class="btn btn-outline-primary text-start">
                                    <i class="fas fa-credit-card me-2"></i>Pagamentos
                                    @if($pending_count > 0)
                                        <span class="badge bg-warning text-dark float-end">{{ $pending_count }} pendentes</span>
                                    @endif
                                </a>
                                <a href="{{ route('guardian.notas') }}" class="btn btn-outline-success text-start">
                                    <i class="fas fa-book-open me-2"></i>Notas
                                </a>
                                <a href="{{ route('guardian.presencas') }}" class="btn btn-outline-info text-start">
                                    <i class="fas fa-check-square me-2"></i>Presenças
                                </a>
                                <a href="{{ route('guardian.comunicados') }}" class="btn btn-outline-secondary text-start">
                                    <i class="fas fa-bell me-2"></i>Comunicados
                                </a>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="card border-0 shadow-sm h-100">
                        <div class="card-header bg-white py-3">
                            <h6 class="mb-0 fw-semibold"><i class="fas fa-bell me-2 text-warning"></i>Últimos Comunicados</h6>
                        </div>
                        <div class="card-body p-0">
                            @forelse($recent_notices as $notice)
                            <div class="p-3 border-bottom">
                                <div class="fw-semibold small">{{ $notice->title }}</div>
                                <div class="text-muted" style="font-size:0.78rem;">{{ Str::limit($notice->description, 80) }}</div>
                                <div class="text-muted" style="font-size:0.72rem;">{{ $notice->created_at->diffForHumans() }}</div>
                            </div>
                            @empty
                            <div class="text-center py-4 text-muted small">
                                <i class="fas fa-inbox fa-2x d-block mb-2"></i>Sem comunicados recentes.
                            </div>
                            @endforelse
                            @if($recent_notices->count() > 0)
                            <div class="p-3">
                                <a href="{{ route('guardian.comunicados') }}" class="btn btn-sm btn-outline-secondary w-100">Ver todos</a>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>

            @endif
        </div>
    </div>
</div>
