<div class="page-content">
    <div class="main-wrapper">
        <div>
            <!-- Header -->
            <div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:30px;flex-wrap:wrap;gap:1rem;">
                <div>
                    <h2 style="margin:0;font-size:26px;color:#333;font-weight:700;">
                        <i class="fas fa-receipt"></i> Histórico de Pagamentos
                    </h2>
                    @if($active_student)
                        <p style="margin:4px 0 0;color:#6c757d;font-size:14px;">
                            <i class="fas fa-user-graduate me-1"></i>
                            {{ $active_student->name }}
                            @if($active_student->classroom)
                                &nbsp;·&nbsp; {{ $active_student->classroom->class }}ª Turma {{ $active_student->classroom->name }}
                            @endif
                        </p>
                    @endif
                </div>
                <div>
                    <label for="yearFilterGuardian" style="display:block;font-size:12px;margin-bottom:5px;color:#666;font-weight:500;">Ano Letivo</label>
                    <select id="yearFilterGuardian" class="form-select" wire:model="selectedYear" style="min-width:140px;padding:8px 12px;border-radius:8px;border:1px solid #ddd;">
                        @for($i = now()->year; $i >= now()->year - 5; $i--)
                            <option value="{{ $i }}">{{ $i }}</option>
                        @endfor
                    </select>
                </div>
            </div>

            @if(!$active_student)
                <div class="alert alert-info text-center py-4">
                    <i class="fas fa-info-circle fa-2x mb-2 d-block"></i>
                    Nenhum estudante seleccionado.
                </div>
            @else

            <!-- Summary Cards -->
            @php
                $paidPercentage = $totalExpected > 0 ? round(($totalPaid / $totalExpected) * 100, 1) : 0;
            @endphp
            <div class="summary-cards-grid">
                <div class="summary-card summary-card-total">
                    <div class="summary-card-icon"><i class="fas fa-file-invoice-dollar"></i></div>
                    <div class="summary-card-content">
                        <div class="summary-card-label">Total</div>
                        <div class="summary-card-value">{{ number_format($totalExpected, 2, ',', '.') }}</div>
                        <div class="summary-card-currency">MT</div>
                    </div>
                </div>
                <div class="summary-card summary-card-paid">
                    <div class="summary-card-icon"><i class="fas fa-check-circle"></i></div>
                    <div class="summary-card-content">
                        <div class="summary-card-label">Total Pago</div>
                        <div class="summary-card-value">{{ number_format($totalPaid, 2, ',', '.') }}</div>
                        <div class="summary-card-currency">MT</div>
                        @if($paidPercentage > 0)
                            <div class="summary-card-badge">{{ $paidPercentage }}%</div>
                        @endif
                    </div>
                </div>
                <div class="summary-card summary-card-pending">
                    <div class="summary-card-icon"><i class="fas fa-clock"></i></div>
                    <div class="summary-card-content">
                        <div class="summary-card-label">Pendente</div>
                        <div class="summary-card-value">{{ number_format($totalPending, 2, ',', '.') }}</div>
                        <div class="summary-card-currency">MT</div>
                    </div>
                </div>
                <div class="summary-card summary-card-overdue">
                    <div class="summary-card-icon"><i class="fas fa-exclamation-triangle"></i></div>
                    <div class="summary-card-content">
                        <div class="summary-card-label">Em Atraso</div>
                        <div class="summary-card-value">{{ number_format($totalOverdue, 2, ',', '.') }}</div>
                        <div class="summary-card-currency">MT</div>
                    </div>
                </div>
            </div>

            <!-- Payment list -->
            <div class="fee-section" style="margin-bottom:2rem;">
                <div class="section-header" style="margin-bottom:1.5rem;">
                    <div style="display:flex;justify-content:space-between;align-items:center;flex-wrap:wrap;gap:1rem;">
                        <div>
                            <h2 style="margin:0;font-size:22px;color:#2c3e50;font-weight:600;">
                                <i class="fas fa-file-alt"></i> Detalhes de Pagamento
                            </h2>
                            <p style="margin:5px 0 0;color:#6c757d;font-size:14px;">
                                Total: {{ $payment_references->count() }} referência(s)
                            </p>
                        </div>
                    </div>
                    <!-- Filtros -->
                    <div style="margin-top:1rem;">
                        <div class="fee-filters">
                            <button class="filter-btn active" data-filter-ref="all">Todos</button>
                            <button class="filter-btn" data-filter-ref="paid">Pagos</button>
                            <button class="filter-btn" data-filter-ref="approved">Aprovados</button>
                            <button class="filter-btn" data-filter-ref="pending">Pendentes</button>
                            <button class="filter-btn" data-filter-ref="expired">Expirados</button>
                        </div>
                    </div>
                </div>

                @if($payment_references->count() > 0)
                    <x-payment-references-grouped
                        :references="$payment_references"
                        :showActions="false"
                        :showCheckboxes="false"
                        mode="detailed"
                    />
                @else
                    <div class="alert alert-info" style="text-align:center;padding:2rem;">
                        <i class="fas fa-info-circle" style="font-size:48px;color:#17a2b8;margin-bottom:1rem;"></i>
                        <h4>Nenhum registo encontrado</h4>
                        <p>Não há pagamentos ou referências para {{ $currentYear }}.</p>
                    </div>
                @endif
            </div>
            @endif
        </div>
    </div>
</div>

<style>
.page-content { padding:1.5rem; background-color:#f8f9fa; min-height:100vh; }
.main-wrapper { max-width:1400px; margin:0 auto; background:white; border-radius:12px; padding:2rem; box-shadow:0 2px 8px rgba(0,0,0,.1); }
.summary-cards-grid { display:grid; grid-template-columns:repeat(auto-fit,minmax(220px,1fr)); gap:1.5rem; margin-bottom:3rem; padding-bottom:2rem; border-bottom:2px solid #f0f0f0; }
.summary-card { background:white; border-radius:12px; padding:1.5rem; display:flex; align-items:center; gap:1rem; box-shadow:0 2px 12px rgba(0,0,0,.08); transition:all .3s ease; position:relative; overflow:hidden; }
.summary-card::before { content:''; position:absolute; top:0; left:0; width:4px; height:100%; transition:width .3s ease; }
.summary-card:hover { transform:translateY(-4px); box-shadow:0 4px 20px rgba(0,0,0,.12); }
.summary-card:hover::before { width:8px; }
.summary-card-icon { width:60px; height:60px; border-radius:12px; display:flex; align-items:center; justify-content:center; font-size:24px; flex-shrink:0; }
.summary-card-content { flex:1; position:relative; }
.summary-card-label { font-size:13px; font-weight:500; color:#6c757d; margin-bottom:4px; text-transform:uppercase; letter-spacing:.5px; }
.summary-card-value { font-size:26px; font-weight:700; line-height:1; margin-bottom:2px; }
.summary-card-currency { font-size:12px; font-weight:600; color:#6c757d; letter-spacing:1px; }
.summary-card-badge { position:absolute; top:0; right:0; font-size:11px; font-weight:700; padding:4px 10px; border-radius:12px; letter-spacing:.5px; }
.summary-card-total::before { background:linear-gradient(135deg,#667eea,#764ba2); }
.summary-card-total .summary-card-icon { background:linear-gradient(135deg,#667eea15,#764ba215); color:#667eea; }
.summary-card-total .summary-card-value { color:#667eea; }
.summary-card-paid::before { background:linear-gradient(135deg,#10b981,#059669); }
.summary-card-paid .summary-card-icon { background:linear-gradient(135deg,#10b98115,#05966915); color:#10b981; }
.summary-card-paid .summary-card-value { color:#10b981; }
.summary-card-paid .summary-card-badge { background:linear-gradient(135deg,#10b981,#059669); color:white; }
.summary-card-pending::before { background:linear-gradient(135deg,#f59e0b,#d97706); }
.summary-card-pending .summary-card-icon { background:linear-gradient(135deg,#f59e0b15,#d9770615); color:#f59e0b; }
.summary-card-pending .summary-card-value { color:#f59e0b; }
.summary-card-overdue::before { background:linear-gradient(135deg,#ef4444,#dc2626); }
.summary-card-overdue .summary-card-icon { background:linear-gradient(135deg,#ef444415,#dc262615); color:#ef4444; }
.summary-card-overdue .summary-card-value { color:#ef4444; }
.fee-filters { display:flex; gap:.5rem; flex-wrap:wrap; }
.filter-btn { padding:6px 16px; border:1px solid #dee2e6; background:white; border-radius:6px; cursor:pointer; font-size:13px; font-weight:500; color:#495057; transition:all .2s; }
.filter-btn:hover { background:#f8f9fa; border-color:#667eea; color:#667eea; }
.filter-btn.active { background:#667eea; color:white; border-color:#667eea; }
@media(max-width:768px) {
    .summary-cards-grid { grid-template-columns:1fr 1fr; gap:1rem; }
    .summary-card-value { font-size:20px; }
    .main-wrapper { padding:1rem; }
}
@media(max-width:480px) {
    .summary-cards-grid { grid-template-columns:1fr; }
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const filterBtns = document.querySelectorAll('.filter-btn[data-filter-ref]');
    filterBtns.forEach(btn => {
        btn.addEventListener('click', function() {
            const filter = this.dataset.filterRef;
            filterBtns.forEach(b => b.classList.remove('active'));
            this.classList.add('active');
            document.querySelectorAll('[data-status]').forEach(row => {
                row.style.display = (filter === 'all' || row.dataset.status === filter) ? '' : 'none';
            });
        });
    });
});
</script>
