<div class="enrollment-card">
    <div class="enrollment-header">
        <div class="logo-circle">
            <i class="fas fa-graduation-cap"></i>
        </div>
        <h1>Pré-inscrição Online</h1>
        <p>Colégio Politécnico de Moçambique</p>
    </div>

    <div class="enrollment-body">
        @if($currentStep < 7)
        {{-- Step Indicator --}}
        <div class="step-indicator">
            @for($i = 1; $i <= $totalSteps; $i++)
                <div class="step-dot {{ $i == $currentStep ? 'active' : ($i < $currentStep ? 'completed' : '') }}">
                    @if($i < $currentStep)
                        <i class="fas fa-check" style="font-size: 12px;"></i>
                    @else
                        {{ $i }}
                    @endif
                </div>
                @if($i < $totalSteps)
                    <div class="step-line {{ $i < $currentStep ? 'completed' : '' }}"></div>
                @endif
            @endfor
        </div>
        @endif

        {{-- Step 1: Dados Pessoais --}}
        @if($currentStep == 1)
        <div>
            {{-- OCR: Upload BI para preencher automaticamente --}}
            <div class="mb-4 p-3" style="border: 2px dashed #3b82f6; border-radius: 12px; background: #eff6ff;">
                <div class="row align-items-center">
                    <div class="col-md-5">
                        <h6 class="mb-1" style="font-weight: 600; color: #1e40af; font-size: 0.95rem;">
                            <i class="fas fa-magic me-2"></i>Preencher via BI
                        </h6>
                        <small class="text-muted d-block mb-2">Faça upload do BI para preencher automaticamente</small>
                        <input type="file" class="form-control form-control-sm" wire:model="bi_document" accept="image/*,application/pdf" id="bi_document_public">
                        @if($processing_bi)
                            <div class="mt-2">
                                <span class="spinner-border spinner-border-sm text-primary" role="status"></span>
                                <small class="text-primary ms-1">A processar...</small>
                            </div>
                        @elseif($bi_processed)
                            <span class="badge bg-success mt-2"><i class="fas fa-check me-1"></i>Dados extraídos</span>
                        @endif
                    </div>
                    <div class="col-md-4 mt-2 mt-md-0">
                        <h6 class="mb-1" style="font-weight: 600; color: #64748b; font-size: 0.85rem;">
                            <i class="fas fa-camera me-2"></i>Foto do Candidato
                        </h6>
                        <small class="text-muted d-block mb-2">Upload manual (opcional)</small>
                        <input type="file" class="form-control form-control-sm" wire:model="candidate_photo_upload" accept="image/*">
                    </div>
                    <div class="col-md-3 text-center mt-2 mt-md-0">
                        @if($candidate_photo_upload)
                            <img src="{{ $candidate_photo_upload->temporaryUrl() }}" alt="Foto" style="max-height: 100px; border-radius: 8px; border: 2px solid #3b82f6;">
                            <br><small class="text-muted">Upload manual</small>
                        @elseif($extracted_photo_path)
                            <img src="{{ Storage::url($extracted_photo_path) }}" alt="Foto extraída" style="max-height: 100px; border-radius: 8px; border: 2px solid #27ae60;">
                            <br><small class="text-success"><i class="fas fa-check-circle me-1"></i>Extraída do BI</small>
                        @else
                            <div style="height: 100px; width: 80px; margin: 0 auto; background: #e2e8f0; border-radius: 8px; display: flex; align-items: center; justify-content: center;">
                                <i class="fas fa-user" style="font-size: 2rem; color: #94a3b8;"></i>
                            </div>
                            <small class="text-muted">Sem foto</small>
                        @endif
                    </div>
                </div>
            </div>

            <h5 class="section-title"><i class="fas fa-user me-2"></i>Dados Pessoais</h5>
            <div class="row g-3">
                <div class="col-md-8">
                    <label class="form-label">Nome Completo <span class="text-danger">*</span></label>
                    <input type="text" class="form-control @error('candidate_name') is-invalid @enderror" wire:model="candidate_name" placeholder="Nome completo do candidato">
                    @error('candidate_name') <div class="invalid-feedback">{{ $message }}</div> @enderror
                </div>
                <div class="col-md-4">
                    <label class="form-label">Sexo <span class="text-danger">*</span></label>
                    <select class="form-select @error('candidate_sex') is-invalid @enderror" wire:model="candidate_sex">
                        <option value="">Selecionar</option>
                        <option value="Masculino">Masculino</option>
                        <option value="Feminino">Feminino</option>
                    </select>
                    @error('candidate_sex') <div class="invalid-feedback">{{ $message }}</div> @enderror
                </div>
                <div class="col-md-4">
                    <label class="form-label">Data de Nascimento <span class="text-danger">*</span></label>
                    <input type="date" class="form-control @error('candidate_dob') is-invalid @enderror" wire:model="candidate_dob">
                    @error('candidate_dob') <div class="invalid-feedback">{{ $message }}</div> @enderror
                </div>
                <div class="col-md-4">
                    <label class="form-label">Estado Civil</label>
                    <select class="form-select" wire:model.defer="marital_status">
                        <option value="">Selecionar</option>
                        <option value="Solteiro">Solteiro(a)</option>
                        <option value="Casado">Casado(a)</option>
                    </select>
                </div>
                <div class="col-md-4">
                    <label class="form-label">Nacionalidade</label>
                    <input type="text" class="form-control" wire:model.defer="nationality" placeholder="Moçambicana">
                </div>
                <div class="col-md-4">
                    <label class="form-label">Telefone <span class="text-danger">*</span></label>
                    <input type="text" class="form-control @error('candidate_phone') is-invalid @enderror" wire:model.defer="candidate_phone" placeholder="84XXXXXXX">
                    @error('candidate_phone') <div class="invalid-feedback">{{ $message }}</div> @enderror
                </div>
                <div class="col-md-4">
                    <label class="form-label">Email</label>
                    <input type="email" class="form-control @error('candidate_email') is-invalid @enderror" wire:model.defer="candidate_email" placeholder="email@exemplo.com">
                    @error('candidate_email') <div class="invalid-feedback">{{ $message }}</div> @enderror
                </div>
                <div class="col-md-4">
                    <label class="form-label">NUIT</label>
                    <input type="text" class="form-control" wire:model.defer="nuit" placeholder="Nº Único de Identificação Tributária">
                </div>

                <div class="col-12"><hr class="my-2"></div>
                <div class="col-md-4">
                    <label class="form-label">Doença Crónica?</label>
                    <select class="form-select" wire:model="chronic_disease">
                        <option value="0">Não</option>
                        <option value="1">Sim</option>
                    </select>
                </div>
                @if($chronic_disease)
                <div class="col-md-8">
                    <label class="form-label">Qual doença?</label>
                    <input type="text" class="form-control" wire:model.defer="chronic_disease_details" placeholder="Descreva a doença crónica">
                </div>
                @endif
            </div>
            <div class="d-flex justify-content-end mt-4">
                <button class="btn btn-next" wire:click="nextStep">Seguinte <i class="fas fa-arrow-right ms-1"></i></button>
            </div>
        </div>
        @endif

        {{-- Step 2: Documentos & Ingresso --}}
        @if($currentStep == 2)
        <div>
            <h5 class="section-title"><i class="fas fa-file-alt me-2"></i>Documentos & Ingresso</h5>
            <div class="row g-3">
                <div class="col-md-4">
                    <label class="form-label">Tipo de Documento</label>
                    <select class="form-select" wire:model="document_type">
                        <option value="">Selecionar</option>
                        <option value="BI">Bilhete de Identidade</option>
                        <option value="Cedula">Cédula Pessoal</option>
                        <option value="Passaporte">Passaporte</option>
                    </select>
                </div>
                <div class="col-md-4">
                    <label class="form-label">Número do Documento</label>
                    <input type="text" class="form-control" wire:model="document_id">
                </div>
                <div class="col-md-4">
                    <label class="form-label">Local de Emissão</label>
                    <input type="text" class="form-control" wire:model.defer="document_issue_place" placeholder="Ex: Maputo">
                </div>
                <div class="col-md-4">
                    <label class="form-label">Validade do Documento</label>
                    <input type="date" class="form-control" wire:model.defer="document_expiry_date">
                </div>

                <div class="col-12"><hr class="my-2"><h6 class="text-muted" style="font-size: 0.8rem; font-weight: 600; text-transform: uppercase;">Via de Ingresso</h6></div>
                <div class="col-md-4">
                    <label class="form-label">Via de Ingresso <span class="text-danger">*</span></label>
                    <select class="form-select @error('entry_type') is-invalid @enderror" wire:model="entry_type">
                        <option value="Normal">Normal</option>
                        <option value="Transferencia">Transferência</option>
                        <option value="Reingresso">Reingresso</option>
                    </select>
                    @error('entry_type') <div class="invalid-feedback">{{ $message }}</div> @enderror
                </div>
                @if($entry_type !== 'Normal')
                <div class="col-md-4">
                    <label class="form-label">Instituição de Origem</label>
                    <input type="text" class="form-control" wire:model.defer="previous_institution" placeholder="Escola anterior">
                </div>
                <div class="col-md-4">
                    <label class="form-label">Curso Anterior</label>
                    <input type="text" class="form-control" wire:model.defer="previous_course" placeholder="Curso/classe anterior">
                </div>
                @endif
            </div>
            <div class="d-flex justify-content-between mt-4">
                <button class="btn btn-prev" wire:click="previousStep"><i class="fas fa-arrow-left me-1"></i> Anterior</button>
                <button class="btn btn-next" wire:click="nextStep">Seguinte <i class="fas fa-arrow-right ms-1"></i></button>
            </div>
        </div>
        @endif

        {{-- Step 3: Naturalidade & Morada --}}
        @if($currentStep == 3)
        <div>
            <h5 class="section-title"><i class="fas fa-map-marker-alt me-2"></i>Naturalidade & Morada</h5>
            <div class="row g-3">
                <div class="col-12"><h6 class="text-muted" style="font-size: 0.8rem; font-weight: 600; text-transform: uppercase;">Naturalidade</h6></div>
                <div class="col-md-4">
                    <label class="form-label">Local de Nascimento</label>
                    <input type="text" class="form-control" wire:model="birth_place">
                </div>
                <div class="col-md-4">
                    <label class="form-label">Distrito</label>
                    <input type="text" class="form-control" wire:model="birth_district">
                </div>
                <div class="col-md-4">
                    <label class="form-label">Província</label>
                    <select class="form-select" wire:model="birth_province">
                        <option value="">Selecionar</option>
                        <option value="Maputo Cidade">Maputo Cidade</option>
                        <option value="Maputo">Maputo</option>
                        <option value="Gaza">Gaza</option>
                        <option value="Inhambane">Inhambane</option>
                        <option value="Sofala">Sofala</option>
                        <option value="Manica">Manica</option>
                        <option value="Tete">Tete</option>
                        <option value="Zambezia">Zambézia</option>
                        <option value="Nampula">Nampula</option>
                        <option value="Cabo Delgado">Cabo Delgado</option>
                        <option value="Niassa">Niassa</option>
                    </select>
                </div>

                <div class="col-12"><hr class="my-2"><h6 class="text-muted" style="font-size: 0.8rem; font-weight: 600; text-transform: uppercase;">Morada Actual (Residência)</h6></div>
                <div class="col-md-4">
                    <label class="form-label">Província</label>
                    <select class="form-select" wire:model.defer="address_province">
                        <option value="">Selecionar</option>
                        <option value="Maputo Cidade">Maputo Cidade</option>
                        <option value="Maputo">Maputo</option>
                        <option value="Gaza">Gaza</option>
                        <option value="Inhambane">Inhambane</option>
                        <option value="Sofala">Sofala</option>
                        <option value="Manica">Manica</option>
                        <option value="Tete">Tete</option>
                        <option value="Zambezia">Zambézia</option>
                        <option value="Nampula">Nampula</option>
                        <option value="Cabo Delgado">Cabo Delgado</option>
                        <option value="Niassa">Niassa</option>
                    </select>
                </div>
                <div class="col-md-4">
                    <label class="form-label">Distrito</label>
                    <input type="text" class="form-control" wire:model.defer="address_district">
                </div>
                <div class="col-md-4">
                    <label class="form-label">Bairro</label>
                    <input type="text" class="form-control" wire:model.defer="address_bairro">
                </div>
                <div class="col-md-6">
                    <label class="form-label">Rua / Avenida</label>
                    <input type="text" class="form-control" wire:model.defer="address_street">
                </div>
                <div class="col-md-2">
                    <label class="form-label">Nº Casa</label>
                    <input type="text" class="form-control" wire:model.defer="address_house_number">
                </div>
                <div class="col-md-4">
                    <label class="form-label">WhatsApp</label>
                    <input type="text" class="form-control" wire:model.defer="candidate_whatsapp" placeholder="84XXXXXXX">
                </div>
                <div class="col-12">
                    <label class="form-label">Morada Completa (alternativa)</label>
                    <input type="text" class="form-control" wire:model.defer="candidate_address" placeholder="Endereço completo">
                </div>
            </div>
            <div class="d-flex justify-content-between mt-4">
                <button class="btn btn-prev" wire:click="previousStep"><i class="fas fa-arrow-left me-1"></i> Anterior</button>
                <button class="btn btn-next" wire:click="nextStep">Seguinte <i class="fas fa-arrow-right ms-1"></i></button>
            </div>
        </div>
        @endif

        {{-- Step 4: Filiação --}}
        @if($currentStep == 4)
        <div>
            <h5 class="section-title"><i class="fas fa-users me-2"></i>Filiação</h5>
            <div class="row g-3">
                <div class="col-md-6">
                    <label class="form-label">Nome do Pai</label>
                    <input type="text" class="form-control" wire:model="father_name">
                </div>
                <div class="col-md-6">
                    <label class="form-label">Telefone do Pai</label>
                    <input type="text" class="form-control" wire:model.defer="father_phone" placeholder="84XXXXXXX">
                </div>
                <div class="col-md-6">
                    <label class="form-label">Nome da Mãe</label>
                    <input type="text" class="form-control" wire:model="mother_name">
                </div>
                <div class="col-md-6">
                    <label class="form-label">Telefone da Mãe</label>
                    <input type="text" class="form-control" wire:model.defer="mother_phone" placeholder="84XXXXXXX">
                </div>
            </div>
            <div class="d-flex justify-content-between mt-4">
                <button class="btn btn-prev" wire:click="previousStep"><i class="fas fa-arrow-left me-1"></i> Anterior</button>
                <button class="btn btn-next" wire:click="nextStep">Seguinte <i class="fas fa-arrow-right ms-1"></i></button>
            </div>
        </div>
        @endif

        {{-- Step 5: Encarregado de Educação --}}
        @if($currentStep == 5)
        <div>
            <h5 class="section-title"><i class="fas fa-user-tie me-2"></i>Encarregado de Educação</h5>
            <div class="row g-3">
                <div class="col-md-6">
                    <label class="form-label">Nome do Encarregado</label>
                    <input type="text" class="form-control" wire:model.defer="guardian_name">
                </div>
                <div class="col-md-3">
                    <label class="form-label">Parentesco</label>
                    <select class="form-select" wire:model.defer="guardian_relationship">
                        <option value="">Selecionar</option>
                        <option value="Pai">Pai</option>
                        <option value="Mae">Mãe</option>
                        <option value="Tio/a">Tio/a</option>
                        <option value="Avo/o">Avó/ô</option>
                        <option value="Irmao/a">Irmão/ã</option>
                        <option value="Outro">Outro</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <label class="form-label">Telefone</label>
                    <input type="text" class="form-control" wire:model.defer="guardian_phone" placeholder="84XXXXXXX">
                </div>
                <div class="col-md-6">
                    <label class="form-label">Email</label>
                    <input type="email" class="form-control" wire:model.defer="guardian_email">
                </div>
                <div class="col-md-6">
                    <label class="form-label">Morada</label>
                    <input type="text" class="form-control" wire:model.defer="guardian_address">
                </div>

                <div class="col-12"><hr class="my-2"><h6 class="text-muted" style="font-size: 0.8rem; font-weight: 600; text-transform: uppercase;"><i class="fas fa-file-signature me-1"></i> Dados para o Termo de Compromisso (opcional)</h6></div>
                <div class="col-md-4">
                    <label class="form-label">Nº BI do Encarregado</label>
                    <input type="text" class="form-control" wire:model.defer="guardian_document_id">
                </div>
                <div class="col-md-4">
                    <label class="form-label">Local de Emissão</label>
                    <input type="text" class="form-control" wire:model.defer="guardian_document_issue_place">
                </div>
                <div class="col-md-4">
                    <label class="form-label">Data de Emissão</label>
                    <input type="date" class="form-control" wire:model.defer="guardian_document_issue_date">
                </div>
                <div class="col-md-4">
                    <label class="form-label">Bairro</label>
                    <input type="text" class="form-control" wire:model.defer="guardian_bairro">
                </div>
                <div class="col-md-4">
                    <label class="form-label">Quarteirão</label>
                    <input type="text" class="form-control" wire:model.defer="guardian_quarteirao">
                </div>
                <div class="col-md-4">
                    <label class="form-label">Local de Trabalho</label>
                    <input type="text" class="form-control" wire:model.defer="guardian_workplace">
                </div>

                <div class="col-12"><hr class="my-2"><h6 class="text-muted" style="font-size: 0.8rem; font-weight: 600; text-transform: uppercase;"><i class="fas fa-phone-alt me-1"></i> Contacto de Emergência</h6></div>
                <div class="col-md-6">
                    <label class="form-label">Nome</label>
                    <input type="text" class="form-control" wire:model.defer="emergency_contact_name" placeholder="Nome do contacto de emergência">
                </div>
                <div class="col-md-6">
                    <label class="form-label">Telefone</label>
                    <input type="text" class="form-control" wire:model.defer="emergency_contact_phone" placeholder="84XXXXXXX">
                </div>
            </div>
            <div class="d-flex justify-content-between mt-4">
                <button class="btn btn-prev" wire:click="previousStep"><i class="fas fa-arrow-left me-1"></i> Anterior</button>
                <button class="btn btn-next" wire:click="nextStep">Seguinte <i class="fas fa-arrow-right ms-1"></i></button>
            </div>
        </div>
        @endif

        {{-- Step 6: Curso/Turma --}}
        @if($currentStep == 6)
        <div>
            <h5 class="section-title"><i class="fas fa-graduation-cap me-2"></i>Curso / Turma</h5>
            <div class="row g-3">
                <div class="col-md-4">
                    <label class="form-label">Classe Pretendida <span class="text-danger">*</span></label>
                    <select class="form-select @error('desired_class') is-invalid @enderror" wire:model="desired_class">
                        <option value="">Selecionar</option>
                        @foreach($availableClasses as $cls)
                            <option value="{{ $cls }}">{{ $cls }}a Classe</option>
                        @endforeach
                    </select>
                    @error('desired_class') <div class="invalid-feedback">{{ $message }}</div> @enderror
                </div>
                <div class="col-md-4">
                    <label class="form-label">Turma</label>
                    <select class="form-select" wire:model.defer="desired_classroom_id">
                        <option value="">Selecionar</option>
                        @foreach($classrooms as $classroom)
                            <option value="{{ $classroom->id }}">{{ $classroom->name }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-4">
                    <label class="form-label">Turno</label>
                    <select class="form-select" wire:model.defer="desired_shift">
                        <option value="">Selecionar</option>
                        <option value="Diurno">Diurno</option>
                        <option value="Tarde">Tarde</option>
                    </select>
                </div>
                <div class="col-md-4">
                    <label class="form-label">Ano Lectivo <span class="text-danger">*</span></label>
                    <select class="form-select @error('academic_year') is-invalid @enderror" wire:model.defer="academic_year">
                        @for($y = date('Y'); $y <= date('Y') + 2; $y++)
                            <option value="{{ $y }}">{{ $y }}</option>
                        @endfor
                    </select>
                    @error('academic_year') <div class="invalid-feedback">{{ $message }}</div> @enderror
                </div>
                <div class="col-12">
                    <label class="form-label">Observações</label>
                    <textarea class="form-control" wire:model.defer="observation" rows="3" placeholder="Informações adicionais (opcional)"></textarea>
                </div>
            </div>
            <div class="d-flex justify-content-between mt-4">
                <button class="btn btn-prev" wire:click="previousStep"><i class="fas fa-arrow-left me-1"></i> Anterior</button>
                <button class="btn btn-submit" wire:click="submit">
                    <i class="fas fa-paper-plane me-1"></i> Submeter Pré-inscrição
                </button>
            </div>
        </div>
        @endif

        {{-- Step 7: Success --}}
        @if($currentStep == 7)
        <div class="success-card">
            <div class="success-icon">
                <i class="fas fa-check-circle"></i>
            </div>
            <h4 style="color: #1e293b; font-weight: 600;">Pré-inscrição Submetida!</h4>
            <p class="text-muted mb-3">A sua pré-inscrição foi recebida com sucesso. Guarde o código abaixo para acompanhamento.</p>
            <div class="code-display mb-3">{{ $submittedCode }}</div>
            <p class="text-muted" style="font-size: 0.85rem;">
                <i class="fas fa-info-circle me-1"></i>
                Baixe a ficha de inscrição, assine e envie por email para a secretaria.
            </p>
            <div class="d-flex justify-content-center gap-3 mt-3">
                @if($submittedId)
                <a href="{{ route('pre-enrollment.pdf', $submittedId) }}" class="btn" style="background: #e74a3b; color: white; font-weight: 600; border-radius: 8px; padding: 10px 25px;" target="_blank">
                    <i class="fas fa-file-pdf me-2"></i> Baixar Ficha de Inscrição
                </a>
                @endif
                <a href="{{ route('pre-enrollment.public') }}" class="btn btn-next">
                    <i class="fas fa-plus me-1"></i> Nova Pré-inscrição
                </a>
            </div>
        </div>
        @endif
    </div>

    {{-- PDF.js: converter PDF para imagem antes de enviar ao Livewire --}}
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdf.js/3.11.174/pdf.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const input = document.getElementById('bi_document_public');
            if (!input) return;

            input.addEventListener('change', function (e) {
                const file = e.target.files[0];
                if (!file || file.type !== 'application/pdf') return;

                e.preventDefault();
                const reader = new FileReader();
                reader.onload = async function () {
                    const pdf = await pdfjsLib.getDocument({ data: new Uint8Array(reader.result) }).promise;
                    const page = await pdf.getPage(1);
                    const scale = 2;
                    const viewport = page.getViewport({ scale });
                    const canvas = document.createElement('canvas');
                    canvas.width = viewport.width;
                    canvas.height = viewport.height;
                    const ctx = canvas.getContext('2d');
                    await page.render({ canvasContext: ctx, viewport }).promise;
                    canvas.toBlob(function (blob) {
                        const dt = new DataTransfer();
                        dt.items.add(new File([blob], file.name.replace('.pdf', '.png'), { type: 'image/png' }));
                        input.files = dt.files;
                        input.dispatchEvent(new Event('change', { bubbles: true }));
                    }, 'image/png', 0.95);
                };
                reader.readAsArrayBuffer(file);
            }, { once: false });
        });
    </script>
</div>
