<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Relatório de Presenças</title>
    <style>
        @page {
            size: A4 portrait;
            margin: 10mm 15mm 15mm 15mm;
        }
        * { box-sizing: border-box; }
        body {
            font-family: 'Times New Roman', Times, serif;
            color: #000;
            font-size: 10pt;
            line-height: 1.3;
            margin: 0;
            padding: 0;
        }
        .header {
            text-align: center;
            border-bottom: 3px solid #1a5276;
            padding-bottom: 8px;
            margin-bottom: 15px;
        }
        .header h1 {
            font-size: 14pt;
            margin: 0;
            color: #1a5276;
            font-weight: bold;
        }
        .header h2 {
            font-size: 12pt;
            margin: 5px 0 0;
            color: #333;
        }
        .header p {
            font-size: 9pt;
            margin: 4px 0 0;
            color: #666;
        }
        .info-box {
            background: #f8f9fa;
            border: 1px solid #dee2e6;
            padding: 8px 12px;
            margin-bottom: 12px;
            font-size: 9pt;
        }
        .info-box span {
            margin-right: 20px;
        }
        .info-box strong {
            color: #1a5276;
        }
        .summary-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 15px;
        }
        .summary-table td {
            text-align: center;
            padding: 8px;
            border: 1px solid #dee2e6;
            font-size: 9pt;
        }
        .summary-table .label {
            font-weight: bold;
            color: #666;
            font-size: 8pt;
            text-transform: uppercase;
        }
        .summary-table .value {
            font-size: 16pt;
            font-weight: bold;
        }
        .green { color: #27ae60; }
        .red { color: #e74c3c; }
        .yellow { color: #f39c12; }
        .blue { color: #3498db; }
        table.records {
            width: 100%;
            border-collapse: collapse;
            font-size: 9pt;
        }
        table.records th {
            background: #1a5276;
            color: white;
            padding: 6px 8px;
            text-align: left;
            font-size: 8pt;
            text-transform: uppercase;
        }
        table.records td {
            padding: 5px 8px;
            border-bottom: 1px solid #eee;
        }
        table.records tr:nth-child(even) {
            background: #f9f9f9;
        }
        .badge {
            display: inline-block;
            padding: 2px 8px;
            border-radius: 10px;
            font-size: 8pt;
            font-weight: bold;
        }
        .badge-present { background: #d4edda; color: #155724; }
        .badge-absent { background: #f8d7da; color: #721c24; }
        .badge-late { background: #fff3cd; color: #856404; }
        .badge-justified { background: #d1ecf1; color: #0c5460; }
        .footer {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            text-align: center;
            font-size: 7pt;
            color: #999;
            border-top: 1px solid #ddd;
            padding-top: 4px;
        }
        .section-title {
            font-size: 11pt;
            font-weight: bold;
            color: #1a5276;
            margin: 15px 0 8px;
            border-bottom: 1px solid #dee2e6;
            padding-bottom: 4px;
        }
    </style>
</head>
<body>
    <div class="footer">
        Gerado em {{ now()->format('d/m/Y H:i') }} - COLÉGIO POLITÉCNICO DE MOÇAMBIQUE
    </div>

    <!-- Header -->
    <div class="header">
        <h1>COLÉGIO POLITÉCNICO DE MOÇAMBIQUE</h1>
        <h2>RELATÓRIO DE PRESENÇAS</h2>
        <p>Período: {{ $period }}</p>
    </div>

    <!-- Info Box -->
    <div class="info-box">
        @if(isset($student))
            <span><strong>Estudante:</strong> {{ $student->name }}</span>
            <span><strong>Código:</strong> {{ $student->student_id }}</span>
        @endif
        @if(isset($classroom))
            <span><strong>Classe:</strong> {{ $classroom->class }}ª</span>
            <span><strong>Turma:</strong> {{ $classroom->name }}</span>
        @endif
    </div>

    <!-- Summary -->
    <table class="summary-table">
        <tr>
            <td>
                <div class="label">Total</div>
                <div class="value">{{ $summary['total'] }}</div>
            </td>
            <td>
                <div class="label">Presente</div>
                <div class="value green">{{ $summary['present'] }}</div>
            </td>
            <td>
                <div class="label">Falta</div>
                <div class="value red">{{ $summary['absent'] }}</div>
            </td>
            <td>
                <div class="label">Atraso</div>
                <div class="value yellow">{{ $summary['late'] }}</div>
            </td>
            <td>
                <div class="label">Justificado</div>
                <div class="value blue">{{ $summary['justified'] }}</div>
            </td>
            <td>
                <div class="label">Taxa</div>
                <div class="value" style="color: {{ $summary['rate'] >= 75 ? '#27ae60' : ($summary['rate'] >= 50 ? '#f39c12' : '#e74c3c') }};">
                    {{ $summary['rate'] }}%
                </div>
            </td>
        </tr>
    </table>

    @if($isAdmin && isset($studentBreakdown))
        <!-- Student Breakdown (Admin) -->
        <div class="section-title">Resumo por Estudante</div>
        <table class="records">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Estudante</th>
                    <th style="text-align: center;">Total</th>
                    <th style="text-align: center;">Presente</th>
                    <th style="text-align: center;">Falta</th>
                    <th style="text-align: center;">Atraso</th>
                    <th style="text-align: center;">Justif.</th>
                    <th style="text-align: center;">Taxa</th>
                </tr>
            </thead>
            <tbody>
                @foreach($studentBreakdown as $i => $sb)
                    <tr>
                        <td>{{ $i + 1 }}</td>
                        <td>{{ $sb['name'] }}</td>
                        <td style="text-align: center;">{{ $sb['total'] }}</td>
                        <td style="text-align: center;" class="green">{{ $sb['present'] }}</td>
                        <td style="text-align: center;" class="red">{{ $sb['absent'] }}</td>
                        <td style="text-align: center;" class="yellow">{{ $sb['late'] }}</td>
                        <td style="text-align: center;" class="blue">{{ $sb['justified'] }}</td>
                        <td style="text-align: center;">
                            <span class="badge {{ $sb['rate'] >= 75 ? 'badge-present' : ($sb['rate'] >= 50 ? 'badge-late' : 'badge-absent') }}">
                                {{ $sb['rate'] }}%
                            </span>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    @else
        <!-- Detailed Records (Student) -->
        <div class="section-title">Registos Detalhados</div>
        <table class="records">
            <thead>
                <tr>
                    <th>Data</th>
                    <th>Dia</th>
                    <th>Disciplina</th>
                    <th>Estado</th>
                    <th>Hora</th>
                    <th>Observação</th>
                </tr>
            </thead>
            <tbody>
                @foreach($records as $record)
                    <tr>
                        <td>{{ $record->date->format('d/m/Y') }}</td>
                        <td>{{ $record->date->translatedFormat('l') }}</td>
                        <td>{{ $record->subject ?? 'Geral' }}</td>
                        <td>
                            @switch($record->status)
                                @case('present')
                                    <span class="badge badge-present">Presente</span>
                                    @break
                                @case('absent')
                                    <span class="badge badge-absent">Falta</span>
                                    @break
                                @case('late')
                                    <span class="badge badge-late">Atraso</span>
                                    @break
                                @case('justified')
                                    <span class="badge badge-justified">Justificado</span>
                                    @break
                            @endswitch
                        </td>
                        <td>{{ $record->created_at->format('H:i') }}</td>
                        <td>{{ $record->observation ?? '-' }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    @endif
</body>
</html>
