<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\App;
use Rap2hpoutre\LaravelLogViewer\LogViewerController;
use App\Http\Controllers\ApiController;
use App\Http\Controllers\GuardianApiController;
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/


Route::middleware('api')->group(function () {
    Route::post('login', [ApiController::class, 'login']);
    Route::post('token/{userId}', [ApiController::class, 'storeDeviceToken']);
    Route::post('removeToken', [ApiController::class, 'removeDeviceToken']); // Add this route for removing the device token
    Route::get('exams', [ApiController::class, 'examData']);
    Route::get('matrizes', [ApiController::class, 'listarMatrizes']);
    Route::get('comunicados', [ApiController::class, 'listarComunicados']);
    Route::get('exams/pdf', [ApiController::class, 'generatePdfReport']); // Define the route for generating PDF report
    Route::get('pagamento', [ApiController::class, 'ListarConfirmacoesPagamento']);
    Route::get('getClass', [ApiController::class, 'getUserClassName']);
    Route::get('getUser', [ApiController::class, 'getUserInfo']);
    Route::get('books', [ApiController::class, 'listBooks']);
    Route::post('book/download', [ApiController::class, 'downloadBooks']);

    Route::get('attendance', [ApiController::class, 'getStudentAttendance']);
    Route::get('attendance/pdf', [ApiController::class, 'getStudentAttendancePdf']);

    // Renovação de Matrícula / Reserva de Vaga
    Route::get('renewal/status', [ApiController::class, 'getRenewalStatus']);
    Route::post('renewal/submit', [ApiController::class, 'submitRenewal']);
    Route::get('sendNotification', [ApiController::class, 'sendPushNotification']);

    //updated status of various features
    Route::get('comunicados/{id}', [ApiController::class, 'updateCommunicadoSeen']);

    // ========================================
    // MÓDULO DE PAGAMENTOS API V2 - CONSOLIDADO
    // Todas as rotas de pagamento agora no ApiController
    // ========================================
    Route::prefix('v2')->group(function () {
        // Student payments endpoints
        Route::get('student/payments', [ApiController::class, 'getStudentPayments']);
        Route::get('student/payment-history', [ApiController::class, 'getStudentPaymentHistory']);
        Route::get('student/payments/{id}/receipt', [ApiController::class, 'getStudentReceiptDetails']);
        Route::get('student/payments/{id}/receipt/download', [ApiController::class, 'downloadStudentReceipt']);
        Route::get('student/receipts/statistics', [ApiController::class, 'getStudentReceiptStatistics']);

        // Payment reference endpoints
        Route::post('fees/generate-reference', [ApiController::class, 'generatePaymentReference']);
        Route::get('fees/references', [ApiController::class, 'getPaymentReferences']);
    });

});

// ========================================
// PORTAL DO ENCARREGADO - API
// ========================================
Route::prefix('guardian')->group(function () {
    // Login (sem autenticação)
    Route::post('login', [GuardianApiController::class, 'login']);

    // Rotas autenticadas
    Route::middleware('auth:guardian-api')->group(function () {
        // Perfil
        Route::get('profile', [GuardianApiController::class, 'profile']);
        Route::post('change-password', [GuardianApiController::class, 'changePassword']);

        // Estudantes
        Route::get('students', [GuardianApiController::class, 'listStudents']);
        Route::get('student/{id}', [GuardianApiController::class, 'studentDetail']);
        Route::get('student/{id}/notas', [GuardianApiController::class, 'studentExams']);
        Route::get('student/{id}/pagamentos', [GuardianApiController::class, 'studentPayments']);
        Route::get('student/{id}/presencas', [GuardianApiController::class, 'studentAttendance']);
        Route::post('student/{id}/generate-reference', [GuardianApiController::class, 'generateReference']);
        Route::get('student/{studentId}/receipt/{paymentId}/download', [GuardianApiController::class, 'downloadStudentReceipt']);

        // Comunicados e Matrizes (todos os estudantes)
        Route::get('comunicados', [GuardianApiController::class, 'comunicados']);
        Route::get('matrizes', [GuardianApiController::class, 'matrizes']);

        // Device tokens (FCM push notifications)
        Route::post('device-token', [GuardianApiController::class, 'storeDeviceToken']);
        Route::post('remove-device-token', [GuardianApiController::class, 'removeDeviceToken']);
    });
});

//Route::middleware('auth:api')->get('/user', function (Request $request) {
Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::get('logs', [LogViewerController::class, 'index']);

Route::get('/greeting/{locale}', function (string $locale) {
    if (!in_array($locale, ['pt'])) {
        abort(400);
    }

    App::setLocale($locale);
});

