<?php

namespace App\Http\Livewire\Admin\Classes;

use App\Models\Admin;
use App\Models\Classroom;
use Illuminate\Validation\ValidationException;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Note\Note;

class EditClass extends Component
{
    use FindGuard, LivewireAlert;

    public $name, $user,$description,$class, $model;
    public $validatedData;
    public $updateMode = false;

    protected $listeners = [
        'confirmed',
        'cancelled'
    ];

    public function mount($slug)
    {
        $this->model = Classroom::query()->where('slug',$slug)->first();
        $this->name = $this->model->name;
         $this->class = $this->model->class;
         $this->description = $this->model->description;
    }

    protected array $rules = [
        'name' => ['required', 'string', 'max:255'],
        'class' => ['required', 'string', 'max:255'],
        'description' => ['required', 'string', 'max:255'],
    ];

    /**
     * D0 real time validations
     * @param $propertyName
     * @throws ValidationException
     */
    public function updated($propertyName)
    {
        $this->validateOnly($propertyName);
    }

    public function submit()
    {
        $this->validatedData = $this->validate();
        $this->confirm('Tem certeza de que deseja prosseguir?', [
            'toast' => false,
            'position' => 'center',
            'showConfirmButton' => true,
            'confirmButtonText' => 'Sim, eu tenho certeza!',
            'cancelButtonText' => 'Não, cancelar!',
            'onConfirmed' => 'confirmed',
            'onDismissed' => 'cancelled'
        ]);
    }

    public function confirmed()
    {
        $this->model->fill($this->validatedData);
        if ($this->model->isClean()) {
            $this->alert('warning', 'Pelo menos um valor deve mudar.');
            return redirect()->back();
        }

        $this->model->save();
        Note::createSystemNotification(Admin::class, 'Detalhes', 'Atualizado com sucesso ' . $this->name);
        $this->emit('noteAdded');
        $this->alert('success', 'Atualizado com sucesso ' . $this->name);
        $this->reset();
        return redirect()->route('admin.list.classes');
    }

    public function cancelled()
    {
        $this->alert('error', 'Você cancelou.');
    }
    public function render()
    {
        return view('livewire.admin.classes.edit-class');
    }
}
