<?php

namespace App\Http\Livewire\Admin\Classes;

use App\Models\Classroom;
use App\Models\Project;
use App\Models\User;
use App\Models\Exam;
use Illuminate\Validation\ValidationException;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Livewire\WithPagination;
use Note\Note;


class ListClassStudents extends Component
{
    protected $lazy = false;
    use FindGuard, LivewireAlert;
    use WithPagination;

    public $search;
    public $model, $project, $name,$year;
    protected $queryString = ['search'];

    protected string $paginationTheme = 'bootstrap';

    public function updatingSearch()
    {
        $this->resetPage();
    }

    public bool $readyToLoad = false;

    public function loadData()
    {
        $this->readyToLoad = true;
    }

    public function mount($slug)
    {
        $this->model = Classroom::query()->where('slug', $slug)->first();
        $this->name = $this->model->name;
    }

    public function render()
{
    if(!empty($this->year)  ){
        $users = Exam::where("trimester_id","1")->where("year",$this->year)->where("classroom_id",$this->model->id)->distinct()->pluck('student_id');
        $userss = array();
        foreach($users as $user){
            $userss[] = $user;
        }
        //dd($this->model->id,$userss);    
        return view('livewire.admin.classes.list-class-students', [
        'models' => $this->readyToLoad
            ? User::query()
                ->where(function ($query) {
                    $query->orWhere('name', 'like', '%' . $this->search . '%')
                        ->orWhere('sex', 'like', '%' . $this->search . '%')
                        ->orWhere('phone_number', 'like', '%' . $this->search . '%')
                        ->orWhere('year_edu', $this->search )
                        ->orWhere('slug', 'like', '%' . $this->search . '%');
                })
                ->whereIn('id', $userss)
                ->orderBy('name') // Order by the 'name' column alphabetically
                ->paginate(10)
                
            : []
        ]);
    }else{
        return view('livewire.admin.classes.list-class-students', [
        'models' => $this->readyToLoad
            ? User::query()
                ->where(function ($query) {
                    $query->orWhere('name', 'like', '%' . $this->search . '%')
                        ->orWhere('sex', 'like', '%' . $this->search . '%')
                        ->orWhere('phone_number', 'like', '%' . $this->search . '%')
                        ->orWhere('year_edu', $this->search )
                        ->orWhere('slug', 'like', '%' . $this->search . '%');
                })
                ->where('classroom_id', $this->model->id)
                ->orderBy('name') // Order by the 'name' column alphabetically
                ->paginate(10)
                
            : []
        ]);

    }
    
}

}
