<div>
    <div class="page-content" wire:init="loadData">
        @if ($user->role == 0)
            <div class="main-wrapper" wire:init="loadData">
                <div class="row">
                    <div class="col-md-3 col-xl-3">
                        <a href="{{ route('admin.list.students') }}">
                            <div class="card stat-widget">
                                <div class="card-body">
                                    <h5 class="card-title">Estudantes</h5>
                                    <h2>{{ $students }}</h2>
                                    <h1><i class="fa fa-users"></i></h1>
                                </div>
                            </div>
                        </a>
                    </div>
                    <div class="col-md-3 col-xl-3">
                        <a href="{{ route('admin.list.classes') }}">
                            <div class="card stat-widget">
                                <div class="card-body">
                                    <h5 class="card-title">Turmas</h5>
                                    <h2>{{ $classes }}</h2>
                                    <h1><i class="fa fa-clock"></i></h1>
                                </div>
                            </div>
                        </a>
                    </div>
                    <div class="col-md-3 col-xl-3">
                        <a href="{{ route('admin.list.subjects') }}">
                            <div class="card stat-widget">
                                <div class="card-body">
                                    <h5 class="card-title">Disciplinas</h5>
                                    <h2>{{ $subjects }}</h2>
                                    <h1><i class="fa fa-briefcase"></i></h1>
                                </div>
                            </div>
                        </a>
                    </div>
                    <div class="col-md-3 col-xl-3">
                        <a href="{{ route('admin.list.admins') }}">
                            <div class="card stat-widget">
                                <div class="card-body">
                                    <h5 class="card-title">Staff</h5>
                                    <h2>{{ $admins }}</h2>
                                    <h1><i class="fa fa-handshake"></i></h1>
                                </div>
                            </div>
                        </a>
                    </div>
                </div>               
                <div class="row" wire:ignore>
                    <div class="col-sm-8 col-xl-8">
                        <div class="card">
                            <div class="card-body">
                                <h5 class="card-title">Coleções semanais</h5>
                                <div id="chart3" style="height: 300px;" wire:ignore>{!! $chart3->container() !!}</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-4 col-xl-4">
                        <div class="card">
                            <div class="card-body">
                                <h5 class="card-title">Visão geral</h5>
                                <div id="seo_pie_chart" style="height: 300px;" wire:ignore>{!! $seo_pie_chart->container() !!}</div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @elseif ($user->role == 2)
            <div class="main-wrapper" wire:init="loadData">
                <div class="row">
                    <div class="col-md-12 col-xl-12">
                        <a href="">
                            <div class="card stat-widget">
                                <div class="card-body">
                                    <h5 class="card-title">Turmas</h5>
                                    <h2>{{ $teacher_class}}</h2>
                                    <h1><i class="fa fa-clock"></i></h1>
                                </div>
                            </div>
                        </a>
                    </div>
                </div>
            </div>
        @elseif ($user->role == 1)
            <div class="main-wrapper" wire:init="loadData">
                <div class="row">
                    <div class="col-md-4 col-xl-4">
                        <a href="">
                            <div class="card stat-widget">
                                <div class="card-body">
                                    <h5 class="card-title">Estudantes</h5>
                                    <h2>{{ $students }}</h2>
                                    <h1><i class="fa fa-users"></i></h1>
                                </div>
                            </div>
                        </a>
                    </div>
                    <div class="col-md-4 col-xl-4">
                        <a href="#">
                            <div class="card stat-widget">
                                <div class="card-body">
                                    <h5 class="card-title">Turmas</h5>
                                    <h2>{{ $classes }}</h2>
                                    <h1><i class="fa fa-clock"></i></h1>
                                </div>
                            </div>
                        </a>
                    </div>
                    <div class="col-md-4 col-xl-4">
                        <a href="">
                            <div class="card stat-widget">
                                <div class="card-body">
                                    <h5 class="card-title">Staff</h5>
                                    <h2>{{ $admins }}</h2>
                                    <h1><i class="fa fa-handshake"></i></h1>
                                </div>
                            </div>
                        </a>
                    </div>
                </div>
            </div>
        @else
            <div class="main-wrapper" wire:init="loadData">
                <div class="row">
                    <div class="col-md-3 col-xl-3">
                        <a href="">
                            <div class="card stat-widget">
                                <div class="card-body">
                                    <h5 class="card-title">Estudantes</h5>
                                    <h2>{{ $students }}</h2>
                                    <h1><i class="fa fa-users"></i></h1>
                                </div>
                            </div>
                        </a>
                    </div>
                    <div class="col-md-3 col-xl-3">
                        <a href="">
                            <div class="card stat-widget">
                                <div class="card-body">
                                    <h5 class="card-title">Turmas</h5>
                                    <h2>{{ $classes }}</h2>
                                    <h1><i class="fa fa-clock"></i></h1>
                                </div>
                            </div>
                        </a>
                    </div>
                    <div class="col-md-3 col-xl-3">
                        <a href="">
                            <div class="card stat-widget">
                                <div class="card-body">
                                    <h5 class="card-title">Disciplinas</h5>
                                    <h2>{{ $subjects }}</h2>
                                    <h1><i class="fa fa-briefcase"></i></h1>
                                </div>
                            </div>
                        </a>
                    </div>
                    <div class="col-md-3 col-xl-3">
                        <a href="">
                            <div class="card stat-widget">
                                <div class="card-body">
                                    <h5 class="card-title">Staff</h5>
                                    <h2>{{ $admins }}</h2>
                                    <h1><i class="fa fa-handshake"></i></h1>
                                </div>
                            </div>
                        </a>
                    </div>
                </div>
            </div>
        @endif
        
    </div>
    @section('scripts')
        <script src="https://unpkg.com/vue"></script>
        <script>
            var app = new Vue({
                el: '#chart3',
            });
            var app = new Vue({
                el: '#seo_pie_chart',
            });
        </script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.7.1/Chart.min.js" charset="utf-8"></script>
        {!! $chart3->script() !!}
        {!! $seo_pie_chart->script() !!}
    @endsection
</div>
